/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum ReceivedDocumentType {
    EXPENSE("expense"),
    PASSIVE_CREDIT_NOTE("passive_credit_note"),
    PASSIVE_DELIVERY_NOTE("passive_delivery_note"),
    SELF_INVOICE("self_invoice");

    private String value;

    private ReceivedDocumentType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReceivedDocumentType fromValue(String value) {
        for (ReceivedDocumentType b : ReceivedDocumentType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        ReceivedDocumentType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<ReceivedDocumentType> {
        public void write(JsonWriter jsonWriter, ReceivedDocumentType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public ReceivedDocumentType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return ReceivedDocumentType.fromValue(value);
        }
    }
}

