/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum IssuedDocumentType {
    INVOICE("invoice"),
    QUOTE("quote"),
    PROFORMA("proforma"),
    RECEIPT("receipt"),
    DELIVERY_NOTE("delivery_note"),
    CREDIT_NOTE("credit_note"),
    ORDER("order"),
    WORK_REPORT("work_report"),
    SUPPLIER_ORDER("supplier_order"),
    SELF_OWN_INVOICE("self_own_invoice"),
    SELF_SUPPLIER_INVOICE("self_supplier_invoice");

    private String value;

    private IssuedDocumentType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IssuedDocumentType fromValue(String value) {
        for (IssuedDocumentType b : IssuedDocumentType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        IssuedDocumentType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<IssuedDocumentType> {
        public void write(JsonWriter jsonWriter, IssuedDocumentType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public IssuedDocumentType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return IssuedDocumentType.fromValue(value);
        }
    }
}

