/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum EntityType {
    COMPANY("company"),
    PERSON("person"),
    PA("pa"),
    CONDO("condo");

    private String value;

    private EntityType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EntityType fromValue(String value) {
        for (EntityType b : EntityType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return null;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        EntityType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<EntityType> {
        public void write(JsonWriter jsonWriter, EntityType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public EntityType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return EntityType.fromValue(value);
        }
    }
}

