/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.model;

import com.google.gson.annotations.SerializedName;
import it.fattureincloud.sdk.model.CompanyType;
import it.fattureincloud.sdk.model.ControlledCompany;
import it.fattureincloud.sdk.model.FattureInCloudPlanType;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class Company
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private Integer id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private CompanyType type;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_CONTROLLED_COMPANIES = "controlled_companies";
    @SerializedName(value="controlled_companies")
    private List<ControlledCompany> controlledCompanies;
    public static final String SERIALIZED_NAME_FIC_LICENSE_EXPIRE = "fic_license_expire";
    @SerializedName(value="fic_license_expire")
    private LocalDate ficLicenseExpire;
    public static final String SERIALIZED_NAME_FIC_PLAN = "fic_plan";
    @SerializedName(value="fic_plan")
    private FattureInCloudPlanType ficPlan;
    public static final String SERIALIZED_NAME_CONNECTION_ID = "connection_id";
    @SerializedName(value="connection_id")
    private Integer connectionId;
    public static final String SERIALIZED_NAME_TAX_CODE = "tax_code";
    @SerializedName(value="tax_code")
    private String taxCode;
    public static final String SERIALIZED_NAME_VAT_NUMBER = "vat_number";
    @SerializedName(value="vat_number")
    private String vatNumber;

    public Company id(Integer id) {
        this.id = id;
        return this;
    }

    @Nullable
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Company name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Company type(CompanyType type) {
        this.type = type;
        return this;
    }

    @Nullable
    public CompanyType getType() {
        return this.type;
    }

    public void setType(CompanyType type) {
        this.type = type;
    }

    public Company accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Nullable
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public Company controlledCompanies(List<ControlledCompany> controlledCompanies) {
        this.controlledCompanies = controlledCompanies;
        return this;
    }

    public Company addControlledCompaniesItem(ControlledCompany controlledCompaniesItem) {
        if (this.controlledCompanies == null) {
            this.controlledCompanies = new ArrayList<ControlledCompany>();
        }
        this.controlledCompanies.add(controlledCompaniesItem);
        return this;
    }

    @Nullable
    public List<ControlledCompany> getControlledCompanies() {
        return this.controlledCompanies;
    }

    public void setControlledCompanies(List<ControlledCompany> controlledCompanies) {
        this.controlledCompanies = controlledCompanies;
    }

    public Company ficLicenseExpire(LocalDate ficLicenseExpire) {
        this.ficLicenseExpire = ficLicenseExpire;
        return this;
    }

    @Nullable
    public LocalDate getFicLicenseExpire() {
        return this.ficLicenseExpire;
    }

    public void setFicLicenseExpire(LocalDate ficLicenseExpire) {
        this.ficLicenseExpire = ficLicenseExpire;
    }

    public Company ficPlan(FattureInCloudPlanType ficPlan) {
        this.ficPlan = ficPlan;
        return this;
    }

    @Nullable
    public FattureInCloudPlanType getFicPlan() {
        return this.ficPlan;
    }

    public void setFicPlan(FattureInCloudPlanType ficPlan) {
        this.ficPlan = ficPlan;
    }

    public Company connectionId(Integer connectionId) {
        this.connectionId = connectionId;
        return this;
    }

    @Nullable
    public Integer getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(Integer connectionId) {
        this.connectionId = connectionId;
    }

    public Company taxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @Nullable
    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public Company vatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
        return this;
    }

    @Nullable
    public String getVatNumber() {
        return this.vatNumber;
    }

    public void setVatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Company company = (Company)o;
        return Objects.equals(this.id, company.id) && Objects.equals(this.name, company.name) && Objects.equals((Object)this.type, (Object)company.type) && Objects.equals(this.accessToken, company.accessToken) && Objects.equals(this.controlledCompanies, company.controlledCompanies) && Objects.equals(this.ficLicenseExpire, company.ficLicenseExpire) && Objects.equals((Object)this.ficPlan, (Object)company.ficPlan) && Objects.equals(this.connectionId, company.connectionId) && Objects.equals(this.taxCode, company.taxCode) && Objects.equals(this.vatNumber, company.vatNumber);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.type, this.accessToken, this.controlledCompanies, this.ficLicenseExpire, this.ficPlan, this.connectionId, this.taxCode, this.vatNumber});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Company {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    controlledCompanies: ").append(this.toIndentedString(this.controlledCompanies)).append("\n");
        sb.append("    ficLicenseExpire: ").append(this.toIndentedString(this.ficLicenseExpire)).append("\n");
        sb.append("    ficPlan: ").append(this.toIndentedString((Object)this.ficPlan)).append("\n");
        sb.append("    connectionId: ").append(this.toIndentedString(this.connectionId)).append("\n");
        sb.append("    taxCode: ").append(this.toIndentedString(this.taxCode)).append("\n");
        sb.append("    vatNumber: ").append(this.toIndentedString(this.vatNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

