/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum CashbookEntryKind {
    CASHBOOK("cashbook"),
    ISSUED_DOCUMENT("issued_document"),
    RECEIVED_DOCUMENT("received_document"),
    TAX("tax"),
    RECEIPT("receipt");

    private String value;

    private CashbookEntryKind(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CashbookEntryKind fromValue(String value) {
        for (CashbookEntryKind b : CashbookEntryKind.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        CashbookEntryKind.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<CashbookEntryKind> {
        public void write(JsonWriter jsonWriter, CashbookEntryKind enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public CashbookEntryKind read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return CashbookEntryKind.fromValue(value);
        }
    }
}

