/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.filter;

import it.fattureincloud.sdk.filter.Expression;
import java.util.Objects;

public class Conjunction
implements Expression {
    private Expression left;
    private Expression right;

    public Conjunction(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    public Expression getLeft() {
        return this.left;
    }

    public void setLeft(Expression left) {
        this.left = left;
    }

    public Expression getRight() {
        return this.right;
    }

    public void setRight(Expression right) {
        this.right = right;
    }

    @Override
    public String buildQuery() {
        return String.format("(%s and %s)", this.left.buildQuery(), this.right.buildQuery());
    }

    public String toString() {
        return this.buildQuery();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conjunction that = (Conjunction)o;
        return Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }
}

