/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.auth;

import com.google.gson.Gson;
import io.vavr.control.Either;
import it.fattureincloud.sdk.auth.OAuth2Error;
import it.fattureincloud.sdk.auth.OAuth2TokenResponse;
import it.fattureincloud.sdk.auth.Scope;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class OAuth2Manager {
    static final String DEFAULT_BASE_URI = "https://api-v2.fattureincloud.it";
    protected String clientId;
    protected Optional<String> baseUri;
    protected OkHttpClient httpClient;
    protected Gson gson;
    protected static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");

    public OAuth2Manager(String clientId) {
        this(clientId, null, null);
    }

    public OAuth2Manager(String clientId, String baseUri) {
        this(clientId, baseUri, null);
    }

    public OAuth2Manager(String clientId, OkHttpClient httpClient) {
        this(clientId, null, httpClient);
    }

    public OAuth2Manager(String clientId, String baseUri, OkHttpClient httpClient) {
        this.clientId = clientId;
        this.baseUri = Optional.ofNullable(baseUri);
        this.httpClient = httpClient != null ? httpClient : new OkHttpClient();
        this.gson = new Gson();
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getBaseUri() {
        return this.baseUri.orElse(DEFAULT_BASE_URI);
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = Optional.ofNullable(baseUri);
    }

    public void setBaseUri(Optional<String> baseUri) {
        this.baseUri = baseUri;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected abstract Either<OAuth2Error, OAuth2TokenResponse> fetchToken(String var1) throws IOException;

    protected abstract Either<OAuth2Error, OAuth2TokenResponse> refreshToken(String var1) throws IOException;

    protected String getCompleteUri(String path) {
        return this.getBaseUri().concat(path);
    }

    protected String mapToJson(Map<String, String> inputMap) {
        return this.gson.toJson(inputMap);
    }

    protected <T> Either<OAuth2Error, T> post(String url, String json, Class<T> typeOfT) throws IOException {
        RequestBody body = RequestBody.create((String)json, (MediaType)JSON);
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            String responseBody = Objects.requireNonNull(response.body()).string();
            int code = response.code();
            if (code != 200) {
                OAuth2Error err = (OAuth2Error)this.gson.fromJson(responseBody, OAuth2Error.class);
                err.setCode(code);
                Either either = Either.left((Object)err);
                return either;
            }
            Object res = this.gson.fromJson(responseBody, typeOfT);
            Either either = Either.right((Object)res);
            return either;
        }
    }

    protected String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    protected String decodeValue(String value) {
        try {
            return URLDecoder.decode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    protected String getScopesString(Collection<Scope> scopes) {
        return scopes.stream().map(Scope::getScope).collect(Collectors.joining(" "));
    }
}

