/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.api;

import com.google.gson.reflect.TypeToken;
import it.fattureincloud.sdk.ApiCallback;
import it.fattureincloud.sdk.ApiClient;
import it.fattureincloud.sdk.ApiException;
import it.fattureincloud.sdk.ApiResponse;
import it.fattureincloud.sdk.Configuration;
import it.fattureincloud.sdk.Pair;
import it.fattureincloud.sdk.model.CreateSupplierRequest;
import it.fattureincloud.sdk.model.CreateSupplierResponse;
import it.fattureincloud.sdk.model.GetSupplierResponse;
import it.fattureincloud.sdk.model.ListSuppliersResponse;
import it.fattureincloud.sdk.model.ModifySupplierRequest;
import it.fattureincloud.sdk.model.ModifySupplierResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SuppliersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SuppliersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SuppliersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createSupplierCall(Integer companyId, CreateSupplierRequest createSupplierRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateSupplierRequest localVarPostBody = createSupplierRequest;
        String localVarPath = "/c/{company_id}/entities/suppliers".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSupplierValidateBeforeCall(Integer companyId, CreateSupplierRequest createSupplierRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling createSupplier(Async)");
        }
        return this.createSupplierCall(companyId, createSupplierRequest, _callback);
    }

    public CreateSupplierResponse createSupplier(Integer companyId, CreateSupplierRequest createSupplierRequest) throws ApiException {
        ApiResponse<CreateSupplierResponse> localVarResp = this.createSupplierWithHttpInfo(companyId, createSupplierRequest);
        return localVarResp.getData();
    }

    public ApiResponse<CreateSupplierResponse> createSupplierWithHttpInfo(Integer companyId, CreateSupplierRequest createSupplierRequest) throws ApiException {
        Call localVarCall = this.createSupplierValidateBeforeCall(companyId, createSupplierRequest, null);
        Type localVarReturnType = new TypeToken<CreateSupplierResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSupplierAsync(Integer companyId, CreateSupplierRequest createSupplierRequest, ApiCallback<CreateSupplierResponse> _callback) throws ApiException {
        Call localVarCall = this.createSupplierValidateBeforeCall(companyId, createSupplierRequest, _callback);
        Type localVarReturnType = new TypeToken<CreateSupplierResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSupplierCall(Integer companyId, Integer supplierId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/entities/suppliers/{supplier_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{supplier_id}", this.localVarApiClient.escapeString(supplierId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSupplierValidateBeforeCall(Integer companyId, Integer supplierId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling deleteSupplier(Async)");
        }
        if (supplierId == null) {
            throw new ApiException("Missing the required parameter 'supplierId' when calling deleteSupplier(Async)");
        }
        return this.deleteSupplierCall(companyId, supplierId, _callback);
    }

    public void deleteSupplier(Integer companyId, Integer supplierId) throws ApiException {
        this.deleteSupplierWithHttpInfo(companyId, supplierId);
    }

    public ApiResponse<Void> deleteSupplierWithHttpInfo(Integer companyId, Integer supplierId) throws ApiException {
        Call localVarCall = this.deleteSupplierValidateBeforeCall(companyId, supplierId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteSupplierAsync(Integer companyId, Integer supplierId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteSupplierValidateBeforeCall(companyId, supplierId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getSupplierCall(Integer companyId, Integer supplierId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/entities/suppliers/{supplier_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{supplier_id}", this.localVarApiClient.escapeString(supplierId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSupplierValidateBeforeCall(Integer companyId, Integer supplierId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getSupplier(Async)");
        }
        if (supplierId == null) {
            throw new ApiException("Missing the required parameter 'supplierId' when calling getSupplier(Async)");
        }
        return this.getSupplierCall(companyId, supplierId, fields, fieldset, _callback);
    }

    public GetSupplierResponse getSupplier(Integer companyId, Integer supplierId, String fields, String fieldset) throws ApiException {
        ApiResponse<GetSupplierResponse> localVarResp = this.getSupplierWithHttpInfo(companyId, supplierId, fields, fieldset);
        return localVarResp.getData();
    }

    public ApiResponse<GetSupplierResponse> getSupplierWithHttpInfo(Integer companyId, Integer supplierId, String fields, String fieldset) throws ApiException {
        Call localVarCall = this.getSupplierValidateBeforeCall(companyId, supplierId, fields, fieldset, null);
        Type localVarReturnType = new TypeToken<GetSupplierResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSupplierAsync(Integer companyId, Integer supplierId, String fields, String fieldset, ApiCallback<GetSupplierResponse> _callback) throws ApiException {
        Call localVarCall = this.getSupplierValidateBeforeCall(companyId, supplierId, fields, fieldset, _callback);
        Type localVarReturnType = new TypeToken<GetSupplierResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSuppliersCall(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/entities/suppliers".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSuppliersValidateBeforeCall(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling listSuppliers(Async)");
        }
        return this.listSuppliersCall(companyId, fields, fieldset, sort, page, perPage, q, _callback);
    }

    public ListSuppliersResponse listSuppliers(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q) throws ApiException {
        ApiResponse<ListSuppliersResponse> localVarResp = this.listSuppliersWithHttpInfo(companyId, fields, fieldset, sort, page, perPage, q);
        return localVarResp.getData();
    }

    public ApiResponse<ListSuppliersResponse> listSuppliersWithHttpInfo(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q) throws ApiException {
        Call localVarCall = this.listSuppliersValidateBeforeCall(companyId, fields, fieldset, sort, page, perPage, q, null);
        Type localVarReturnType = new TypeToken<ListSuppliersResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSuppliersAsync(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback<ListSuppliersResponse> _callback) throws ApiException {
        Call localVarCall = this.listSuppliersValidateBeforeCall(companyId, fields, fieldset, sort, page, perPage, q, _callback);
        Type localVarReturnType = new TypeToken<ListSuppliersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifySupplierCall(Integer companyId, Integer supplierId, ModifySupplierRequest modifySupplierRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ModifySupplierRequest localVarPostBody = modifySupplierRequest;
        String localVarPath = "/c/{company_id}/entities/suppliers/{supplier_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{supplier_id}", this.localVarApiClient.escapeString(supplierId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifySupplierValidateBeforeCall(Integer companyId, Integer supplierId, ModifySupplierRequest modifySupplierRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling modifySupplier(Async)");
        }
        if (supplierId == null) {
            throw new ApiException("Missing the required parameter 'supplierId' when calling modifySupplier(Async)");
        }
        return this.modifySupplierCall(companyId, supplierId, modifySupplierRequest, _callback);
    }

    public ModifySupplierResponse modifySupplier(Integer companyId, Integer supplierId, ModifySupplierRequest modifySupplierRequest) throws ApiException {
        ApiResponse<ModifySupplierResponse> localVarResp = this.modifySupplierWithHttpInfo(companyId, supplierId, modifySupplierRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ModifySupplierResponse> modifySupplierWithHttpInfo(Integer companyId, Integer supplierId, ModifySupplierRequest modifySupplierRequest) throws ApiException {
        Call localVarCall = this.modifySupplierValidateBeforeCall(companyId, supplierId, modifySupplierRequest, null);
        Type localVarReturnType = new TypeToken<ModifySupplierResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call modifySupplierAsync(Integer companyId, Integer supplierId, ModifySupplierRequest modifySupplierRequest, ApiCallback<ModifySupplierResponse> _callback) throws ApiException {
        Call localVarCall = this.modifySupplierValidateBeforeCall(companyId, supplierId, modifySupplierRequest, _callback);
        Type localVarReturnType = new TypeToken<ModifySupplierResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

