/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.api;

import com.google.gson.reflect.TypeToken;
import it.fattureincloud.sdk.ApiCallback;
import it.fattureincloud.sdk.ApiClient;
import it.fattureincloud.sdk.ApiException;
import it.fattureincloud.sdk.ApiResponse;
import it.fattureincloud.sdk.Configuration;
import it.fattureincloud.sdk.Pair;
import it.fattureincloud.sdk.model.CreateReceivedDocumentRequest;
import it.fattureincloud.sdk.model.CreateReceivedDocumentResponse;
import it.fattureincloud.sdk.model.GetExistingReceivedDocumentTotalsRequest;
import it.fattureincloud.sdk.model.GetExistingReceivedDocumentTotalsResponse;
import it.fattureincloud.sdk.model.GetNewReceivedDocumentTotalsRequest;
import it.fattureincloud.sdk.model.GetNewReceivedDocumentTotalsResponse;
import it.fattureincloud.sdk.model.GetReceivedDocumentPreCreateInfoResponse;
import it.fattureincloud.sdk.model.GetReceivedDocumentResponse;
import it.fattureincloud.sdk.model.ListReceivedDocumentsResponse;
import it.fattureincloud.sdk.model.ModifyReceivedDocumentRequest;
import it.fattureincloud.sdk.model.ModifyReceivedDocumentResponse;
import it.fattureincloud.sdk.model.UploadReceivedDocumentAttachmentResponse;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ReceivedDocumentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ReceivedDocumentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ReceivedDocumentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createReceivedDocumentCall(Integer companyId, CreateReceivedDocumentRequest createReceivedDocumentRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateReceivedDocumentRequest localVarPostBody = createReceivedDocumentRequest;
        String localVarPath = "/c/{company_id}/received_documents".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createReceivedDocumentValidateBeforeCall(Integer companyId, CreateReceivedDocumentRequest createReceivedDocumentRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling createReceivedDocument(Async)");
        }
        return this.createReceivedDocumentCall(companyId, createReceivedDocumentRequest, _callback);
    }

    public CreateReceivedDocumentResponse createReceivedDocument(Integer companyId, CreateReceivedDocumentRequest createReceivedDocumentRequest) throws ApiException {
        ApiResponse<CreateReceivedDocumentResponse> localVarResp = this.createReceivedDocumentWithHttpInfo(companyId, createReceivedDocumentRequest);
        return localVarResp.getData();
    }

    public ApiResponse<CreateReceivedDocumentResponse> createReceivedDocumentWithHttpInfo(Integer companyId, CreateReceivedDocumentRequest createReceivedDocumentRequest) throws ApiException {
        Call localVarCall = this.createReceivedDocumentValidateBeforeCall(companyId, createReceivedDocumentRequest, null);
        Type localVarReturnType = new TypeToken<CreateReceivedDocumentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createReceivedDocumentAsync(Integer companyId, CreateReceivedDocumentRequest createReceivedDocumentRequest, ApiCallback<CreateReceivedDocumentResponse> _callback) throws ApiException {
        Call localVarCall = this.createReceivedDocumentValidateBeforeCall(companyId, createReceivedDocumentRequest, _callback);
        Type localVarReturnType = new TypeToken<CreateReceivedDocumentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteReceivedDocumentCall(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/received_documents/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteReceivedDocumentValidateBeforeCall(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling deleteReceivedDocument(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteReceivedDocument(Async)");
        }
        return this.deleteReceivedDocumentCall(companyId, documentId, _callback);
    }

    public void deleteReceivedDocument(Integer companyId, Integer documentId) throws ApiException {
        this.deleteReceivedDocumentWithHttpInfo(companyId, documentId);
    }

    public ApiResponse<Void> deleteReceivedDocumentWithHttpInfo(Integer companyId, Integer documentId) throws ApiException {
        Call localVarCall = this.deleteReceivedDocumentValidateBeforeCall(companyId, documentId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteReceivedDocumentAsync(Integer companyId, Integer documentId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteReceivedDocumentValidateBeforeCall(companyId, documentId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteReceivedDocumentAttachmentCall(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/received_documents/{document_id}/attachment".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteReceivedDocumentAttachmentValidateBeforeCall(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling deleteReceivedDocumentAttachment(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteReceivedDocumentAttachment(Async)");
        }
        return this.deleteReceivedDocumentAttachmentCall(companyId, documentId, _callback);
    }

    public void deleteReceivedDocumentAttachment(Integer companyId, Integer documentId) throws ApiException {
        this.deleteReceivedDocumentAttachmentWithHttpInfo(companyId, documentId);
    }

    public ApiResponse<Void> deleteReceivedDocumentAttachmentWithHttpInfo(Integer companyId, Integer documentId) throws ApiException {
        Call localVarCall = this.deleteReceivedDocumentAttachmentValidateBeforeCall(companyId, documentId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteReceivedDocumentAttachmentAsync(Integer companyId, Integer documentId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteReceivedDocumentAttachmentValidateBeforeCall(companyId, documentId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getExistingReceivedDocumentTotalsCall(Integer companyId, Integer documentId, GetExistingReceivedDocumentTotalsRequest getExistingReceivedDocumentTotalsRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GetExistingReceivedDocumentTotalsRequest localVarPostBody = getExistingReceivedDocumentTotalsRequest;
        String localVarPath = "/c/{company_id}/received_documents/{document_id}/totals".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExistingReceivedDocumentTotalsValidateBeforeCall(Integer companyId, Integer documentId, GetExistingReceivedDocumentTotalsRequest getExistingReceivedDocumentTotalsRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getExistingReceivedDocumentTotals(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getExistingReceivedDocumentTotals(Async)");
        }
        return this.getExistingReceivedDocumentTotalsCall(companyId, documentId, getExistingReceivedDocumentTotalsRequest, _callback);
    }

    public GetExistingReceivedDocumentTotalsResponse getExistingReceivedDocumentTotals(Integer companyId, Integer documentId, GetExistingReceivedDocumentTotalsRequest getExistingReceivedDocumentTotalsRequest) throws ApiException {
        ApiResponse<GetExistingReceivedDocumentTotalsResponse> localVarResp = this.getExistingReceivedDocumentTotalsWithHttpInfo(companyId, documentId, getExistingReceivedDocumentTotalsRequest);
        return localVarResp.getData();
    }

    public ApiResponse<GetExistingReceivedDocumentTotalsResponse> getExistingReceivedDocumentTotalsWithHttpInfo(Integer companyId, Integer documentId, GetExistingReceivedDocumentTotalsRequest getExistingReceivedDocumentTotalsRequest) throws ApiException {
        Call localVarCall = this.getExistingReceivedDocumentTotalsValidateBeforeCall(companyId, documentId, getExistingReceivedDocumentTotalsRequest, null);
        Type localVarReturnType = new TypeToken<GetExistingReceivedDocumentTotalsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExistingReceivedDocumentTotalsAsync(Integer companyId, Integer documentId, GetExistingReceivedDocumentTotalsRequest getExistingReceivedDocumentTotalsRequest, ApiCallback<GetExistingReceivedDocumentTotalsResponse> _callback) throws ApiException {
        Call localVarCall = this.getExistingReceivedDocumentTotalsValidateBeforeCall(companyId, documentId, getExistingReceivedDocumentTotalsRequest, _callback);
        Type localVarReturnType = new TypeToken<GetExistingReceivedDocumentTotalsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getNewReceivedDocumentTotalsCall(Integer companyId, GetNewReceivedDocumentTotalsRequest getNewReceivedDocumentTotalsRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GetNewReceivedDocumentTotalsRequest localVarPostBody = getNewReceivedDocumentTotalsRequest;
        String localVarPath = "/c/{company_id}/received_documents/totals".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getNewReceivedDocumentTotalsValidateBeforeCall(Integer companyId, GetNewReceivedDocumentTotalsRequest getNewReceivedDocumentTotalsRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getNewReceivedDocumentTotals(Async)");
        }
        return this.getNewReceivedDocumentTotalsCall(companyId, getNewReceivedDocumentTotalsRequest, _callback);
    }

    public GetNewReceivedDocumentTotalsResponse getNewReceivedDocumentTotals(Integer companyId, GetNewReceivedDocumentTotalsRequest getNewReceivedDocumentTotalsRequest) throws ApiException {
        ApiResponse<GetNewReceivedDocumentTotalsResponse> localVarResp = this.getNewReceivedDocumentTotalsWithHttpInfo(companyId, getNewReceivedDocumentTotalsRequest);
        return localVarResp.getData();
    }

    public ApiResponse<GetNewReceivedDocumentTotalsResponse> getNewReceivedDocumentTotalsWithHttpInfo(Integer companyId, GetNewReceivedDocumentTotalsRequest getNewReceivedDocumentTotalsRequest) throws ApiException {
        Call localVarCall = this.getNewReceivedDocumentTotalsValidateBeforeCall(companyId, getNewReceivedDocumentTotalsRequest, null);
        Type localVarReturnType = new TypeToken<GetNewReceivedDocumentTotalsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getNewReceivedDocumentTotalsAsync(Integer companyId, GetNewReceivedDocumentTotalsRequest getNewReceivedDocumentTotalsRequest, ApiCallback<GetNewReceivedDocumentTotalsResponse> _callback) throws ApiException {
        Call localVarCall = this.getNewReceivedDocumentTotalsValidateBeforeCall(companyId, getNewReceivedDocumentTotalsRequest, _callback);
        Type localVarReturnType = new TypeToken<GetNewReceivedDocumentTotalsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getReceivedDocumentCall(Integer companyId, Integer documentId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/received_documents/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getReceivedDocumentValidateBeforeCall(Integer companyId, Integer documentId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getReceivedDocument(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getReceivedDocument(Async)");
        }
        return this.getReceivedDocumentCall(companyId, documentId, fields, fieldset, _callback);
    }

    public GetReceivedDocumentResponse getReceivedDocument(Integer companyId, Integer documentId, String fields, String fieldset) throws ApiException {
        ApiResponse<GetReceivedDocumentResponse> localVarResp = this.getReceivedDocumentWithHttpInfo(companyId, documentId, fields, fieldset);
        return localVarResp.getData();
    }

    public ApiResponse<GetReceivedDocumentResponse> getReceivedDocumentWithHttpInfo(Integer companyId, Integer documentId, String fields, String fieldset) throws ApiException {
        Call localVarCall = this.getReceivedDocumentValidateBeforeCall(companyId, documentId, fields, fieldset, null);
        Type localVarReturnType = new TypeToken<GetReceivedDocumentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getReceivedDocumentAsync(Integer companyId, Integer documentId, String fields, String fieldset, ApiCallback<GetReceivedDocumentResponse> _callback) throws ApiException {
        Call localVarCall = this.getReceivedDocumentValidateBeforeCall(companyId, documentId, fields, fieldset, _callback);
        Type localVarReturnType = new TypeToken<GetReceivedDocumentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getReceivedDocumentPreCreateInfoCall(Integer companyId, String type, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/received_documents/info".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getReceivedDocumentPreCreateInfoValidateBeforeCall(Integer companyId, String type, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getReceivedDocumentPreCreateInfo(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling getReceivedDocumentPreCreateInfo(Async)");
        }
        return this.getReceivedDocumentPreCreateInfoCall(companyId, type, _callback);
    }

    public GetReceivedDocumentPreCreateInfoResponse getReceivedDocumentPreCreateInfo(Integer companyId, String type) throws ApiException {
        ApiResponse<GetReceivedDocumentPreCreateInfoResponse> localVarResp = this.getReceivedDocumentPreCreateInfoWithHttpInfo(companyId, type);
        return localVarResp.getData();
    }

    public ApiResponse<GetReceivedDocumentPreCreateInfoResponse> getReceivedDocumentPreCreateInfoWithHttpInfo(Integer companyId, String type) throws ApiException {
        Call localVarCall = this.getReceivedDocumentPreCreateInfoValidateBeforeCall(companyId, type, null);
        Type localVarReturnType = new TypeToken<GetReceivedDocumentPreCreateInfoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getReceivedDocumentPreCreateInfoAsync(Integer companyId, String type, ApiCallback<GetReceivedDocumentPreCreateInfoResponse> _callback) throws ApiException {
        Call localVarCall = this.getReceivedDocumentPreCreateInfoValidateBeforeCall(companyId, type, _callback);
        Type localVarReturnType = new TypeToken<GetReceivedDocumentPreCreateInfoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listReceivedDocumentsCall(Integer companyId, String type, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/received_documents".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listReceivedDocumentsValidateBeforeCall(Integer companyId, String type, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling listReceivedDocuments(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling listReceivedDocuments(Async)");
        }
        return this.listReceivedDocumentsCall(companyId, type, fields, fieldset, sort, page, perPage, q, _callback);
    }

    public ListReceivedDocumentsResponse listReceivedDocuments(Integer companyId, String type, String fields, String fieldset, String sort, Integer page, Integer perPage, String q) throws ApiException {
        ApiResponse<ListReceivedDocumentsResponse> localVarResp = this.listReceivedDocumentsWithHttpInfo(companyId, type, fields, fieldset, sort, page, perPage, q);
        return localVarResp.getData();
    }

    public ApiResponse<ListReceivedDocumentsResponse> listReceivedDocumentsWithHttpInfo(Integer companyId, String type, String fields, String fieldset, String sort, Integer page, Integer perPage, String q) throws ApiException {
        Call localVarCall = this.listReceivedDocumentsValidateBeforeCall(companyId, type, fields, fieldset, sort, page, perPage, q, null);
        Type localVarReturnType = new TypeToken<ListReceivedDocumentsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listReceivedDocumentsAsync(Integer companyId, String type, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback<ListReceivedDocumentsResponse> _callback) throws ApiException {
        Call localVarCall = this.listReceivedDocumentsValidateBeforeCall(companyId, type, fields, fieldset, sort, page, perPage, q, _callback);
        Type localVarReturnType = new TypeToken<ListReceivedDocumentsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyReceivedDocumentCall(Integer companyId, Integer documentId, ModifyReceivedDocumentRequest modifyReceivedDocumentRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ModifyReceivedDocumentRequest localVarPostBody = modifyReceivedDocumentRequest;
        String localVarPath = "/c/{company_id}/received_documents/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyReceivedDocumentValidateBeforeCall(Integer companyId, Integer documentId, ModifyReceivedDocumentRequest modifyReceivedDocumentRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling modifyReceivedDocument(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling modifyReceivedDocument(Async)");
        }
        return this.modifyReceivedDocumentCall(companyId, documentId, modifyReceivedDocumentRequest, _callback);
    }

    public ModifyReceivedDocumentResponse modifyReceivedDocument(Integer companyId, Integer documentId, ModifyReceivedDocumentRequest modifyReceivedDocumentRequest) throws ApiException {
        ApiResponse<ModifyReceivedDocumentResponse> localVarResp = this.modifyReceivedDocumentWithHttpInfo(companyId, documentId, modifyReceivedDocumentRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ModifyReceivedDocumentResponse> modifyReceivedDocumentWithHttpInfo(Integer companyId, Integer documentId, ModifyReceivedDocumentRequest modifyReceivedDocumentRequest) throws ApiException {
        Call localVarCall = this.modifyReceivedDocumentValidateBeforeCall(companyId, documentId, modifyReceivedDocumentRequest, null);
        Type localVarReturnType = new TypeToken<ModifyReceivedDocumentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call modifyReceivedDocumentAsync(Integer companyId, Integer documentId, ModifyReceivedDocumentRequest modifyReceivedDocumentRequest, ApiCallback<ModifyReceivedDocumentResponse> _callback) throws ApiException {
        Call localVarCall = this.modifyReceivedDocumentValidateBeforeCall(companyId, documentId, modifyReceivedDocumentRequest, _callback);
        Type localVarReturnType = new TypeToken<ModifyReceivedDocumentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call uploadReceivedDocumentAttachmentCall(Integer companyId, String filename, File attachment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/received_documents/attachment".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filename != null) {
            localVarFormParams.put("filename", filename);
        }
        if (attachment != null) {
            localVarFormParams.put("attachment", attachment);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadReceivedDocumentAttachmentValidateBeforeCall(Integer companyId, String filename, File attachment, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling uploadReceivedDocumentAttachment(Async)");
        }
        return this.uploadReceivedDocumentAttachmentCall(companyId, filename, attachment, _callback);
    }

    public UploadReceivedDocumentAttachmentResponse uploadReceivedDocumentAttachment(Integer companyId, String filename, File attachment) throws ApiException {
        ApiResponse<UploadReceivedDocumentAttachmentResponse> localVarResp = this.uploadReceivedDocumentAttachmentWithHttpInfo(companyId, filename, attachment);
        return localVarResp.getData();
    }

    public ApiResponse<UploadReceivedDocumentAttachmentResponse> uploadReceivedDocumentAttachmentWithHttpInfo(Integer companyId, String filename, File attachment) throws ApiException {
        Call localVarCall = this.uploadReceivedDocumentAttachmentValidateBeforeCall(companyId, filename, attachment, null);
        Type localVarReturnType = new TypeToken<UploadReceivedDocumentAttachmentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call uploadReceivedDocumentAttachmentAsync(Integer companyId, String filename, File attachment, ApiCallback<UploadReceivedDocumentAttachmentResponse> _callback) throws ApiException {
        Call localVarCall = this.uploadReceivedDocumentAttachmentValidateBeforeCall(companyId, filename, attachment, _callback);
        Type localVarReturnType = new TypeToken<UploadReceivedDocumentAttachmentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

