/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.api;

import com.google.gson.reflect.TypeToken;
import it.fattureincloud.sdk.ApiCallback;
import it.fattureincloud.sdk.ApiClient;
import it.fattureincloud.sdk.ApiException;
import it.fattureincloud.sdk.ApiResponse;
import it.fattureincloud.sdk.Configuration;
import it.fattureincloud.sdk.Pair;
import it.fattureincloud.sdk.model.CreateReceiptRequest;
import it.fattureincloud.sdk.model.CreateReceiptResponse;
import it.fattureincloud.sdk.model.GetReceiptPreCreateInfoResponse;
import it.fattureincloud.sdk.model.GetReceiptResponse;
import it.fattureincloud.sdk.model.GetReceiptsMonthlyTotalsResponse;
import it.fattureincloud.sdk.model.ListReceiptsResponse;
import it.fattureincloud.sdk.model.ModifyReceiptRequest;
import it.fattureincloud.sdk.model.ModifyReceiptResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ReceiptsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ReceiptsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ReceiptsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createReceiptCall(Integer companyId, CreateReceiptRequest createReceiptRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateReceiptRequest localVarPostBody = createReceiptRequest;
        String localVarPath = "/c/{company_id}/receipts".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createReceiptValidateBeforeCall(Integer companyId, CreateReceiptRequest createReceiptRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling createReceipt(Async)");
        }
        return this.createReceiptCall(companyId, createReceiptRequest, _callback);
    }

    public CreateReceiptResponse createReceipt(Integer companyId, CreateReceiptRequest createReceiptRequest) throws ApiException {
        ApiResponse<CreateReceiptResponse> localVarResp = this.createReceiptWithHttpInfo(companyId, createReceiptRequest);
        return localVarResp.getData();
    }

    public ApiResponse<CreateReceiptResponse> createReceiptWithHttpInfo(Integer companyId, CreateReceiptRequest createReceiptRequest) throws ApiException {
        Call localVarCall = this.createReceiptValidateBeforeCall(companyId, createReceiptRequest, null);
        Type localVarReturnType = new TypeToken<CreateReceiptResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createReceiptAsync(Integer companyId, CreateReceiptRequest createReceiptRequest, ApiCallback<CreateReceiptResponse> _callback) throws ApiException {
        Call localVarCall = this.createReceiptValidateBeforeCall(companyId, createReceiptRequest, _callback);
        Type localVarReturnType = new TypeToken<CreateReceiptResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteReceiptCall(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/receipts/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteReceiptValidateBeforeCall(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling deleteReceipt(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteReceipt(Async)");
        }
        return this.deleteReceiptCall(companyId, documentId, _callback);
    }

    public void deleteReceipt(Integer companyId, Integer documentId) throws ApiException {
        this.deleteReceiptWithHttpInfo(companyId, documentId);
    }

    public ApiResponse<Void> deleteReceiptWithHttpInfo(Integer companyId, Integer documentId) throws ApiException {
        Call localVarCall = this.deleteReceiptValidateBeforeCall(companyId, documentId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteReceiptAsync(Integer companyId, Integer documentId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteReceiptValidateBeforeCall(companyId, documentId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getReceiptCall(Integer companyId, Integer documentId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/receipts/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getReceiptValidateBeforeCall(Integer companyId, Integer documentId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getReceipt(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getReceipt(Async)");
        }
        return this.getReceiptCall(companyId, documentId, fields, fieldset, _callback);
    }

    public GetReceiptResponse getReceipt(Integer companyId, Integer documentId, String fields, String fieldset) throws ApiException {
        ApiResponse<GetReceiptResponse> localVarResp = this.getReceiptWithHttpInfo(companyId, documentId, fields, fieldset);
        return localVarResp.getData();
    }

    public ApiResponse<GetReceiptResponse> getReceiptWithHttpInfo(Integer companyId, Integer documentId, String fields, String fieldset) throws ApiException {
        Call localVarCall = this.getReceiptValidateBeforeCall(companyId, documentId, fields, fieldset, null);
        Type localVarReturnType = new TypeToken<GetReceiptResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getReceiptAsync(Integer companyId, Integer documentId, String fields, String fieldset, ApiCallback<GetReceiptResponse> _callback) throws ApiException {
        Call localVarCall = this.getReceiptValidateBeforeCall(companyId, documentId, fields, fieldset, _callback);
        Type localVarReturnType = new TypeToken<GetReceiptResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getReceiptPreCreateInfoCall(Integer companyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/receipts/info".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getReceiptPreCreateInfoValidateBeforeCall(Integer companyId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getReceiptPreCreateInfo(Async)");
        }
        return this.getReceiptPreCreateInfoCall(companyId, _callback);
    }

    public GetReceiptPreCreateInfoResponse getReceiptPreCreateInfo(Integer companyId) throws ApiException {
        ApiResponse<GetReceiptPreCreateInfoResponse> localVarResp = this.getReceiptPreCreateInfoWithHttpInfo(companyId);
        return localVarResp.getData();
    }

    public ApiResponse<GetReceiptPreCreateInfoResponse> getReceiptPreCreateInfoWithHttpInfo(Integer companyId) throws ApiException {
        Call localVarCall = this.getReceiptPreCreateInfoValidateBeforeCall(companyId, null);
        Type localVarReturnType = new TypeToken<GetReceiptPreCreateInfoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getReceiptPreCreateInfoAsync(Integer companyId, ApiCallback<GetReceiptPreCreateInfoResponse> _callback) throws ApiException {
        Call localVarCall = this.getReceiptPreCreateInfoValidateBeforeCall(companyId, _callback);
        Type localVarReturnType = new TypeToken<GetReceiptPreCreateInfoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getReceiptsMonthlyTotalsCall(Integer companyId, String type, String year, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/receipts/monthly_totals".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (year != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("year", year));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getReceiptsMonthlyTotalsValidateBeforeCall(Integer companyId, String type, String year, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getReceiptsMonthlyTotals(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling getReceiptsMonthlyTotals(Async)");
        }
        if (year == null) {
            throw new ApiException("Missing the required parameter 'year' when calling getReceiptsMonthlyTotals(Async)");
        }
        return this.getReceiptsMonthlyTotalsCall(companyId, type, year, _callback);
    }

    public GetReceiptsMonthlyTotalsResponse getReceiptsMonthlyTotals(Integer companyId, String type, String year) throws ApiException {
        ApiResponse<GetReceiptsMonthlyTotalsResponse> localVarResp = this.getReceiptsMonthlyTotalsWithHttpInfo(companyId, type, year);
        return localVarResp.getData();
    }

    public ApiResponse<GetReceiptsMonthlyTotalsResponse> getReceiptsMonthlyTotalsWithHttpInfo(Integer companyId, String type, String year) throws ApiException {
        Call localVarCall = this.getReceiptsMonthlyTotalsValidateBeforeCall(companyId, type, year, null);
        Type localVarReturnType = new TypeToken<GetReceiptsMonthlyTotalsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getReceiptsMonthlyTotalsAsync(Integer companyId, String type, String year, ApiCallback<GetReceiptsMonthlyTotalsResponse> _callback) throws ApiException {
        Call localVarCall = this.getReceiptsMonthlyTotalsValidateBeforeCall(companyId, type, year, _callback);
        Type localVarReturnType = new TypeToken<GetReceiptsMonthlyTotalsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listReceiptsCall(Integer companyId, String fields, String fieldset, Integer page, Integer perPage, String sort, String q, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/receipts".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listReceiptsValidateBeforeCall(Integer companyId, String fields, String fieldset, Integer page, Integer perPage, String sort, String q, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling listReceipts(Async)");
        }
        return this.listReceiptsCall(companyId, fields, fieldset, page, perPage, sort, q, _callback);
    }

    public ListReceiptsResponse listReceipts(Integer companyId, String fields, String fieldset, Integer page, Integer perPage, String sort, String q) throws ApiException {
        ApiResponse<ListReceiptsResponse> localVarResp = this.listReceiptsWithHttpInfo(companyId, fields, fieldset, page, perPage, sort, q);
        return localVarResp.getData();
    }

    public ApiResponse<ListReceiptsResponse> listReceiptsWithHttpInfo(Integer companyId, String fields, String fieldset, Integer page, Integer perPage, String sort, String q) throws ApiException {
        Call localVarCall = this.listReceiptsValidateBeforeCall(companyId, fields, fieldset, page, perPage, sort, q, null);
        Type localVarReturnType = new TypeToken<ListReceiptsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listReceiptsAsync(Integer companyId, String fields, String fieldset, Integer page, Integer perPage, String sort, String q, ApiCallback<ListReceiptsResponse> _callback) throws ApiException {
        Call localVarCall = this.listReceiptsValidateBeforeCall(companyId, fields, fieldset, page, perPage, sort, q, _callback);
        Type localVarReturnType = new TypeToken<ListReceiptsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyReceiptCall(Integer companyId, Integer documentId, ModifyReceiptRequest modifyReceiptRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ModifyReceiptRequest localVarPostBody = modifyReceiptRequest;
        String localVarPath = "/c/{company_id}/receipts/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyReceiptValidateBeforeCall(Integer companyId, Integer documentId, ModifyReceiptRequest modifyReceiptRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling modifyReceipt(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling modifyReceipt(Async)");
        }
        return this.modifyReceiptCall(companyId, documentId, modifyReceiptRequest, _callback);
    }

    public ModifyReceiptResponse modifyReceipt(Integer companyId, Integer documentId, ModifyReceiptRequest modifyReceiptRequest) throws ApiException {
        ApiResponse<ModifyReceiptResponse> localVarResp = this.modifyReceiptWithHttpInfo(companyId, documentId, modifyReceiptRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ModifyReceiptResponse> modifyReceiptWithHttpInfo(Integer companyId, Integer documentId, ModifyReceiptRequest modifyReceiptRequest) throws ApiException {
        Call localVarCall = this.modifyReceiptValidateBeforeCall(companyId, documentId, modifyReceiptRequest, null);
        Type localVarReturnType = new TypeToken<ModifyReceiptResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call modifyReceiptAsync(Integer companyId, Integer documentId, ModifyReceiptRequest modifyReceiptRequest, ApiCallback<ModifyReceiptResponse> _callback) throws ApiException {
        Call localVarCall = this.modifyReceiptValidateBeforeCall(companyId, documentId, modifyReceiptRequest, _callback);
        Type localVarReturnType = new TypeToken<ModifyReceiptResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

