/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.api;

import com.google.gson.reflect.TypeToken;
import it.fattureincloud.sdk.ApiCallback;
import it.fattureincloud.sdk.ApiClient;
import it.fattureincloud.sdk.ApiException;
import it.fattureincloud.sdk.ApiResponse;
import it.fattureincloud.sdk.Configuration;
import it.fattureincloud.sdk.Pair;
import it.fattureincloud.sdk.model.CreateIssuedDocumentRequest;
import it.fattureincloud.sdk.model.CreateIssuedDocumentResponse;
import it.fattureincloud.sdk.model.GetEmailDataResponse;
import it.fattureincloud.sdk.model.GetExistingIssuedDocumentTotalsRequest;
import it.fattureincloud.sdk.model.GetExistingIssuedDocumentTotalsResponse;
import it.fattureincloud.sdk.model.GetIssuedDocumentPreCreateInfoResponse;
import it.fattureincloud.sdk.model.GetIssuedDocumentResponse;
import it.fattureincloud.sdk.model.GetNewIssuedDocumentTotalsRequest;
import it.fattureincloud.sdk.model.GetNewIssuedDocumentTotalsResponse;
import it.fattureincloud.sdk.model.JoinIssuedDocumentsResponse;
import it.fattureincloud.sdk.model.ListIssuedDocumentsResponse;
import it.fattureincloud.sdk.model.ModifyIssuedDocumentRequest;
import it.fattureincloud.sdk.model.ModifyIssuedDocumentResponse;
import it.fattureincloud.sdk.model.ScheduleEmailRequest;
import it.fattureincloud.sdk.model.TransformIssuedDocumentResponse;
import it.fattureincloud.sdk.model.UploadIssuedDocumentAttachmentResponse;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class IssuedDocumentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public IssuedDocumentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IssuedDocumentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createIssuedDocumentCall(Integer companyId, CreateIssuedDocumentRequest createIssuedDocumentRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateIssuedDocumentRequest localVarPostBody = createIssuedDocumentRequest;
        String localVarPath = "/c/{company_id}/issued_documents".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createIssuedDocumentValidateBeforeCall(Integer companyId, CreateIssuedDocumentRequest createIssuedDocumentRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling createIssuedDocument(Async)");
        }
        return this.createIssuedDocumentCall(companyId, createIssuedDocumentRequest, _callback);
    }

    public CreateIssuedDocumentResponse createIssuedDocument(Integer companyId, CreateIssuedDocumentRequest createIssuedDocumentRequest) throws ApiException {
        ApiResponse<CreateIssuedDocumentResponse> localVarResp = this.createIssuedDocumentWithHttpInfo(companyId, createIssuedDocumentRequest);
        return localVarResp.getData();
    }

    public ApiResponse<CreateIssuedDocumentResponse> createIssuedDocumentWithHttpInfo(Integer companyId, CreateIssuedDocumentRequest createIssuedDocumentRequest) throws ApiException {
        Call localVarCall = this.createIssuedDocumentValidateBeforeCall(companyId, createIssuedDocumentRequest, null);
        Type localVarReturnType = new TypeToken<CreateIssuedDocumentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createIssuedDocumentAsync(Integer companyId, CreateIssuedDocumentRequest createIssuedDocumentRequest, ApiCallback<CreateIssuedDocumentResponse> _callback) throws ApiException {
        Call localVarCall = this.createIssuedDocumentValidateBeforeCall(companyId, createIssuedDocumentRequest, _callback);
        Type localVarReturnType = new TypeToken<CreateIssuedDocumentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteIssuedDocumentCall(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/issued_documents/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteIssuedDocumentValidateBeforeCall(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling deleteIssuedDocument(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteIssuedDocument(Async)");
        }
        return this.deleteIssuedDocumentCall(companyId, documentId, _callback);
    }

    public void deleteIssuedDocument(Integer companyId, Integer documentId) throws ApiException {
        this.deleteIssuedDocumentWithHttpInfo(companyId, documentId);
    }

    public ApiResponse<Void> deleteIssuedDocumentWithHttpInfo(Integer companyId, Integer documentId) throws ApiException {
        Call localVarCall = this.deleteIssuedDocumentValidateBeforeCall(companyId, documentId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteIssuedDocumentAsync(Integer companyId, Integer documentId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteIssuedDocumentValidateBeforeCall(companyId, documentId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteIssuedDocumentAttachmentCall(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/issued_documents/{document_id}/attachment".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteIssuedDocumentAttachmentValidateBeforeCall(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling deleteIssuedDocumentAttachment(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteIssuedDocumentAttachment(Async)");
        }
        return this.deleteIssuedDocumentAttachmentCall(companyId, documentId, _callback);
    }

    public void deleteIssuedDocumentAttachment(Integer companyId, Integer documentId) throws ApiException {
        this.deleteIssuedDocumentAttachmentWithHttpInfo(companyId, documentId);
    }

    public ApiResponse<Void> deleteIssuedDocumentAttachmentWithHttpInfo(Integer companyId, Integer documentId) throws ApiException {
        Call localVarCall = this.deleteIssuedDocumentAttachmentValidateBeforeCall(companyId, documentId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteIssuedDocumentAttachmentAsync(Integer companyId, Integer documentId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteIssuedDocumentAttachmentValidateBeforeCall(companyId, documentId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getEmailDataCall(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/issued_documents/{document_id}/email".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEmailDataValidateBeforeCall(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getEmailData(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getEmailData(Async)");
        }
        return this.getEmailDataCall(companyId, documentId, _callback);
    }

    public GetEmailDataResponse getEmailData(Integer companyId, Integer documentId) throws ApiException {
        ApiResponse<GetEmailDataResponse> localVarResp = this.getEmailDataWithHttpInfo(companyId, documentId);
        return localVarResp.getData();
    }

    public ApiResponse<GetEmailDataResponse> getEmailDataWithHttpInfo(Integer companyId, Integer documentId) throws ApiException {
        Call localVarCall = this.getEmailDataValidateBeforeCall(companyId, documentId, null);
        Type localVarReturnType = new TypeToken<GetEmailDataResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEmailDataAsync(Integer companyId, Integer documentId, ApiCallback<GetEmailDataResponse> _callback) throws ApiException {
        Call localVarCall = this.getEmailDataValidateBeforeCall(companyId, documentId, _callback);
        Type localVarReturnType = new TypeToken<GetEmailDataResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExistingIssuedDocumentTotalsCall(Integer companyId, Integer documentId, GetExistingIssuedDocumentTotalsRequest getExistingIssuedDocumentTotalsRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GetExistingIssuedDocumentTotalsRequest localVarPostBody = getExistingIssuedDocumentTotalsRequest;
        String localVarPath = "/c/{company_id}/issued_documents/{document_id}/totals".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExistingIssuedDocumentTotalsValidateBeforeCall(Integer companyId, Integer documentId, GetExistingIssuedDocumentTotalsRequest getExistingIssuedDocumentTotalsRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getExistingIssuedDocumentTotals(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getExistingIssuedDocumentTotals(Async)");
        }
        return this.getExistingIssuedDocumentTotalsCall(companyId, documentId, getExistingIssuedDocumentTotalsRequest, _callback);
    }

    public GetExistingIssuedDocumentTotalsResponse getExistingIssuedDocumentTotals(Integer companyId, Integer documentId, GetExistingIssuedDocumentTotalsRequest getExistingIssuedDocumentTotalsRequest) throws ApiException {
        ApiResponse<GetExistingIssuedDocumentTotalsResponse> localVarResp = this.getExistingIssuedDocumentTotalsWithHttpInfo(companyId, documentId, getExistingIssuedDocumentTotalsRequest);
        return localVarResp.getData();
    }

    public ApiResponse<GetExistingIssuedDocumentTotalsResponse> getExistingIssuedDocumentTotalsWithHttpInfo(Integer companyId, Integer documentId, GetExistingIssuedDocumentTotalsRequest getExistingIssuedDocumentTotalsRequest) throws ApiException {
        Call localVarCall = this.getExistingIssuedDocumentTotalsValidateBeforeCall(companyId, documentId, getExistingIssuedDocumentTotalsRequest, null);
        Type localVarReturnType = new TypeToken<GetExistingIssuedDocumentTotalsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExistingIssuedDocumentTotalsAsync(Integer companyId, Integer documentId, GetExistingIssuedDocumentTotalsRequest getExistingIssuedDocumentTotalsRequest, ApiCallback<GetExistingIssuedDocumentTotalsResponse> _callback) throws ApiException {
        Call localVarCall = this.getExistingIssuedDocumentTotalsValidateBeforeCall(companyId, documentId, getExistingIssuedDocumentTotalsRequest, _callback);
        Type localVarReturnType = new TypeToken<GetExistingIssuedDocumentTotalsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getIssuedDocumentCall(Integer companyId, Integer documentId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/issued_documents/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getIssuedDocumentValidateBeforeCall(Integer companyId, Integer documentId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getIssuedDocument(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getIssuedDocument(Async)");
        }
        return this.getIssuedDocumentCall(companyId, documentId, fields, fieldset, _callback);
    }

    public GetIssuedDocumentResponse getIssuedDocument(Integer companyId, Integer documentId, String fields, String fieldset) throws ApiException {
        ApiResponse<GetIssuedDocumentResponse> localVarResp = this.getIssuedDocumentWithHttpInfo(companyId, documentId, fields, fieldset);
        return localVarResp.getData();
    }

    public ApiResponse<GetIssuedDocumentResponse> getIssuedDocumentWithHttpInfo(Integer companyId, Integer documentId, String fields, String fieldset) throws ApiException {
        Call localVarCall = this.getIssuedDocumentValidateBeforeCall(companyId, documentId, fields, fieldset, null);
        Type localVarReturnType = new TypeToken<GetIssuedDocumentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getIssuedDocumentAsync(Integer companyId, Integer documentId, String fields, String fieldset, ApiCallback<GetIssuedDocumentResponse> _callback) throws ApiException {
        Call localVarCall = this.getIssuedDocumentValidateBeforeCall(companyId, documentId, fields, fieldset, _callback);
        Type localVarReturnType = new TypeToken<GetIssuedDocumentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getIssuedDocumentPreCreateInfoCall(Integer companyId, String type, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/issued_documents/info".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getIssuedDocumentPreCreateInfoValidateBeforeCall(Integer companyId, String type, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getIssuedDocumentPreCreateInfo(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling getIssuedDocumentPreCreateInfo(Async)");
        }
        return this.getIssuedDocumentPreCreateInfoCall(companyId, type, _callback);
    }

    public GetIssuedDocumentPreCreateInfoResponse getIssuedDocumentPreCreateInfo(Integer companyId, String type) throws ApiException {
        ApiResponse<GetIssuedDocumentPreCreateInfoResponse> localVarResp = this.getIssuedDocumentPreCreateInfoWithHttpInfo(companyId, type);
        return localVarResp.getData();
    }

    public ApiResponse<GetIssuedDocumentPreCreateInfoResponse> getIssuedDocumentPreCreateInfoWithHttpInfo(Integer companyId, String type) throws ApiException {
        Call localVarCall = this.getIssuedDocumentPreCreateInfoValidateBeforeCall(companyId, type, null);
        Type localVarReturnType = new TypeToken<GetIssuedDocumentPreCreateInfoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getIssuedDocumentPreCreateInfoAsync(Integer companyId, String type, ApiCallback<GetIssuedDocumentPreCreateInfoResponse> _callback) throws ApiException {
        Call localVarCall = this.getIssuedDocumentPreCreateInfoValidateBeforeCall(companyId, type, _callback);
        Type localVarReturnType = new TypeToken<GetIssuedDocumentPreCreateInfoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getNewIssuedDocumentTotalsCall(Integer companyId, GetNewIssuedDocumentTotalsRequest getNewIssuedDocumentTotalsRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GetNewIssuedDocumentTotalsRequest localVarPostBody = getNewIssuedDocumentTotalsRequest;
        String localVarPath = "/c/{company_id}/issued_documents/totals".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getNewIssuedDocumentTotalsValidateBeforeCall(Integer companyId, GetNewIssuedDocumentTotalsRequest getNewIssuedDocumentTotalsRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getNewIssuedDocumentTotals(Async)");
        }
        return this.getNewIssuedDocumentTotalsCall(companyId, getNewIssuedDocumentTotalsRequest, _callback);
    }

    public GetNewIssuedDocumentTotalsResponse getNewIssuedDocumentTotals(Integer companyId, GetNewIssuedDocumentTotalsRequest getNewIssuedDocumentTotalsRequest) throws ApiException {
        ApiResponse<GetNewIssuedDocumentTotalsResponse> localVarResp = this.getNewIssuedDocumentTotalsWithHttpInfo(companyId, getNewIssuedDocumentTotalsRequest);
        return localVarResp.getData();
    }

    public ApiResponse<GetNewIssuedDocumentTotalsResponse> getNewIssuedDocumentTotalsWithHttpInfo(Integer companyId, GetNewIssuedDocumentTotalsRequest getNewIssuedDocumentTotalsRequest) throws ApiException {
        Call localVarCall = this.getNewIssuedDocumentTotalsValidateBeforeCall(companyId, getNewIssuedDocumentTotalsRequest, null);
        Type localVarReturnType = new TypeToken<GetNewIssuedDocumentTotalsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getNewIssuedDocumentTotalsAsync(Integer companyId, GetNewIssuedDocumentTotalsRequest getNewIssuedDocumentTotalsRequest, ApiCallback<GetNewIssuedDocumentTotalsResponse> _callback) throws ApiException {
        Call localVarCall = this.getNewIssuedDocumentTotalsValidateBeforeCall(companyId, getNewIssuedDocumentTotalsRequest, _callback);
        Type localVarReturnType = new TypeToken<GetNewIssuedDocumentTotalsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call joinIssuedDocumentsCall(Integer companyId, String ids, Integer group, String type, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/issued_documents/join".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ids != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ids", ids));
        }
        if (group != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("group", group));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call joinIssuedDocumentsValidateBeforeCall(Integer companyId, String ids, Integer group, String type, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling joinIssuedDocuments(Async)");
        }
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling joinIssuedDocuments(Async)");
        }
        return this.joinIssuedDocumentsCall(companyId, ids, group, type, _callback);
    }

    public JoinIssuedDocumentsResponse joinIssuedDocuments(Integer companyId, String ids, Integer group, String type) throws ApiException {
        ApiResponse<JoinIssuedDocumentsResponse> localVarResp = this.joinIssuedDocumentsWithHttpInfo(companyId, ids, group, type);
        return localVarResp.getData();
    }

    public ApiResponse<JoinIssuedDocumentsResponse> joinIssuedDocumentsWithHttpInfo(Integer companyId, String ids, Integer group, String type) throws ApiException {
        Call localVarCall = this.joinIssuedDocumentsValidateBeforeCall(companyId, ids, group, type, null);
        Type localVarReturnType = new TypeToken<JoinIssuedDocumentsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call joinIssuedDocumentsAsync(Integer companyId, String ids, Integer group, String type, ApiCallback<JoinIssuedDocumentsResponse> _callback) throws ApiException {
        Call localVarCall = this.joinIssuedDocumentsValidateBeforeCall(companyId, ids, group, type, _callback);
        Type localVarReturnType = new TypeToken<JoinIssuedDocumentsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listIssuedDocumentsCall(Integer companyId, String type, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, Integer inclusive, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/issued_documents".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if (inclusive != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("inclusive", inclusive));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listIssuedDocumentsValidateBeforeCall(Integer companyId, String type, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, Integer inclusive, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling listIssuedDocuments(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling listIssuedDocuments(Async)");
        }
        return this.listIssuedDocumentsCall(companyId, type, fields, fieldset, sort, page, perPage, q, inclusive, _callback);
    }

    public ListIssuedDocumentsResponse listIssuedDocuments(Integer companyId, String type, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, Integer inclusive) throws ApiException {
        ApiResponse<ListIssuedDocumentsResponse> localVarResp = this.listIssuedDocumentsWithHttpInfo(companyId, type, fields, fieldset, sort, page, perPage, q, inclusive);
        return localVarResp.getData();
    }

    public ApiResponse<ListIssuedDocumentsResponse> listIssuedDocumentsWithHttpInfo(Integer companyId, String type, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, Integer inclusive) throws ApiException {
        Call localVarCall = this.listIssuedDocumentsValidateBeforeCall(companyId, type, fields, fieldset, sort, page, perPage, q, inclusive, null);
        Type localVarReturnType = new TypeToken<ListIssuedDocumentsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listIssuedDocumentsAsync(Integer companyId, String type, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, Integer inclusive, ApiCallback<ListIssuedDocumentsResponse> _callback) throws ApiException {
        Call localVarCall = this.listIssuedDocumentsValidateBeforeCall(companyId, type, fields, fieldset, sort, page, perPage, q, inclusive, _callback);
        Type localVarReturnType = new TypeToken<ListIssuedDocumentsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyIssuedDocumentCall(Integer companyId, Integer documentId, ModifyIssuedDocumentRequest modifyIssuedDocumentRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ModifyIssuedDocumentRequest localVarPostBody = modifyIssuedDocumentRequest;
        String localVarPath = "/c/{company_id}/issued_documents/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyIssuedDocumentValidateBeforeCall(Integer companyId, Integer documentId, ModifyIssuedDocumentRequest modifyIssuedDocumentRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling modifyIssuedDocument(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling modifyIssuedDocument(Async)");
        }
        return this.modifyIssuedDocumentCall(companyId, documentId, modifyIssuedDocumentRequest, _callback);
    }

    public ModifyIssuedDocumentResponse modifyIssuedDocument(Integer companyId, Integer documentId, ModifyIssuedDocumentRequest modifyIssuedDocumentRequest) throws ApiException {
        ApiResponse<ModifyIssuedDocumentResponse> localVarResp = this.modifyIssuedDocumentWithHttpInfo(companyId, documentId, modifyIssuedDocumentRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ModifyIssuedDocumentResponse> modifyIssuedDocumentWithHttpInfo(Integer companyId, Integer documentId, ModifyIssuedDocumentRequest modifyIssuedDocumentRequest) throws ApiException {
        Call localVarCall = this.modifyIssuedDocumentValidateBeforeCall(companyId, documentId, modifyIssuedDocumentRequest, null);
        Type localVarReturnType = new TypeToken<ModifyIssuedDocumentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call modifyIssuedDocumentAsync(Integer companyId, Integer documentId, ModifyIssuedDocumentRequest modifyIssuedDocumentRequest, ApiCallback<ModifyIssuedDocumentResponse> _callback) throws ApiException {
        Call localVarCall = this.modifyIssuedDocumentValidateBeforeCall(companyId, documentId, modifyIssuedDocumentRequest, _callback);
        Type localVarReturnType = new TypeToken<ModifyIssuedDocumentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call scheduleEmailCall(Integer companyId, Integer documentId, ScheduleEmailRequest scheduleEmailRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ScheduleEmailRequest localVarPostBody = scheduleEmailRequest;
        String localVarPath = "/c/{company_id}/issued_documents/{document_id}/email".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call scheduleEmailValidateBeforeCall(Integer companyId, Integer documentId, ScheduleEmailRequest scheduleEmailRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling scheduleEmail(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling scheduleEmail(Async)");
        }
        return this.scheduleEmailCall(companyId, documentId, scheduleEmailRequest, _callback);
    }

    public void scheduleEmail(Integer companyId, Integer documentId, ScheduleEmailRequest scheduleEmailRequest) throws ApiException {
        this.scheduleEmailWithHttpInfo(companyId, documentId, scheduleEmailRequest);
    }

    public ApiResponse<Void> scheduleEmailWithHttpInfo(Integer companyId, Integer documentId, ScheduleEmailRequest scheduleEmailRequest) throws ApiException {
        Call localVarCall = this.scheduleEmailValidateBeforeCall(companyId, documentId, scheduleEmailRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call scheduleEmailAsync(Integer companyId, Integer documentId, ScheduleEmailRequest scheduleEmailRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.scheduleEmailValidateBeforeCall(companyId, documentId, scheduleEmailRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call transformIssuedDocumentCall(Integer companyId, Integer originalDocumentId, String newType, String type, Integer eInvoice, Integer transformKeepCopy, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/issued_documents/transform".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (originalDocumentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("original_document_id", originalDocumentId));
        }
        if (newType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("new_type", newType));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (eInvoice != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("e_invoice", eInvoice));
        }
        if (transformKeepCopy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("transform_keep_copy", transformKeepCopy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call transformIssuedDocumentValidateBeforeCall(Integer companyId, Integer originalDocumentId, String newType, String type, Integer eInvoice, Integer transformKeepCopy, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling transformIssuedDocument(Async)");
        }
        if (originalDocumentId == null) {
            throw new ApiException("Missing the required parameter 'originalDocumentId' when calling transformIssuedDocument(Async)");
        }
        if (newType == null) {
            throw new ApiException("Missing the required parameter 'newType' when calling transformIssuedDocument(Async)");
        }
        return this.transformIssuedDocumentCall(companyId, originalDocumentId, newType, type, eInvoice, transformKeepCopy, _callback);
    }

    public TransformIssuedDocumentResponse transformIssuedDocument(Integer companyId, Integer originalDocumentId, String newType, String type, Integer eInvoice, Integer transformKeepCopy) throws ApiException {
        ApiResponse<TransformIssuedDocumentResponse> localVarResp = this.transformIssuedDocumentWithHttpInfo(companyId, originalDocumentId, newType, type, eInvoice, transformKeepCopy);
        return localVarResp.getData();
    }

    public ApiResponse<TransformIssuedDocumentResponse> transformIssuedDocumentWithHttpInfo(Integer companyId, Integer originalDocumentId, String newType, String type, Integer eInvoice, Integer transformKeepCopy) throws ApiException {
        Call localVarCall = this.transformIssuedDocumentValidateBeforeCall(companyId, originalDocumentId, newType, type, eInvoice, transformKeepCopy, null);
        Type localVarReturnType = new TypeToken<TransformIssuedDocumentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call transformIssuedDocumentAsync(Integer companyId, Integer originalDocumentId, String newType, String type, Integer eInvoice, Integer transformKeepCopy, ApiCallback<TransformIssuedDocumentResponse> _callback) throws ApiException {
        Call localVarCall = this.transformIssuedDocumentValidateBeforeCall(companyId, originalDocumentId, newType, type, eInvoice, transformKeepCopy, _callback);
        Type localVarReturnType = new TypeToken<TransformIssuedDocumentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call uploadIssuedDocumentAttachmentCall(Integer companyId, String filename, File attachment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/issued_documents/attachment".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filename != null) {
            localVarFormParams.put("filename", filename);
        }
        if (attachment != null) {
            localVarFormParams.put("attachment", attachment);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadIssuedDocumentAttachmentValidateBeforeCall(Integer companyId, String filename, File attachment, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling uploadIssuedDocumentAttachment(Async)");
        }
        return this.uploadIssuedDocumentAttachmentCall(companyId, filename, attachment, _callback);
    }

    public UploadIssuedDocumentAttachmentResponse uploadIssuedDocumentAttachment(Integer companyId, String filename, File attachment) throws ApiException {
        ApiResponse<UploadIssuedDocumentAttachmentResponse> localVarResp = this.uploadIssuedDocumentAttachmentWithHttpInfo(companyId, filename, attachment);
        return localVarResp.getData();
    }

    public ApiResponse<UploadIssuedDocumentAttachmentResponse> uploadIssuedDocumentAttachmentWithHttpInfo(Integer companyId, String filename, File attachment) throws ApiException {
        Call localVarCall = this.uploadIssuedDocumentAttachmentValidateBeforeCall(companyId, filename, attachment, null);
        Type localVarReturnType = new TypeToken<UploadIssuedDocumentAttachmentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call uploadIssuedDocumentAttachmentAsync(Integer companyId, String filename, File attachment, ApiCallback<UploadIssuedDocumentAttachmentResponse> _callback) throws ApiException {
        Call localVarCall = this.uploadIssuedDocumentAttachmentValidateBeforeCall(companyId, filename, attachment, _callback);
        Type localVarReturnType = new TypeToken<UploadIssuedDocumentAttachmentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

