/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.api;

import com.google.gson.reflect.TypeToken;
import it.fattureincloud.sdk.ApiCallback;
import it.fattureincloud.sdk.ApiClient;
import it.fattureincloud.sdk.ApiException;
import it.fattureincloud.sdk.ApiResponse;
import it.fattureincloud.sdk.Configuration;
import it.fattureincloud.sdk.Pair;
import it.fattureincloud.sdk.model.ListArchiveCategoriesResponse;
import it.fattureincloud.sdk.model.ListCitiesResponse;
import it.fattureincloud.sdk.model.ListCostCentersResponse;
import it.fattureincloud.sdk.model.ListCountriesResponse;
import it.fattureincloud.sdk.model.ListCurrenciesResponse;
import it.fattureincloud.sdk.model.ListDeliveryNotesDefaultCausalsResponse;
import it.fattureincloud.sdk.model.ListDetailedCountriesResponse;
import it.fattureincloud.sdk.model.ListLanguagesResponse;
import it.fattureincloud.sdk.model.ListPaymentAccountsResponse;
import it.fattureincloud.sdk.model.ListPaymentMethodsResponse;
import it.fattureincloud.sdk.model.ListProductCategoriesResponse;
import it.fattureincloud.sdk.model.ListReceivedDocumentCategoriesResponse;
import it.fattureincloud.sdk.model.ListRevenueCentersResponse;
import it.fattureincloud.sdk.model.ListTemplatesResponse;
import it.fattureincloud.sdk.model.ListUnitsOfMeasureResponse;
import it.fattureincloud.sdk.model.ListVatTypesResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class InfoApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public InfoApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InfoApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call listArchiveCategoriesCall(Integer companyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/info/archive_categories".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listArchiveCategoriesValidateBeforeCall(Integer companyId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling listArchiveCategories(Async)");
        }
        return this.listArchiveCategoriesCall(companyId, _callback);
    }

    public ListArchiveCategoriesResponse listArchiveCategories(Integer companyId) throws ApiException {
        ApiResponse<ListArchiveCategoriesResponse> localVarResp = this.listArchiveCategoriesWithHttpInfo(companyId);
        return localVarResp.getData();
    }

    public ApiResponse<ListArchiveCategoriesResponse> listArchiveCategoriesWithHttpInfo(Integer companyId) throws ApiException {
        Call localVarCall = this.listArchiveCategoriesValidateBeforeCall(companyId, null);
        Type localVarReturnType = new TypeToken<ListArchiveCategoriesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listArchiveCategoriesAsync(Integer companyId, ApiCallback<ListArchiveCategoriesResponse> _callback) throws ApiException {
        Call localVarCall = this.listArchiveCategoriesValidateBeforeCall(companyId, _callback);
        Type localVarReturnType = new TypeToken<ListArchiveCategoriesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCitiesCall(String postalCode, String city, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/info/cities";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (postalCode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("postal_code", postalCode));
        }
        if (city != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("city", city));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCitiesValidateBeforeCall(String postalCode, String city, ApiCallback _callback) throws ApiException {
        return this.listCitiesCall(postalCode, city, _callback);
    }

    public ListCitiesResponse listCities(String postalCode, String city) throws ApiException {
        ApiResponse<ListCitiesResponse> localVarResp = this.listCitiesWithHttpInfo(postalCode, city);
        return localVarResp.getData();
    }

    public ApiResponse<ListCitiesResponse> listCitiesWithHttpInfo(String postalCode, String city) throws ApiException {
        Call localVarCall = this.listCitiesValidateBeforeCall(postalCode, city, null);
        Type localVarReturnType = new TypeToken<ListCitiesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCitiesAsync(String postalCode, String city, ApiCallback<ListCitiesResponse> _callback) throws ApiException {
        Call localVarCall = this.listCitiesValidateBeforeCall(postalCode, city, _callback);
        Type localVarReturnType = new TypeToken<ListCitiesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCostCentersCall(Integer companyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/info/cost_centers".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCostCentersValidateBeforeCall(Integer companyId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling listCostCenters(Async)");
        }
        return this.listCostCentersCall(companyId, _callback);
    }

    public ListCostCentersResponse listCostCenters(Integer companyId) throws ApiException {
        ApiResponse<ListCostCentersResponse> localVarResp = this.listCostCentersWithHttpInfo(companyId);
        return localVarResp.getData();
    }

    public ApiResponse<ListCostCentersResponse> listCostCentersWithHttpInfo(Integer companyId) throws ApiException {
        Call localVarCall = this.listCostCentersValidateBeforeCall(companyId, null);
        Type localVarReturnType = new TypeToken<ListCostCentersResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCostCentersAsync(Integer companyId, ApiCallback<ListCostCentersResponse> _callback) throws ApiException {
        Call localVarCall = this.listCostCentersValidateBeforeCall(companyId, _callback);
        Type localVarReturnType = new TypeToken<ListCostCentersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCountriesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/info/countries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCountriesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.listCountriesCall(_callback);
    }

    public ListCountriesResponse listCountries() throws ApiException {
        ApiResponse<ListCountriesResponse> localVarResp = this.listCountriesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<ListCountriesResponse> listCountriesWithHttpInfo() throws ApiException {
        Call localVarCall = this.listCountriesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ListCountriesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCountriesAsync(ApiCallback<ListCountriesResponse> _callback) throws ApiException {
        Call localVarCall = this.listCountriesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ListCountriesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCurrenciesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/info/currencies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCurrenciesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.listCurrenciesCall(_callback);
    }

    public ListCurrenciesResponse listCurrencies() throws ApiException {
        ApiResponse<ListCurrenciesResponse> localVarResp = this.listCurrenciesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<ListCurrenciesResponse> listCurrenciesWithHttpInfo() throws ApiException {
        Call localVarCall = this.listCurrenciesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ListCurrenciesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCurrenciesAsync(ApiCallback<ListCurrenciesResponse> _callback) throws ApiException {
        Call localVarCall = this.listCurrenciesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ListCurrenciesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listDeliveryNotesDefaultCausalsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/info/dn_causals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDeliveryNotesDefaultCausalsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.listDeliveryNotesDefaultCausalsCall(_callback);
    }

    public ListDeliveryNotesDefaultCausalsResponse listDeliveryNotesDefaultCausals() throws ApiException {
        ApiResponse<ListDeliveryNotesDefaultCausalsResponse> localVarResp = this.listDeliveryNotesDefaultCausalsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<ListDeliveryNotesDefaultCausalsResponse> listDeliveryNotesDefaultCausalsWithHttpInfo() throws ApiException {
        Call localVarCall = this.listDeliveryNotesDefaultCausalsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ListDeliveryNotesDefaultCausalsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listDeliveryNotesDefaultCausalsAsync(ApiCallback<ListDeliveryNotesDefaultCausalsResponse> _callback) throws ApiException {
        Call localVarCall = this.listDeliveryNotesDefaultCausalsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ListDeliveryNotesDefaultCausalsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listDetailedCountriesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/info/detailed_countries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDetailedCountriesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.listDetailedCountriesCall(_callback);
    }

    public ListDetailedCountriesResponse listDetailedCountries() throws ApiException {
        ApiResponse<ListDetailedCountriesResponse> localVarResp = this.listDetailedCountriesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<ListDetailedCountriesResponse> listDetailedCountriesWithHttpInfo() throws ApiException {
        Call localVarCall = this.listDetailedCountriesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ListDetailedCountriesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listDetailedCountriesAsync(ApiCallback<ListDetailedCountriesResponse> _callback) throws ApiException {
        Call localVarCall = this.listDetailedCountriesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ListDetailedCountriesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listLanguagesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/info/languages";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listLanguagesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.listLanguagesCall(_callback);
    }

    public ListLanguagesResponse listLanguages() throws ApiException {
        ApiResponse<ListLanguagesResponse> localVarResp = this.listLanguagesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<ListLanguagesResponse> listLanguagesWithHttpInfo() throws ApiException {
        Call localVarCall = this.listLanguagesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ListLanguagesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listLanguagesAsync(ApiCallback<ListLanguagesResponse> _callback) throws ApiException {
        Call localVarCall = this.listLanguagesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ListLanguagesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listPaymentAccountsCall(Integer companyId, String fields, String fieldset, String sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/info/payment_accounts".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listPaymentAccountsValidateBeforeCall(Integer companyId, String fields, String fieldset, String sort, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling listPaymentAccounts(Async)");
        }
        return this.listPaymentAccountsCall(companyId, fields, fieldset, sort, _callback);
    }

    public ListPaymentAccountsResponse listPaymentAccounts(Integer companyId, String fields, String fieldset, String sort) throws ApiException {
        ApiResponse<ListPaymentAccountsResponse> localVarResp = this.listPaymentAccountsWithHttpInfo(companyId, fields, fieldset, sort);
        return localVarResp.getData();
    }

    public ApiResponse<ListPaymentAccountsResponse> listPaymentAccountsWithHttpInfo(Integer companyId, String fields, String fieldset, String sort) throws ApiException {
        Call localVarCall = this.listPaymentAccountsValidateBeforeCall(companyId, fields, fieldset, sort, null);
        Type localVarReturnType = new TypeToken<ListPaymentAccountsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listPaymentAccountsAsync(Integer companyId, String fields, String fieldset, String sort, ApiCallback<ListPaymentAccountsResponse> _callback) throws ApiException {
        Call localVarCall = this.listPaymentAccountsValidateBeforeCall(companyId, fields, fieldset, sort, _callback);
        Type localVarReturnType = new TypeToken<ListPaymentAccountsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listPaymentMethodsCall(Integer companyId, String fields, String fieldset, String sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/info/payment_methods".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listPaymentMethodsValidateBeforeCall(Integer companyId, String fields, String fieldset, String sort, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling listPaymentMethods(Async)");
        }
        return this.listPaymentMethodsCall(companyId, fields, fieldset, sort, _callback);
    }

    public ListPaymentMethodsResponse listPaymentMethods(Integer companyId, String fields, String fieldset, String sort) throws ApiException {
        ApiResponse<ListPaymentMethodsResponse> localVarResp = this.listPaymentMethodsWithHttpInfo(companyId, fields, fieldset, sort);
        return localVarResp.getData();
    }

    public ApiResponse<ListPaymentMethodsResponse> listPaymentMethodsWithHttpInfo(Integer companyId, String fields, String fieldset, String sort) throws ApiException {
        Call localVarCall = this.listPaymentMethodsValidateBeforeCall(companyId, fields, fieldset, sort, null);
        Type localVarReturnType = new TypeToken<ListPaymentMethodsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listPaymentMethodsAsync(Integer companyId, String fields, String fieldset, String sort, ApiCallback<ListPaymentMethodsResponse> _callback) throws ApiException {
        Call localVarCall = this.listPaymentMethodsValidateBeforeCall(companyId, fields, fieldset, sort, _callback);
        Type localVarReturnType = new TypeToken<ListPaymentMethodsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listProductCategoriesCall(Integer companyId, String context, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/info/product_categories".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (context != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("context", context));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listProductCategoriesValidateBeforeCall(Integer companyId, String context, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling listProductCategories(Async)");
        }
        if (context == null) {
            throw new ApiException("Missing the required parameter 'context' when calling listProductCategories(Async)");
        }
        return this.listProductCategoriesCall(companyId, context, _callback);
    }

    public ListProductCategoriesResponse listProductCategories(Integer companyId, String context) throws ApiException {
        ApiResponse<ListProductCategoriesResponse> localVarResp = this.listProductCategoriesWithHttpInfo(companyId, context);
        return localVarResp.getData();
    }

    public ApiResponse<ListProductCategoriesResponse> listProductCategoriesWithHttpInfo(Integer companyId, String context) throws ApiException {
        Call localVarCall = this.listProductCategoriesValidateBeforeCall(companyId, context, null);
        Type localVarReturnType = new TypeToken<ListProductCategoriesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listProductCategoriesAsync(Integer companyId, String context, ApiCallback<ListProductCategoriesResponse> _callback) throws ApiException {
        Call localVarCall = this.listProductCategoriesValidateBeforeCall(companyId, context, _callback);
        Type localVarReturnType = new TypeToken<ListProductCategoriesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listReceivedDocumentCategoriesCall(Integer companyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/info/received_document_categories".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listReceivedDocumentCategoriesValidateBeforeCall(Integer companyId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling listReceivedDocumentCategories(Async)");
        }
        return this.listReceivedDocumentCategoriesCall(companyId, _callback);
    }

    public ListReceivedDocumentCategoriesResponse listReceivedDocumentCategories(Integer companyId) throws ApiException {
        ApiResponse<ListReceivedDocumentCategoriesResponse> localVarResp = this.listReceivedDocumentCategoriesWithHttpInfo(companyId);
        return localVarResp.getData();
    }

    public ApiResponse<ListReceivedDocumentCategoriesResponse> listReceivedDocumentCategoriesWithHttpInfo(Integer companyId) throws ApiException {
        Call localVarCall = this.listReceivedDocumentCategoriesValidateBeforeCall(companyId, null);
        Type localVarReturnType = new TypeToken<ListReceivedDocumentCategoriesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listReceivedDocumentCategoriesAsync(Integer companyId, ApiCallback<ListReceivedDocumentCategoriesResponse> _callback) throws ApiException {
        Call localVarCall = this.listReceivedDocumentCategoriesValidateBeforeCall(companyId, _callback);
        Type localVarReturnType = new TypeToken<ListReceivedDocumentCategoriesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listRevenueCentersCall(Integer companyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/info/revenue_centers".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRevenueCentersValidateBeforeCall(Integer companyId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling listRevenueCenters(Async)");
        }
        return this.listRevenueCentersCall(companyId, _callback);
    }

    public ListRevenueCentersResponse listRevenueCenters(Integer companyId) throws ApiException {
        ApiResponse<ListRevenueCentersResponse> localVarResp = this.listRevenueCentersWithHttpInfo(companyId);
        return localVarResp.getData();
    }

    public ApiResponse<ListRevenueCentersResponse> listRevenueCentersWithHttpInfo(Integer companyId) throws ApiException {
        Call localVarCall = this.listRevenueCentersValidateBeforeCall(companyId, null);
        Type localVarReturnType = new TypeToken<ListRevenueCentersResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listRevenueCentersAsync(Integer companyId, ApiCallback<ListRevenueCentersResponse> _callback) throws ApiException {
        Call localVarCall = this.listRevenueCentersValidateBeforeCall(companyId, _callback);
        Type localVarReturnType = new TypeToken<ListRevenueCentersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listTemplatesCall(String type, Boolean byType, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/info/templates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (byType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("by_type", byType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTemplatesValidateBeforeCall(String type, Boolean byType, ApiCallback _callback) throws ApiException {
        return this.listTemplatesCall(type, byType, _callback);
    }

    public ListTemplatesResponse listTemplates(String type, Boolean byType) throws ApiException {
        ApiResponse<ListTemplatesResponse> localVarResp = this.listTemplatesWithHttpInfo(type, byType);
        return localVarResp.getData();
    }

    public ApiResponse<ListTemplatesResponse> listTemplatesWithHttpInfo(String type, Boolean byType) throws ApiException {
        Call localVarCall = this.listTemplatesValidateBeforeCall(type, byType, null);
        Type localVarReturnType = new TypeToken<ListTemplatesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listTemplatesAsync(String type, Boolean byType, ApiCallback<ListTemplatesResponse> _callback) throws ApiException {
        Call localVarCall = this.listTemplatesValidateBeforeCall(type, byType, _callback);
        Type localVarReturnType = new TypeToken<ListTemplatesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUnitsOfMeasureCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/info/measures";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUnitsOfMeasureValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.listUnitsOfMeasureCall(_callback);
    }

    public ListUnitsOfMeasureResponse listUnitsOfMeasure() throws ApiException {
        ApiResponse<ListUnitsOfMeasureResponse> localVarResp = this.listUnitsOfMeasureWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<ListUnitsOfMeasureResponse> listUnitsOfMeasureWithHttpInfo() throws ApiException {
        Call localVarCall = this.listUnitsOfMeasureValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ListUnitsOfMeasureResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listUnitsOfMeasureAsync(ApiCallback<ListUnitsOfMeasureResponse> _callback) throws ApiException {
        Call localVarCall = this.listUnitsOfMeasureValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ListUnitsOfMeasureResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listVatTypesCall(Integer companyId, String fieldset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/info/vat_types".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listVatTypesValidateBeforeCall(Integer companyId, String fieldset, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling listVatTypes(Async)");
        }
        return this.listVatTypesCall(companyId, fieldset, _callback);
    }

    public ListVatTypesResponse listVatTypes(Integer companyId, String fieldset) throws ApiException {
        ApiResponse<ListVatTypesResponse> localVarResp = this.listVatTypesWithHttpInfo(companyId, fieldset);
        return localVarResp.getData();
    }

    public ApiResponse<ListVatTypesResponse> listVatTypesWithHttpInfo(Integer companyId, String fieldset) throws ApiException {
        Call localVarCall = this.listVatTypesValidateBeforeCall(companyId, fieldset, null);
        Type localVarReturnType = new TypeToken<ListVatTypesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listVatTypesAsync(Integer companyId, String fieldset, ApiCallback<ListVatTypesResponse> _callback) throws ApiException {
        Call localVarCall = this.listVatTypesValidateBeforeCall(companyId, fieldset, _callback);
        Type localVarReturnType = new TypeToken<ListVatTypesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

