/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.api;

import com.google.gson.reflect.TypeToken;
import it.fattureincloud.sdk.ApiCallback;
import it.fattureincloud.sdk.ApiClient;
import it.fattureincloud.sdk.ApiException;
import it.fattureincloud.sdk.ApiResponse;
import it.fattureincloud.sdk.Configuration;
import it.fattureincloud.sdk.Pair;
import it.fattureincloud.sdk.model.CreateClientRequest;
import it.fattureincloud.sdk.model.CreateClientResponse;
import it.fattureincloud.sdk.model.GetClientResponse;
import it.fattureincloud.sdk.model.ListClientsResponse;
import it.fattureincloud.sdk.model.ModifyClientRequest;
import it.fattureincloud.sdk.model.ModifyClientResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ClientsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ClientsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ClientsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createClientCall(Integer companyId, CreateClientRequest createClientRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateClientRequest localVarPostBody = createClientRequest;
        String localVarPath = "/c/{company_id}/entities/clients".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createClientValidateBeforeCall(Integer companyId, CreateClientRequest createClientRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling createClient(Async)");
        }
        return this.createClientCall(companyId, createClientRequest, _callback);
    }

    public CreateClientResponse createClient(Integer companyId, CreateClientRequest createClientRequest) throws ApiException {
        ApiResponse<CreateClientResponse> localVarResp = this.createClientWithHttpInfo(companyId, createClientRequest);
        return localVarResp.getData();
    }

    public ApiResponse<CreateClientResponse> createClientWithHttpInfo(Integer companyId, CreateClientRequest createClientRequest) throws ApiException {
        Call localVarCall = this.createClientValidateBeforeCall(companyId, createClientRequest, null);
        Type localVarReturnType = new TypeToken<CreateClientResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createClientAsync(Integer companyId, CreateClientRequest createClientRequest, ApiCallback<CreateClientResponse> _callback) throws ApiException {
        Call localVarCall = this.createClientValidateBeforeCall(companyId, createClientRequest, _callback);
        Type localVarReturnType = new TypeToken<CreateClientResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteClientCall(Integer companyId, Integer clientId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/entities/clients/{client_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{client_id}", this.localVarApiClient.escapeString(clientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteClientValidateBeforeCall(Integer companyId, Integer clientId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling deleteClient(Async)");
        }
        if (clientId == null) {
            throw new ApiException("Missing the required parameter 'clientId' when calling deleteClient(Async)");
        }
        return this.deleteClientCall(companyId, clientId, _callback);
    }

    public void deleteClient(Integer companyId, Integer clientId) throws ApiException {
        this.deleteClientWithHttpInfo(companyId, clientId);
    }

    public ApiResponse<Void> deleteClientWithHttpInfo(Integer companyId, Integer clientId) throws ApiException {
        Call localVarCall = this.deleteClientValidateBeforeCall(companyId, clientId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteClientAsync(Integer companyId, Integer clientId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteClientValidateBeforeCall(companyId, clientId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getClientCall(Integer companyId, Integer clientId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/entities/clients/{client_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{client_id}", this.localVarApiClient.escapeString(clientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getClientValidateBeforeCall(Integer companyId, Integer clientId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getClient(Async)");
        }
        if (clientId == null) {
            throw new ApiException("Missing the required parameter 'clientId' when calling getClient(Async)");
        }
        return this.getClientCall(companyId, clientId, fields, fieldset, _callback);
    }

    public GetClientResponse getClient(Integer companyId, Integer clientId, String fields, String fieldset) throws ApiException {
        ApiResponse<GetClientResponse> localVarResp = this.getClientWithHttpInfo(companyId, clientId, fields, fieldset);
        return localVarResp.getData();
    }

    public ApiResponse<GetClientResponse> getClientWithHttpInfo(Integer companyId, Integer clientId, String fields, String fieldset) throws ApiException {
        Call localVarCall = this.getClientValidateBeforeCall(companyId, clientId, fields, fieldset, null);
        Type localVarReturnType = new TypeToken<GetClientResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getClientAsync(Integer companyId, Integer clientId, String fields, String fieldset, ApiCallback<GetClientResponse> _callback) throws ApiException {
        Call localVarCall = this.getClientValidateBeforeCall(companyId, clientId, fields, fieldset, _callback);
        Type localVarReturnType = new TypeToken<GetClientResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listClientsCall(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/entities/clients".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listClientsValidateBeforeCall(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling listClients(Async)");
        }
        return this.listClientsCall(companyId, fields, fieldset, sort, page, perPage, q, _callback);
    }

    public ListClientsResponse listClients(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q) throws ApiException {
        ApiResponse<ListClientsResponse> localVarResp = this.listClientsWithHttpInfo(companyId, fields, fieldset, sort, page, perPage, q);
        return localVarResp.getData();
    }

    public ApiResponse<ListClientsResponse> listClientsWithHttpInfo(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q) throws ApiException {
        Call localVarCall = this.listClientsValidateBeforeCall(companyId, fields, fieldset, sort, page, perPage, q, null);
        Type localVarReturnType = new TypeToken<ListClientsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listClientsAsync(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback<ListClientsResponse> _callback) throws ApiException {
        Call localVarCall = this.listClientsValidateBeforeCall(companyId, fields, fieldset, sort, page, perPage, q, _callback);
        Type localVarReturnType = new TypeToken<ListClientsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyClientCall(Integer companyId, Integer clientId, ModifyClientRequest modifyClientRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ModifyClientRequest localVarPostBody = modifyClientRequest;
        String localVarPath = "/c/{company_id}/entities/clients/{client_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{client_id}", this.localVarApiClient.escapeString(clientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyClientValidateBeforeCall(Integer companyId, Integer clientId, ModifyClientRequest modifyClientRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling modifyClient(Async)");
        }
        if (clientId == null) {
            throw new ApiException("Missing the required parameter 'clientId' when calling modifyClient(Async)");
        }
        return this.modifyClientCall(companyId, clientId, modifyClientRequest, _callback);
    }

    public ModifyClientResponse modifyClient(Integer companyId, Integer clientId, ModifyClientRequest modifyClientRequest) throws ApiException {
        ApiResponse<ModifyClientResponse> localVarResp = this.modifyClientWithHttpInfo(companyId, clientId, modifyClientRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ModifyClientResponse> modifyClientWithHttpInfo(Integer companyId, Integer clientId, ModifyClientRequest modifyClientRequest) throws ApiException {
        Call localVarCall = this.modifyClientValidateBeforeCall(companyId, clientId, modifyClientRequest, null);
        Type localVarReturnType = new TypeToken<ModifyClientResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call modifyClientAsync(Integer companyId, Integer clientId, ModifyClientRequest modifyClientRequest, ApiCallback<ModifyClientResponse> _callback) throws ApiException {
        Call localVarCall = this.modifyClientValidateBeforeCall(companyId, clientId, modifyClientRequest, _callback);
        Type localVarReturnType = new TypeToken<ModifyClientResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

