/*
 * Decompiled with CFR 0.152.
 */
package it.fattureincloud.sdk.api;

import com.google.gson.reflect.TypeToken;
import it.fattureincloud.sdk.ApiCallback;
import it.fattureincloud.sdk.ApiClient;
import it.fattureincloud.sdk.ApiException;
import it.fattureincloud.sdk.ApiResponse;
import it.fattureincloud.sdk.Configuration;
import it.fattureincloud.sdk.Pair;
import it.fattureincloud.sdk.model.CreateArchiveDocumentRequest;
import it.fattureincloud.sdk.model.CreateArchiveDocumentResponse;
import it.fattureincloud.sdk.model.GetArchiveDocumentResponse;
import it.fattureincloud.sdk.model.ListArchiveDocumentsResponse;
import it.fattureincloud.sdk.model.ModifyArchiveDocumentRequest;
import it.fattureincloud.sdk.model.ModifyArchiveDocumentResponse;
import it.fattureincloud.sdk.model.UploadArchiveAttachmentResponse;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ArchiveApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ArchiveApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ArchiveApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createArchiveDocumentCall(Integer companyId, CreateArchiveDocumentRequest createArchiveDocumentRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateArchiveDocumentRequest localVarPostBody = createArchiveDocumentRequest;
        String localVarPath = "/c/{company_id}/archive".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createArchiveDocumentValidateBeforeCall(Integer companyId, CreateArchiveDocumentRequest createArchiveDocumentRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling createArchiveDocument(Async)");
        }
        return this.createArchiveDocumentCall(companyId, createArchiveDocumentRequest, _callback);
    }

    public CreateArchiveDocumentResponse createArchiveDocument(Integer companyId, CreateArchiveDocumentRequest createArchiveDocumentRequest) throws ApiException {
        ApiResponse<CreateArchiveDocumentResponse> localVarResp = this.createArchiveDocumentWithHttpInfo(companyId, createArchiveDocumentRequest);
        return localVarResp.getData();
    }

    public ApiResponse<CreateArchiveDocumentResponse> createArchiveDocumentWithHttpInfo(Integer companyId, CreateArchiveDocumentRequest createArchiveDocumentRequest) throws ApiException {
        Call localVarCall = this.createArchiveDocumentValidateBeforeCall(companyId, createArchiveDocumentRequest, null);
        Type localVarReturnType = new TypeToken<CreateArchiveDocumentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createArchiveDocumentAsync(Integer companyId, CreateArchiveDocumentRequest createArchiveDocumentRequest, ApiCallback<CreateArchiveDocumentResponse> _callback) throws ApiException {
        Call localVarCall = this.createArchiveDocumentValidateBeforeCall(companyId, createArchiveDocumentRequest, _callback);
        Type localVarReturnType = new TypeToken<CreateArchiveDocumentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteArchiveDocumentCall(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/archive/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteArchiveDocumentValidateBeforeCall(Integer companyId, Integer documentId, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling deleteArchiveDocument(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling deleteArchiveDocument(Async)");
        }
        return this.deleteArchiveDocumentCall(companyId, documentId, _callback);
    }

    public void deleteArchiveDocument(Integer companyId, Integer documentId) throws ApiException {
        this.deleteArchiveDocumentWithHttpInfo(companyId, documentId);
    }

    public ApiResponse<Void> deleteArchiveDocumentWithHttpInfo(Integer companyId, Integer documentId) throws ApiException {
        Call localVarCall = this.deleteArchiveDocumentValidateBeforeCall(companyId, documentId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteArchiveDocumentAsync(Integer companyId, Integer documentId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteArchiveDocumentValidateBeforeCall(companyId, documentId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getArchiveDocumentCall(Integer companyId, Integer documentId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/archive/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getArchiveDocumentValidateBeforeCall(Integer companyId, Integer documentId, String fields, String fieldset, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling getArchiveDocument(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getArchiveDocument(Async)");
        }
        return this.getArchiveDocumentCall(companyId, documentId, fields, fieldset, _callback);
    }

    public GetArchiveDocumentResponse getArchiveDocument(Integer companyId, Integer documentId, String fields, String fieldset) throws ApiException {
        ApiResponse<GetArchiveDocumentResponse> localVarResp = this.getArchiveDocumentWithHttpInfo(companyId, documentId, fields, fieldset);
        return localVarResp.getData();
    }

    public ApiResponse<GetArchiveDocumentResponse> getArchiveDocumentWithHttpInfo(Integer companyId, Integer documentId, String fields, String fieldset) throws ApiException {
        Call localVarCall = this.getArchiveDocumentValidateBeforeCall(companyId, documentId, fields, fieldset, null);
        Type localVarReturnType = new TypeToken<GetArchiveDocumentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getArchiveDocumentAsync(Integer companyId, Integer documentId, String fields, String fieldset, ApiCallback<GetArchiveDocumentResponse> _callback) throws ApiException {
        Call localVarCall = this.getArchiveDocumentValidateBeforeCall(companyId, documentId, fields, fieldset, _callback);
        Type localVarReturnType = new TypeToken<GetArchiveDocumentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listArchiveDocumentsCall(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/archive".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (fieldset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldset", fieldset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listArchiveDocumentsValidateBeforeCall(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling listArchiveDocuments(Async)");
        }
        return this.listArchiveDocumentsCall(companyId, fields, fieldset, sort, page, perPage, q, _callback);
    }

    public ListArchiveDocumentsResponse listArchiveDocuments(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q) throws ApiException {
        ApiResponse<ListArchiveDocumentsResponse> localVarResp = this.listArchiveDocumentsWithHttpInfo(companyId, fields, fieldset, sort, page, perPage, q);
        return localVarResp.getData();
    }

    public ApiResponse<ListArchiveDocumentsResponse> listArchiveDocumentsWithHttpInfo(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q) throws ApiException {
        Call localVarCall = this.listArchiveDocumentsValidateBeforeCall(companyId, fields, fieldset, sort, page, perPage, q, null);
        Type localVarReturnType = new TypeToken<ListArchiveDocumentsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listArchiveDocumentsAsync(Integer companyId, String fields, String fieldset, String sort, Integer page, Integer perPage, String q, ApiCallback<ListArchiveDocumentsResponse> _callback) throws ApiException {
        Call localVarCall = this.listArchiveDocumentsValidateBeforeCall(companyId, fields, fieldset, sort, page, perPage, q, _callback);
        Type localVarReturnType = new TypeToken<ListArchiveDocumentsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyArchiveDocumentCall(Integer companyId, Integer documentId, ModifyArchiveDocumentRequest modifyArchiveDocumentRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ModifyArchiveDocumentRequest localVarPostBody = modifyArchiveDocumentRequest;
        String localVarPath = "/c/{company_id}/archive/{document_id}".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString())).replace("{document_id}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyArchiveDocumentValidateBeforeCall(Integer companyId, Integer documentId, ModifyArchiveDocumentRequest modifyArchiveDocumentRequest, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling modifyArchiveDocument(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling modifyArchiveDocument(Async)");
        }
        return this.modifyArchiveDocumentCall(companyId, documentId, modifyArchiveDocumentRequest, _callback);
    }

    public ModifyArchiveDocumentResponse modifyArchiveDocument(Integer companyId, Integer documentId, ModifyArchiveDocumentRequest modifyArchiveDocumentRequest) throws ApiException {
        ApiResponse<ModifyArchiveDocumentResponse> localVarResp = this.modifyArchiveDocumentWithHttpInfo(companyId, documentId, modifyArchiveDocumentRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ModifyArchiveDocumentResponse> modifyArchiveDocumentWithHttpInfo(Integer companyId, Integer documentId, ModifyArchiveDocumentRequest modifyArchiveDocumentRequest) throws ApiException {
        Call localVarCall = this.modifyArchiveDocumentValidateBeforeCall(companyId, documentId, modifyArchiveDocumentRequest, null);
        Type localVarReturnType = new TypeToken<ModifyArchiveDocumentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call modifyArchiveDocumentAsync(Integer companyId, Integer documentId, ModifyArchiveDocumentRequest modifyArchiveDocumentRequest, ApiCallback<ModifyArchiveDocumentResponse> _callback) throws ApiException {
        Call localVarCall = this.modifyArchiveDocumentValidateBeforeCall(companyId, documentId, modifyArchiveDocumentRequest, _callback);
        Type localVarReturnType = new TypeToken<ModifyArchiveDocumentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call uploadArchiveDocumentAttachmentCall(Integer companyId, String filename, File attachment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/c/{company_id}/archive/attachment".replace("{company_id}", this.localVarApiClient.escapeString(companyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filename != null) {
            localVarFormParams.put("filename", filename);
        }
        if (attachment != null) {
            localVarFormParams.put("attachment", attachment);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2AuthenticationCodeFlow"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadArchiveDocumentAttachmentValidateBeforeCall(Integer companyId, String filename, File attachment, ApiCallback _callback) throws ApiException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId' when calling uploadArchiveDocumentAttachment(Async)");
        }
        return this.uploadArchiveDocumentAttachmentCall(companyId, filename, attachment, _callback);
    }

    public UploadArchiveAttachmentResponse uploadArchiveDocumentAttachment(Integer companyId, String filename, File attachment) throws ApiException {
        ApiResponse<UploadArchiveAttachmentResponse> localVarResp = this.uploadArchiveDocumentAttachmentWithHttpInfo(companyId, filename, attachment);
        return localVarResp.getData();
    }

    public ApiResponse<UploadArchiveAttachmentResponse> uploadArchiveDocumentAttachmentWithHttpInfo(Integer companyId, String filename, File attachment) throws ApiException {
        Call localVarCall = this.uploadArchiveDocumentAttachmentValidateBeforeCall(companyId, filename, attachment, null);
        Type localVarReturnType = new TypeToken<UploadArchiveAttachmentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call uploadArchiveDocumentAttachmentAsync(Integer companyId, String filename, File attachment, ApiCallback<UploadArchiveAttachmentResponse> _callback) throws ApiException {
        Call localVarCall = this.uploadArchiveDocumentAttachmentValidateBeforeCall(companyId, filename, attachment, _callback);
        Type localVarReturnType = new TypeToken<UploadArchiveAttachmentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

