/*
 * Fatture in Cloud API v2 - API Reference
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.
 *
 * The version of the OpenAPI document: 2.1.3
 * Contact: info@fattureincloud.it
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package it.fattureincloud.sdk.api;

import com.google.gson.reflect.TypeToken;
import it.fattureincloud.sdk.ApiCallback;
import it.fattureincloud.sdk.ApiClient;
import it.fattureincloud.sdk.ApiException;
import it.fattureincloud.sdk.ApiResponse;
import it.fattureincloud.sdk.Configuration;
import it.fattureincloud.sdk.Pair;
import it.fattureincloud.sdk.model.CreateWebhooksSubscriptionRequest;
import it.fattureincloud.sdk.model.CreateWebhooksSubscriptionResponse;
import it.fattureincloud.sdk.model.GetWebhooksSubscriptionResponse;
import it.fattureincloud.sdk.model.ListWebhooksSubscriptionsResponse;
import it.fattureincloud.sdk.model.ModifyWebhooksSubscriptionRequest;
import it.fattureincloud.sdk.model.ModifyWebhooksSubscriptionResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebhooksApi {
  private ApiClient localVarApiClient;
  private int localHostIndex;
  private String localCustomBaseUrl;

  public WebhooksApi() {
    this(Configuration.getDefaultApiClient());
  }

  public WebhooksApi(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return localVarApiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  public int getHostIndex() {
    return localHostIndex;
  }

  public void setHostIndex(int hostIndex) {
    this.localHostIndex = hostIndex;
  }

  public String getCustomBaseUrl() {
    return localCustomBaseUrl;
  }

  public void setCustomBaseUrl(String customBaseUrl) {
    this.localCustomBaseUrl = customBaseUrl;
  }

  /**
   * Build call for createWebhooksSubscription
   *
   * @param companyId The ID of the company. (required)
   * @param createWebhooksSubscriptionRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call createWebhooksSubscriptionCall(
      Integer companyId,
      CreateWebhooksSubscriptionRequest createWebhooksSubscriptionRequest,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = createWebhooksSubscriptionRequest;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/subscriptions"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call createWebhooksSubscriptionValidateBeforeCall(
      Integer companyId,
      CreateWebhooksSubscriptionRequest createWebhooksSubscriptionRequest,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling createWebhooksSubscription(Async)");
    }

    return createWebhooksSubscriptionCall(companyId, createWebhooksSubscriptionRequest, _callback);
  }

  /**
   * Create a Webhook Subscription Register some webhooks Subscriptions.
   *
   * @param companyId The ID of the company. (required)
   * @param createWebhooksSubscriptionRequest (optional)
   * @return CreateWebhooksSubscriptionResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public CreateWebhooksSubscriptionResponse createWebhooksSubscription(
      Integer companyId, CreateWebhooksSubscriptionRequest createWebhooksSubscriptionRequest)
      throws ApiException {
    ApiResponse<CreateWebhooksSubscriptionResponse> localVarResp =
        createWebhooksSubscriptionWithHttpInfo(companyId, createWebhooksSubscriptionRequest);
    return localVarResp.getData();
  }

  /**
   * Create a Webhook Subscription Register some webhooks Subscriptions.
   *
   * @param companyId The ID of the company. (required)
   * @param createWebhooksSubscriptionRequest (optional)
   * @return ApiResponse&lt;CreateWebhooksSubscriptionResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<CreateWebhooksSubscriptionResponse> createWebhooksSubscriptionWithHttpInfo(
      Integer companyId, CreateWebhooksSubscriptionRequest createWebhooksSubscriptionRequest)
      throws ApiException {
    okhttp3.Call localVarCall =
        createWebhooksSubscriptionValidateBeforeCall(
            companyId, createWebhooksSubscriptionRequest, null);
    Type localVarReturnType = new TypeToken<CreateWebhooksSubscriptionResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Create a Webhook Subscription (asynchronously) Register some webhooks Subscriptions.
   *
   * @param companyId The ID of the company. (required)
   * @param createWebhooksSubscriptionRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call createWebhooksSubscriptionAsync(
      Integer companyId,
      CreateWebhooksSubscriptionRequest createWebhooksSubscriptionRequest,
      final ApiCallback<CreateWebhooksSubscriptionResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        createWebhooksSubscriptionValidateBeforeCall(
            companyId, createWebhooksSubscriptionRequest, _callback);
    Type localVarReturnType = new TypeToken<CreateWebhooksSubscriptionResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for deleteWebhooksSubscription
   *
   * @param companyId The ID of the company. (required)
   * @param subscriptionId The ID of the subscription. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call deleteWebhooksSubscriptionCall(
      Integer companyId, String subscriptionId, final ApiCallback _callback) throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/subscriptions/{subscription_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "subscription_id" + "}",
                localVarApiClient.escapeString(subscriptionId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call deleteWebhooksSubscriptionValidateBeforeCall(
      Integer companyId, String subscriptionId, final ApiCallback _callback) throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling deleteWebhooksSubscription(Async)");
    }

    // verify the required parameter 'subscriptionId' is set
    if (subscriptionId == null) {
      throw new ApiException(
          "Missing the required parameter 'subscriptionId' when calling deleteWebhooksSubscription(Async)");
    }

    return deleteWebhooksSubscriptionCall(companyId, subscriptionId, _callback);
  }

  /**
   * Delete Webhooks Subscription Delete a webhooks subscription.
   *
   * @param companyId The ID of the company. (required)
   * @param subscriptionId The ID of the subscription. (required)
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * </table>
   */
  public void deleteWebhooksSubscription(Integer companyId, String subscriptionId)
      throws ApiException {
    deleteWebhooksSubscriptionWithHttpInfo(companyId, subscriptionId);
  }

  /**
   * Delete Webhooks Subscription Delete a webhooks subscription.
   *
   * @param companyId The ID of the company. (required)
   * @param subscriptionId The ID of the subscription. (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<Void> deleteWebhooksSubscriptionWithHttpInfo(
      Integer companyId, String subscriptionId) throws ApiException {
    okhttp3.Call localVarCall =
        deleteWebhooksSubscriptionValidateBeforeCall(companyId, subscriptionId, null);
    return localVarApiClient.execute(localVarCall);
  }

  /**
   * Delete Webhooks Subscription (asynchronously) Delete a webhooks subscription.
   *
   * @param companyId The ID of the company. (required)
   * @param subscriptionId The ID of the subscription. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call deleteWebhooksSubscriptionAsync(
      Integer companyId, String subscriptionId, final ApiCallback<Void> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        deleteWebhooksSubscriptionValidateBeforeCall(companyId, subscriptionId, _callback);
    localVarApiClient.executeAsync(localVarCall, _callback);
    return localVarCall;
  }
  /**
   * Build call for getWebhooksSubscription
   *
   * @param companyId The ID of the company. (required)
   * @param subscriptionId The ID of the subscription. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getWebhooksSubscriptionCall(
      Integer companyId, String subscriptionId, final ApiCallback _callback) throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/subscriptions/{subscription_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "subscription_id" + "}",
                localVarApiClient.escapeString(subscriptionId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getWebhooksSubscriptionValidateBeforeCall(
      Integer companyId, String subscriptionId, final ApiCallback _callback) throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling getWebhooksSubscription(Async)");
    }

    // verify the required parameter 'subscriptionId' is set
    if (subscriptionId == null) {
      throw new ApiException(
          "Missing the required parameter 'subscriptionId' when calling getWebhooksSubscription(Async)");
    }

    return getWebhooksSubscriptionCall(companyId, subscriptionId, _callback);
  }

  /**
   * Get Webhooks Subscription Get a webhooks subscription.
   *
   * @param companyId The ID of the company. (required)
   * @param subscriptionId The ID of the subscription. (required)
   * @return GetWebhooksSubscriptionResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public GetWebhooksSubscriptionResponse getWebhooksSubscription(
      Integer companyId, String subscriptionId) throws ApiException {
    ApiResponse<GetWebhooksSubscriptionResponse> localVarResp =
        getWebhooksSubscriptionWithHttpInfo(companyId, subscriptionId);
    return localVarResp.getData();
  }

  /**
   * Get Webhooks Subscription Get a webhooks subscription.
   *
   * @param companyId The ID of the company. (required)
   * @param subscriptionId The ID of the subscription. (required)
   * @return ApiResponse&lt;GetWebhooksSubscriptionResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<GetWebhooksSubscriptionResponse> getWebhooksSubscriptionWithHttpInfo(
      Integer companyId, String subscriptionId) throws ApiException {
    okhttp3.Call localVarCall =
        getWebhooksSubscriptionValidateBeforeCall(companyId, subscriptionId, null);
    Type localVarReturnType = new TypeToken<GetWebhooksSubscriptionResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get Webhooks Subscription (asynchronously) Get a webhooks subscription.
   *
   * @param companyId The ID of the company. (required)
   * @param subscriptionId The ID of the subscription. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getWebhooksSubscriptionAsync(
      Integer companyId,
      String subscriptionId,
      final ApiCallback<GetWebhooksSubscriptionResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        getWebhooksSubscriptionValidateBeforeCall(companyId, subscriptionId, _callback);
    Type localVarReturnType = new TypeToken<GetWebhooksSubscriptionResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for listWebhooksSubscriptions
   *
   * @param companyId The ID of the company. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call listWebhooksSubscriptionsCall(Integer companyId, final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/subscriptions"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call listWebhooksSubscriptionsValidateBeforeCall(
      Integer companyId, final ApiCallback _callback) throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling listWebhooksSubscriptions(Async)");
    }

    return listWebhooksSubscriptionsCall(companyId, _callback);
  }

  /**
   * List Webhooks Subscriptions List active webhooks subscriptions.
   *
   * @param companyId The ID of the company. (required)
   * @return ListWebhooksSubscriptionsResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ListWebhooksSubscriptionsResponse listWebhooksSubscriptions(Integer companyId)
      throws ApiException {
    ApiResponse<ListWebhooksSubscriptionsResponse> localVarResp =
        listWebhooksSubscriptionsWithHttpInfo(companyId);
    return localVarResp.getData();
  }

  /**
   * List Webhooks Subscriptions List active webhooks subscriptions.
   *
   * @param companyId The ID of the company. (required)
   * @return ApiResponse&lt;ListWebhooksSubscriptionsResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<ListWebhooksSubscriptionsResponse> listWebhooksSubscriptionsWithHttpInfo(
      Integer companyId) throws ApiException {
    okhttp3.Call localVarCall = listWebhooksSubscriptionsValidateBeforeCall(companyId, null);
    Type localVarReturnType = new TypeToken<ListWebhooksSubscriptionsResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * List Webhooks Subscriptions (asynchronously) List active webhooks subscriptions.
   *
   * @param companyId The ID of the company. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call listWebhooksSubscriptionsAsync(
      Integer companyId, final ApiCallback<ListWebhooksSubscriptionsResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall = listWebhooksSubscriptionsValidateBeforeCall(companyId, _callback);
    Type localVarReturnType = new TypeToken<ListWebhooksSubscriptionsResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for modifyWebhooksSubscription
   *
   * @param companyId The ID of the company. (required)
   * @param subscriptionId The ID of the subscription. (required)
   * @param modifyWebhooksSubscriptionRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call modifyWebhooksSubscriptionCall(
      Integer companyId,
      String subscriptionId,
      ModifyWebhooksSubscriptionRequest modifyWebhooksSubscriptionRequest,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = modifyWebhooksSubscriptionRequest;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/subscriptions/{subscription_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "subscription_id" + "}",
                localVarApiClient.escapeString(subscriptionId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call modifyWebhooksSubscriptionValidateBeforeCall(
      Integer companyId,
      String subscriptionId,
      ModifyWebhooksSubscriptionRequest modifyWebhooksSubscriptionRequest,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling modifyWebhooksSubscription(Async)");
    }

    // verify the required parameter 'subscriptionId' is set
    if (subscriptionId == null) {
      throw new ApiException(
          "Missing the required parameter 'subscriptionId' when calling modifyWebhooksSubscription(Async)");
    }

    return modifyWebhooksSubscriptionCall(
        companyId, subscriptionId, modifyWebhooksSubscriptionRequest, _callback);
  }

  /**
   * Modify Webhooks Subscription Edit a webhooks subscription.
   *
   * @param companyId The ID of the company. (required)
   * @param subscriptionId The ID of the subscription. (required)
   * @param modifyWebhooksSubscriptionRequest (optional)
   * @return ModifyWebhooksSubscriptionResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ModifyWebhooksSubscriptionResponse modifyWebhooksSubscription(
      Integer companyId,
      String subscriptionId,
      ModifyWebhooksSubscriptionRequest modifyWebhooksSubscriptionRequest)
      throws ApiException {
    ApiResponse<ModifyWebhooksSubscriptionResponse> localVarResp =
        modifyWebhooksSubscriptionWithHttpInfo(
            companyId, subscriptionId, modifyWebhooksSubscriptionRequest);
    return localVarResp.getData();
  }

  /**
   * Modify Webhooks Subscription Edit a webhooks subscription.
   *
   * @param companyId The ID of the company. (required)
   * @param subscriptionId The ID of the subscription. (required)
   * @param modifyWebhooksSubscriptionRequest (optional)
   * @return ApiResponse&lt;ModifyWebhooksSubscriptionResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<ModifyWebhooksSubscriptionResponse> modifyWebhooksSubscriptionWithHttpInfo(
      Integer companyId,
      String subscriptionId,
      ModifyWebhooksSubscriptionRequest modifyWebhooksSubscriptionRequest)
      throws ApiException {
    okhttp3.Call localVarCall =
        modifyWebhooksSubscriptionValidateBeforeCall(
            companyId, subscriptionId, modifyWebhooksSubscriptionRequest, null);
    Type localVarReturnType = new TypeToken<ModifyWebhooksSubscriptionResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Modify Webhooks Subscription (asynchronously) Edit a webhooks subscription.
   *
   * @param companyId The ID of the company. (required)
   * @param subscriptionId The ID of the subscription. (required)
   * @param modifyWebhooksSubscriptionRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call modifyWebhooksSubscriptionAsync(
      Integer companyId,
      String subscriptionId,
      ModifyWebhooksSubscriptionRequest modifyWebhooksSubscriptionRequest,
      final ApiCallback<ModifyWebhooksSubscriptionResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        modifyWebhooksSubscriptionValidateBeforeCall(
            companyId, subscriptionId, modifyWebhooksSubscriptionRequest, _callback);
    Type localVarReturnType = new TypeToken<ModifyWebhooksSubscriptionResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
}
