/*
 * Fatture in Cloud API v2 - API Reference
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.
 *
 * The version of the OpenAPI document: 2.1.3
 * Contact: info@fattureincloud.it
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package it.fattureincloud.sdk.api;

import com.google.gson.reflect.TypeToken;
import it.fattureincloud.sdk.ApiCallback;
import it.fattureincloud.sdk.ApiClient;
import it.fattureincloud.sdk.ApiException;
import it.fattureincloud.sdk.ApiResponse;
import it.fattureincloud.sdk.Configuration;
import it.fattureincloud.sdk.Pair;
import it.fattureincloud.sdk.model.CreateIssuedDocumentRequest;
import it.fattureincloud.sdk.model.CreateIssuedDocumentResponse;
import it.fattureincloud.sdk.model.GetEmailDataResponse;
import it.fattureincloud.sdk.model.GetExistingIssuedDocumentTotalsRequest;
import it.fattureincloud.sdk.model.GetExistingIssuedDocumentTotalsResponse;
import it.fattureincloud.sdk.model.GetIssuedDocumentPreCreateInfoResponse;
import it.fattureincloud.sdk.model.GetIssuedDocumentResponse;
import it.fattureincloud.sdk.model.GetNewIssuedDocumentTotalsRequest;
import it.fattureincloud.sdk.model.GetNewIssuedDocumentTotalsResponse;
import it.fattureincloud.sdk.model.JoinIssuedDocumentsResponse;
import it.fattureincloud.sdk.model.ListIssuedDocumentsResponse;
import it.fattureincloud.sdk.model.ModifyIssuedDocumentRequest;
import it.fattureincloud.sdk.model.ModifyIssuedDocumentResponse;
import it.fattureincloud.sdk.model.ScheduleEmailRequest;
import it.fattureincloud.sdk.model.TransformIssuedDocumentResponse;
import it.fattureincloud.sdk.model.UploadIssuedDocumentAttachmentResponse;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IssuedDocumentsApi {
  private ApiClient localVarApiClient;
  private int localHostIndex;
  private String localCustomBaseUrl;

  public IssuedDocumentsApi() {
    this(Configuration.getDefaultApiClient());
  }

  public IssuedDocumentsApi(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return localVarApiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  public int getHostIndex() {
    return localHostIndex;
  }

  public void setHostIndex(int hostIndex) {
    this.localHostIndex = hostIndex;
  }

  public String getCustomBaseUrl() {
    return localCustomBaseUrl;
  }

  public void setCustomBaseUrl(String customBaseUrl) {
    this.localCustomBaseUrl = customBaseUrl;
  }

  /**
   * Build call for createIssuedDocument
   *
   * @param companyId The ID of the company. (required)
   * @param createIssuedDocumentRequest The Issued Document (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document created. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call createIssuedDocumentCall(
      Integer companyId,
      CreateIssuedDocumentRequest createIssuedDocumentRequest,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = createIssuedDocumentRequest;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/issued_documents"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call createIssuedDocumentValidateBeforeCall(
      Integer companyId,
      CreateIssuedDocumentRequest createIssuedDocumentRequest,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling createIssuedDocument(Async)");
    }

    return createIssuedDocumentCall(companyId, createIssuedDocumentRequest, _callback);
  }

  /**
   * Create Issued Document Creates a new document.
   *
   * @param companyId The ID of the company. (required)
   * @param createIssuedDocumentRequest The Issued Document (optional)
   * @return CreateIssuedDocumentResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document created. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public CreateIssuedDocumentResponse createIssuedDocument(
      Integer companyId, CreateIssuedDocumentRequest createIssuedDocumentRequest)
      throws ApiException {
    ApiResponse<CreateIssuedDocumentResponse> localVarResp =
        createIssuedDocumentWithHttpInfo(companyId, createIssuedDocumentRequest);
    return localVarResp.getData();
  }

  /**
   * Create Issued Document Creates a new document.
   *
   * @param companyId The ID of the company. (required)
   * @param createIssuedDocumentRequest The Issued Document (optional)
   * @return ApiResponse&lt;CreateIssuedDocumentResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document created. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<CreateIssuedDocumentResponse> createIssuedDocumentWithHttpInfo(
      Integer companyId, CreateIssuedDocumentRequest createIssuedDocumentRequest)
      throws ApiException {
    okhttp3.Call localVarCall =
        createIssuedDocumentValidateBeforeCall(companyId, createIssuedDocumentRequest, null);
    Type localVarReturnType = new TypeToken<CreateIssuedDocumentResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Create Issued Document (asynchronously) Creates a new document.
   *
   * @param companyId The ID of the company. (required)
   * @param createIssuedDocumentRequest The Issued Document (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document created. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call createIssuedDocumentAsync(
      Integer companyId,
      CreateIssuedDocumentRequest createIssuedDocumentRequest,
      final ApiCallback<CreateIssuedDocumentResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        createIssuedDocumentValidateBeforeCall(companyId, createIssuedDocumentRequest, _callback);
    Type localVarReturnType = new TypeToken<CreateIssuedDocumentResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for deleteIssuedDocument
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document removed </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call deleteIssuedDocumentCall(
      Integer companyId, Integer documentId, final ApiCallback _callback) throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/issued_documents/{document_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "document_id" + "}", localVarApiClient.escapeString(documentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call deleteIssuedDocumentValidateBeforeCall(
      Integer companyId, Integer documentId, final ApiCallback _callback) throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling deleteIssuedDocument(Async)");
    }

    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(
          "Missing the required parameter 'documentId' when calling deleteIssuedDocument(Async)");
    }

    return deleteIssuedDocumentCall(companyId, documentId, _callback);
  }

  /**
   * Delete Issued Document Deletes the specified document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document removed </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public void deleteIssuedDocument(Integer companyId, Integer documentId) throws ApiException {
    deleteIssuedDocumentWithHttpInfo(companyId, documentId);
  }

  /**
   * Delete Issued Document Deletes the specified document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document removed </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<Void> deleteIssuedDocumentWithHttpInfo(Integer companyId, Integer documentId)
      throws ApiException {
    okhttp3.Call localVarCall = deleteIssuedDocumentValidateBeforeCall(companyId, documentId, null);
    return localVarApiClient.execute(localVarCall);
  }

  /**
   * Delete Issued Document (asynchronously) Deletes the specified document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document removed </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call deleteIssuedDocumentAsync(
      Integer companyId, Integer documentId, final ApiCallback<Void> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        deleteIssuedDocumentValidateBeforeCall(companyId, documentId, _callback);
    localVarApiClient.executeAsync(localVarCall, _callback);
    return localVarCall;
  }
  /**
   * Build call for deleteIssuedDocumentAttachment
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> File removed. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call deleteIssuedDocumentAttachmentCall(
      Integer companyId, Integer documentId, final ApiCallback _callback) throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/issued_documents/{document_id}/attachment"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "document_id" + "}", localVarApiClient.escapeString(documentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call deleteIssuedDocumentAttachmentValidateBeforeCall(
      Integer companyId, Integer documentId, final ApiCallback _callback) throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling deleteIssuedDocumentAttachment(Async)");
    }

    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(
          "Missing the required parameter 'documentId' when calling deleteIssuedDocumentAttachment(Async)");
    }

    return deleteIssuedDocumentAttachmentCall(companyId, documentId, _callback);
  }

  /**
   * Delete Issued Document Attachment Removes the attachment of the specified document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> File removed. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public void deleteIssuedDocumentAttachment(Integer companyId, Integer documentId)
      throws ApiException {
    deleteIssuedDocumentAttachmentWithHttpInfo(companyId, documentId);
  }

  /**
   * Delete Issued Document Attachment Removes the attachment of the specified document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> File removed. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<Void> deleteIssuedDocumentAttachmentWithHttpInfo(
      Integer companyId, Integer documentId) throws ApiException {
    okhttp3.Call localVarCall =
        deleteIssuedDocumentAttachmentValidateBeforeCall(companyId, documentId, null);
    return localVarApiClient.execute(localVarCall);
  }

  /**
   * Delete Issued Document Attachment (asynchronously) Removes the attachment of the specified
   * document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> File removed. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call deleteIssuedDocumentAttachmentAsync(
      Integer companyId, Integer documentId, final ApiCallback<Void> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        deleteIssuedDocumentAttachmentValidateBeforeCall(companyId, documentId, _callback);
    localVarApiClient.executeAsync(localVarCall, _callback);
    return localVarCall;
  }
  /**
   * Build call for getEmailData
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> EmailData </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getEmailDataCall(
      Integer companyId, Integer documentId, final ApiCallback _callback) throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/issued_documents/{document_id}/email"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "document_id" + "}", localVarApiClient.escapeString(documentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getEmailDataValidateBeforeCall(
      Integer companyId, Integer documentId, final ApiCallback _callback) throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling getEmailData(Async)");
    }

    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(
          "Missing the required parameter 'documentId' when calling getEmailData(Async)");
    }

    return getEmailDataCall(companyId, documentId, _callback);
  }

  /**
   * Get Email Data Gets the pre-compiled email details.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @return GetEmailDataResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> EmailData </td><td>  -  </td></tr>
   * </table>
   */
  public GetEmailDataResponse getEmailData(Integer companyId, Integer documentId)
      throws ApiException {
    ApiResponse<GetEmailDataResponse> localVarResp =
        getEmailDataWithHttpInfo(companyId, documentId);
    return localVarResp.getData();
  }

  /**
   * Get Email Data Gets the pre-compiled email details.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @return ApiResponse&lt;GetEmailDataResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> EmailData </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<GetEmailDataResponse> getEmailDataWithHttpInfo(
      Integer companyId, Integer documentId) throws ApiException {
    okhttp3.Call localVarCall = getEmailDataValidateBeforeCall(companyId, documentId, null);
    Type localVarReturnType = new TypeToken<GetEmailDataResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get Email Data (asynchronously) Gets the pre-compiled email details.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> EmailData </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getEmailDataAsync(
      Integer companyId, Integer documentId, final ApiCallback<GetEmailDataResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall = getEmailDataValidateBeforeCall(companyId, documentId, _callback);
    Type localVarReturnType = new TypeToken<GetEmailDataResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for getExistingIssuedDocumentTotals
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param getExistingIssuedDocumentTotalsRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Totals. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getExistingIssuedDocumentTotalsCall(
      Integer companyId,
      Integer documentId,
      GetExistingIssuedDocumentTotalsRequest getExistingIssuedDocumentTotalsRequest,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = getExistingIssuedDocumentTotalsRequest;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/issued_documents/{document_id}/totals"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "document_id" + "}", localVarApiClient.escapeString(documentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getExistingIssuedDocumentTotalsValidateBeforeCall(
      Integer companyId,
      Integer documentId,
      GetExistingIssuedDocumentTotalsRequest getExistingIssuedDocumentTotalsRequest,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling getExistingIssuedDocumentTotals(Async)");
    }

    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(
          "Missing the required parameter 'documentId' when calling getExistingIssuedDocumentTotals(Async)");
    }

    return getExistingIssuedDocumentTotalsCall(
        companyId, documentId, getExistingIssuedDocumentTotalsRequest, _callback);
  }

  /**
   * Get Existing Issued Document Totals Returns the totals for a specified document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param getExistingIssuedDocumentTotalsRequest (optional)
   * @return GetExistingIssuedDocumentTotalsResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Totals. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public GetExistingIssuedDocumentTotalsResponse getExistingIssuedDocumentTotals(
      Integer companyId,
      Integer documentId,
      GetExistingIssuedDocumentTotalsRequest getExistingIssuedDocumentTotalsRequest)
      throws ApiException {
    ApiResponse<GetExistingIssuedDocumentTotalsResponse> localVarResp =
        getExistingIssuedDocumentTotalsWithHttpInfo(
            companyId, documentId, getExistingIssuedDocumentTotalsRequest);
    return localVarResp.getData();
  }

  /**
   * Get Existing Issued Document Totals Returns the totals for a specified document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param getExistingIssuedDocumentTotalsRequest (optional)
   * @return ApiResponse&lt;GetExistingIssuedDocumentTotalsResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Totals. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<GetExistingIssuedDocumentTotalsResponse>
      getExistingIssuedDocumentTotalsWithHttpInfo(
          Integer companyId,
          Integer documentId,
          GetExistingIssuedDocumentTotalsRequest getExistingIssuedDocumentTotalsRequest)
          throws ApiException {
    okhttp3.Call localVarCall =
        getExistingIssuedDocumentTotalsValidateBeforeCall(
            companyId, documentId, getExistingIssuedDocumentTotalsRequest, null);
    Type localVarReturnType = new TypeToken<GetExistingIssuedDocumentTotalsResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get Existing Issued Document Totals (asynchronously) Returns the totals for a specified
   * document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param getExistingIssuedDocumentTotalsRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Totals. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getExistingIssuedDocumentTotalsAsync(
      Integer companyId,
      Integer documentId,
      GetExistingIssuedDocumentTotalsRequest getExistingIssuedDocumentTotalsRequest,
      final ApiCallback<GetExistingIssuedDocumentTotalsResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        getExistingIssuedDocumentTotalsValidateBeforeCall(
            companyId, documentId, getExistingIssuedDocumentTotalsRequest, _callback);
    Type localVarReturnType = new TypeToken<GetExistingIssuedDocumentTotalsResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for getIssuedDocument
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document Details. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getIssuedDocumentCall(
      Integer companyId,
      Integer documentId,
      String fields,
      String fieldset,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/issued_documents/{document_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "document_id" + "}", localVarApiClient.escapeString(documentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (fields != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("fields", fields));
    }

    if (fieldset != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("fieldset", fieldset));
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getIssuedDocumentValidateBeforeCall(
      Integer companyId,
      Integer documentId,
      String fields,
      String fieldset,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling getIssuedDocument(Async)");
    }

    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(
          "Missing the required parameter 'documentId' when calling getIssuedDocument(Async)");
    }

    return getIssuedDocumentCall(companyId, documentId, fields, fieldset, _callback);
  }

  /**
   * Get Issued Document Gets the specified document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @return GetIssuedDocumentResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document Details. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public GetIssuedDocumentResponse getIssuedDocument(
      Integer companyId, Integer documentId, String fields, String fieldset) throws ApiException {
    ApiResponse<GetIssuedDocumentResponse> localVarResp =
        getIssuedDocumentWithHttpInfo(companyId, documentId, fields, fieldset);
    return localVarResp.getData();
  }

  /**
   * Get Issued Document Gets the specified document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @return ApiResponse&lt;GetIssuedDocumentResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document Details. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<GetIssuedDocumentResponse> getIssuedDocumentWithHttpInfo(
      Integer companyId, Integer documentId, String fields, String fieldset) throws ApiException {
    okhttp3.Call localVarCall =
        getIssuedDocumentValidateBeforeCall(companyId, documentId, fields, fieldset, null);
    Type localVarReturnType = new TypeToken<GetIssuedDocumentResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get Issued Document (asynchronously) Gets the specified document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document Details. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getIssuedDocumentAsync(
      Integer companyId,
      Integer documentId,
      String fields,
      String fieldset,
      final ApiCallback<GetIssuedDocumentResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        getIssuedDocumentValidateBeforeCall(companyId, documentId, fields, fieldset, _callback);
    Type localVarReturnType = new TypeToken<GetIssuedDocumentResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for getIssuedDocumentPreCreateInfo
   *
   * @param companyId The ID of the company. (required)
   * @param type The type of the issued document. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Pre-create info. </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getIssuedDocumentPreCreateInfoCall(
      Integer companyId, String type, final ApiCallback _callback) throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/issued_documents/info"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (type != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getIssuedDocumentPreCreateInfoValidateBeforeCall(
      Integer companyId, String type, final ApiCallback _callback) throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling getIssuedDocumentPreCreateInfo(Async)");
    }

    // verify the required parameter 'type' is set
    if (type == null) {
      throw new ApiException(
          "Missing the required parameter 'type' when calling getIssuedDocumentPreCreateInfo(Async)");
    }

    return getIssuedDocumentPreCreateInfoCall(companyId, type, _callback);
  }

  /**
   * Get Issued Document Pre-Create Info Retrieves the information useful while creating a new
   * document.
   *
   * @param companyId The ID of the company. (required)
   * @param type The type of the issued document. (required)
   * @return GetIssuedDocumentPreCreateInfoResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Pre-create info. </td><td>  -  </td></tr>
   * </table>
   */
  public GetIssuedDocumentPreCreateInfoResponse getIssuedDocumentPreCreateInfo(
      Integer companyId, String type) throws ApiException {
    ApiResponse<GetIssuedDocumentPreCreateInfoResponse> localVarResp =
        getIssuedDocumentPreCreateInfoWithHttpInfo(companyId, type);
    return localVarResp.getData();
  }

  /**
   * Get Issued Document Pre-Create Info Retrieves the information useful while creating a new
   * document.
   *
   * @param companyId The ID of the company. (required)
   * @param type The type of the issued document. (required)
   * @return ApiResponse&lt;GetIssuedDocumentPreCreateInfoResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Pre-create info. </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<GetIssuedDocumentPreCreateInfoResponse>
      getIssuedDocumentPreCreateInfoWithHttpInfo(Integer companyId, String type)
          throws ApiException {
    okhttp3.Call localVarCall =
        getIssuedDocumentPreCreateInfoValidateBeforeCall(companyId, type, null);
    Type localVarReturnType = new TypeToken<GetIssuedDocumentPreCreateInfoResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get Issued Document Pre-Create Info (asynchronously) Retrieves the information useful while
   * creating a new document.
   *
   * @param companyId The ID of the company. (required)
   * @param type The type of the issued document. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Pre-create info. </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getIssuedDocumentPreCreateInfoAsync(
      Integer companyId,
      String type,
      final ApiCallback<GetIssuedDocumentPreCreateInfoResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        getIssuedDocumentPreCreateInfoValidateBeforeCall(companyId, type, _callback);
    Type localVarReturnType = new TypeToken<GetIssuedDocumentPreCreateInfoResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for getNewIssuedDocumentTotals
   *
   * @param companyId The ID of the company. (required)
   * @param getNewIssuedDocumentTotalsRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Totals. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getNewIssuedDocumentTotalsCall(
      Integer companyId,
      GetNewIssuedDocumentTotalsRequest getNewIssuedDocumentTotalsRequest,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = getNewIssuedDocumentTotalsRequest;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/issued_documents/totals"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getNewIssuedDocumentTotalsValidateBeforeCall(
      Integer companyId,
      GetNewIssuedDocumentTotalsRequest getNewIssuedDocumentTotalsRequest,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling getNewIssuedDocumentTotals(Async)");
    }

    return getNewIssuedDocumentTotalsCall(companyId, getNewIssuedDocumentTotalsRequest, _callback);
  }

  /**
   * Get New Issued Document Totals Returns the totals for a new document.
   *
   * @param companyId The ID of the company. (required)
   * @param getNewIssuedDocumentTotalsRequest (optional)
   * @return GetNewIssuedDocumentTotalsResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Totals. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public GetNewIssuedDocumentTotalsResponse getNewIssuedDocumentTotals(
      Integer companyId, GetNewIssuedDocumentTotalsRequest getNewIssuedDocumentTotalsRequest)
      throws ApiException {
    ApiResponse<GetNewIssuedDocumentTotalsResponse> localVarResp =
        getNewIssuedDocumentTotalsWithHttpInfo(companyId, getNewIssuedDocumentTotalsRequest);
    return localVarResp.getData();
  }

  /**
   * Get New Issued Document Totals Returns the totals for a new document.
   *
   * @param companyId The ID of the company. (required)
   * @param getNewIssuedDocumentTotalsRequest (optional)
   * @return ApiResponse&lt;GetNewIssuedDocumentTotalsResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Totals. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<GetNewIssuedDocumentTotalsResponse> getNewIssuedDocumentTotalsWithHttpInfo(
      Integer companyId, GetNewIssuedDocumentTotalsRequest getNewIssuedDocumentTotalsRequest)
      throws ApiException {
    okhttp3.Call localVarCall =
        getNewIssuedDocumentTotalsValidateBeforeCall(
            companyId, getNewIssuedDocumentTotalsRequest, null);
    Type localVarReturnType = new TypeToken<GetNewIssuedDocumentTotalsResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get New Issued Document Totals (asynchronously) Returns the totals for a new document.
   *
   * @param companyId The ID of the company. (required)
   * @param getNewIssuedDocumentTotalsRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Totals. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getNewIssuedDocumentTotalsAsync(
      Integer companyId,
      GetNewIssuedDocumentTotalsRequest getNewIssuedDocumentTotalsRequest,
      final ApiCallback<GetNewIssuedDocumentTotalsResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        getNewIssuedDocumentTotalsValidateBeforeCall(
            companyId, getNewIssuedDocumentTotalsRequest, _callback);
    Type localVarReturnType = new TypeToken<GetNewIssuedDocumentTotalsResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for joinIssuedDocuments
   *
   * @param companyId The ID of the company. (required)
   * @param ids Ids of the documents. (required)
   * @param group Group items. (optional)
   * @param type Type of the documents to be joined (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call joinIssuedDocumentsCall(
      Integer companyId, String ids, Integer group, String type, final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/issued_documents/join"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (ids != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("ids", ids));
    }

    if (group != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("group", group));
    }

    if (type != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call joinIssuedDocumentsValidateBeforeCall(
      Integer companyId, String ids, Integer group, String type, final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling joinIssuedDocuments(Async)");
    }

    // verify the required parameter 'ids' is set
    if (ids == null) {
      throw new ApiException(
          "Missing the required parameter 'ids' when calling joinIssuedDocuments(Async)");
    }

    return joinIssuedDocumentsCall(companyId, ids, group, type, _callback);
  }

  /**
   * Join Issued Documents Joins issued documents.
   *
   * @param companyId The ID of the company. (required)
   * @param ids Ids of the documents. (required)
   * @param group Group items. (optional)
   * @param type Type of the documents to be joined (optional)
   * @return JoinIssuedDocumentsResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public JoinIssuedDocumentsResponse joinIssuedDocuments(
      Integer companyId, String ids, Integer group, String type) throws ApiException {
    ApiResponse<JoinIssuedDocumentsResponse> localVarResp =
        joinIssuedDocumentsWithHttpInfo(companyId, ids, group, type);
    return localVarResp.getData();
  }

  /**
   * Join Issued Documents Joins issued documents.
   *
   * @param companyId The ID of the company. (required)
   * @param ids Ids of the documents. (required)
   * @param group Group items. (optional)
   * @param type Type of the documents to be joined (optional)
   * @return ApiResponse&lt;JoinIssuedDocumentsResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<JoinIssuedDocumentsResponse> joinIssuedDocumentsWithHttpInfo(
      Integer companyId, String ids, Integer group, String type) throws ApiException {
    okhttp3.Call localVarCall =
        joinIssuedDocumentsValidateBeforeCall(companyId, ids, group, type, null);
    Type localVarReturnType = new TypeToken<JoinIssuedDocumentsResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Join Issued Documents (asynchronously) Joins issued documents.
   *
   * @param companyId The ID of the company. (required)
   * @param ids Ids of the documents. (required)
   * @param group Group items. (optional)
   * @param type Type of the documents to be joined (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call joinIssuedDocumentsAsync(
      Integer companyId,
      String ids,
      Integer group,
      String type,
      final ApiCallback<JoinIssuedDocumentsResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        joinIssuedDocumentsValidateBeforeCall(companyId, ids, group, type, _callback);
    Type localVarReturnType = new TypeToken<JoinIssuedDocumentsResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for listIssuedDocuments
   *
   * @param companyId The ID of the company. (required)
   * @param type The type of the issued document. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param sort List of comma-separated fields for result sorting (minus for desc sorting).
   *     (optional)
   * @param page The page to retrieve. (optional, default to 1)
   * @param perPage The size of the page. (optional, default to 5)
   * @param q Query for filtering the results. (optional)
   * @param inclusive (Only for type &#x3D; delivery_notes) Include invoices delivery notes.
   *     (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Results list. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call listIssuedDocumentsCall(
      Integer companyId,
      String type,
      String fields,
      String fieldset,
      String sort,
      Integer page,
      Integer perPage,
      String q,
      Integer inclusive,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/issued_documents"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (type != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
    }

    if (fields != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("fields", fields));
    }

    if (fieldset != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("fieldset", fieldset));
    }

    if (sort != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
    }

    if (page != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
    }

    if (perPage != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
    }

    if (q != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("q", q));
    }

    if (inclusive != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("inclusive", inclusive));
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call listIssuedDocumentsValidateBeforeCall(
      Integer companyId,
      String type,
      String fields,
      String fieldset,
      String sort,
      Integer page,
      Integer perPage,
      String q,
      Integer inclusive,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling listIssuedDocuments(Async)");
    }

    // verify the required parameter 'type' is set
    if (type == null) {
      throw new ApiException(
          "Missing the required parameter 'type' when calling listIssuedDocuments(Async)");
    }

    return listIssuedDocumentsCall(
        companyId, type, fields, fieldset, sort, page, perPage, q, inclusive, _callback);
  }

  /**
   * List Issued Documents Lists the issued documents.
   *
   * @param companyId The ID of the company. (required)
   * @param type The type of the issued document. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param sort List of comma-separated fields for result sorting (minus for desc sorting).
   *     (optional)
   * @param page The page to retrieve. (optional, default to 1)
   * @param perPage The size of the page. (optional, default to 5)
   * @param q Query for filtering the results. (optional)
   * @param inclusive (Only for type &#x3D; delivery_notes) Include invoices delivery notes.
   *     (optional)
   * @return ListIssuedDocumentsResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Results list. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ListIssuedDocumentsResponse listIssuedDocuments(
      Integer companyId,
      String type,
      String fields,
      String fieldset,
      String sort,
      Integer page,
      Integer perPage,
      String q,
      Integer inclusive)
      throws ApiException {
    ApiResponse<ListIssuedDocumentsResponse> localVarResp =
        listIssuedDocumentsWithHttpInfo(
            companyId, type, fields, fieldset, sort, page, perPage, q, inclusive);
    return localVarResp.getData();
  }

  /**
   * List Issued Documents Lists the issued documents.
   *
   * @param companyId The ID of the company. (required)
   * @param type The type of the issued document. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param sort List of comma-separated fields for result sorting (minus for desc sorting).
   *     (optional)
   * @param page The page to retrieve. (optional, default to 1)
   * @param perPage The size of the page. (optional, default to 5)
   * @param q Query for filtering the results. (optional)
   * @param inclusive (Only for type &#x3D; delivery_notes) Include invoices delivery notes.
   *     (optional)
   * @return ApiResponse&lt;ListIssuedDocumentsResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Results list. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<ListIssuedDocumentsResponse> listIssuedDocumentsWithHttpInfo(
      Integer companyId,
      String type,
      String fields,
      String fieldset,
      String sort,
      Integer page,
      Integer perPage,
      String q,
      Integer inclusive)
      throws ApiException {
    okhttp3.Call localVarCall =
        listIssuedDocumentsValidateBeforeCall(
            companyId, type, fields, fieldset, sort, page, perPage, q, inclusive, null);
    Type localVarReturnType = new TypeToken<ListIssuedDocumentsResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * List Issued Documents (asynchronously) Lists the issued documents.
   *
   * @param companyId The ID of the company. (required)
   * @param type The type of the issued document. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param sort List of comma-separated fields for result sorting (minus for desc sorting).
   *     (optional)
   * @param page The page to retrieve. (optional, default to 1)
   * @param perPage The size of the page. (optional, default to 5)
   * @param q Query for filtering the results. (optional)
   * @param inclusive (Only for type &#x3D; delivery_notes) Include invoices delivery notes.
   *     (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Results list. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call listIssuedDocumentsAsync(
      Integer companyId,
      String type,
      String fields,
      String fieldset,
      String sort,
      Integer page,
      Integer perPage,
      String q,
      Integer inclusive,
      final ApiCallback<ListIssuedDocumentsResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        listIssuedDocumentsValidateBeforeCall(
            companyId, type, fields, fieldset, sort, page, perPage, q, inclusive, _callback);
    Type localVarReturnType = new TypeToken<ListIssuedDocumentsResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for modifyIssuedDocument
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param modifyIssuedDocumentRequest The modified document (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document edited </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call modifyIssuedDocumentCall(
      Integer companyId,
      Integer documentId,
      ModifyIssuedDocumentRequest modifyIssuedDocumentRequest,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = modifyIssuedDocumentRequest;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/issued_documents/{document_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "document_id" + "}", localVarApiClient.escapeString(documentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call modifyIssuedDocumentValidateBeforeCall(
      Integer companyId,
      Integer documentId,
      ModifyIssuedDocumentRequest modifyIssuedDocumentRequest,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling modifyIssuedDocument(Async)");
    }

    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(
          "Missing the required parameter 'documentId' when calling modifyIssuedDocument(Async)");
    }

    return modifyIssuedDocumentCall(companyId, documentId, modifyIssuedDocumentRequest, _callback);
  }

  /**
   * Modify Issued Document Modifies the specified document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param modifyIssuedDocumentRequest The modified document (optional)
   * @return ModifyIssuedDocumentResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document edited </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ModifyIssuedDocumentResponse modifyIssuedDocument(
      Integer companyId,
      Integer documentId,
      ModifyIssuedDocumentRequest modifyIssuedDocumentRequest)
      throws ApiException {
    ApiResponse<ModifyIssuedDocumentResponse> localVarResp =
        modifyIssuedDocumentWithHttpInfo(companyId, documentId, modifyIssuedDocumentRequest);
    return localVarResp.getData();
  }

  /**
   * Modify Issued Document Modifies the specified document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param modifyIssuedDocumentRequest The modified document (optional)
   * @return ApiResponse&lt;ModifyIssuedDocumentResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document edited </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<ModifyIssuedDocumentResponse> modifyIssuedDocumentWithHttpInfo(
      Integer companyId,
      Integer documentId,
      ModifyIssuedDocumentRequest modifyIssuedDocumentRequest)
      throws ApiException {
    okhttp3.Call localVarCall =
        modifyIssuedDocumentValidateBeforeCall(
            companyId, documentId, modifyIssuedDocumentRequest, null);
    Type localVarReturnType = new TypeToken<ModifyIssuedDocumentResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Modify Issued Document (asynchronously) Modifies the specified document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param modifyIssuedDocumentRequest The modified document (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document edited </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call modifyIssuedDocumentAsync(
      Integer companyId,
      Integer documentId,
      ModifyIssuedDocumentRequest modifyIssuedDocumentRequest,
      final ApiCallback<ModifyIssuedDocumentResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        modifyIssuedDocumentValidateBeforeCall(
            companyId, documentId, modifyIssuedDocumentRequest, _callback);
    Type localVarReturnType = new TypeToken<ModifyIssuedDocumentResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for scheduleEmail
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param scheduleEmailRequest Email Schedule (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call scheduleEmailCall(
      Integer companyId,
      Integer documentId,
      ScheduleEmailRequest scheduleEmailRequest,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = scheduleEmailRequest;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/issued_documents/{document_id}/email"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "document_id" + "}", localVarApiClient.escapeString(documentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call scheduleEmailValidateBeforeCall(
      Integer companyId,
      Integer documentId,
      ScheduleEmailRequest scheduleEmailRequest,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling scheduleEmail(Async)");
    }

    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(
          "Missing the required parameter 'documentId' when calling scheduleEmail(Async)");
    }

    return scheduleEmailCall(companyId, documentId, scheduleEmailRequest, _callback);
  }

  /**
   * Schedule Email Schedules the sending of a document by email.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param scheduleEmailRequest Email Schedule (optional)
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public void scheduleEmail(
      Integer companyId, Integer documentId, ScheduleEmailRequest scheduleEmailRequest)
      throws ApiException {
    scheduleEmailWithHttpInfo(companyId, documentId, scheduleEmailRequest);
  }

  /**
   * Schedule Email Schedules the sending of a document by email.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param scheduleEmailRequest Email Schedule (optional)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<Void> scheduleEmailWithHttpInfo(
      Integer companyId, Integer documentId, ScheduleEmailRequest scheduleEmailRequest)
      throws ApiException {
    okhttp3.Call localVarCall =
        scheduleEmailValidateBeforeCall(companyId, documentId, scheduleEmailRequest, null);
    return localVarApiClient.execute(localVarCall);
  }

  /**
   * Schedule Email (asynchronously) Schedules the sending of a document by email.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param scheduleEmailRequest Email Schedule (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call scheduleEmailAsync(
      Integer companyId,
      Integer documentId,
      ScheduleEmailRequest scheduleEmailRequest,
      final ApiCallback<Void> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        scheduleEmailValidateBeforeCall(companyId, documentId, scheduleEmailRequest, _callback);
    localVarApiClient.executeAsync(localVarCall, _callback);
    return localVarCall;
  }
  /**
   * Build call for transformIssuedDocument
   *
   * @param companyId The ID of the company. (required)
   * @param originalDocumentId Original document id. (required)
   * @param newType New document type. (required)
   * @param type Current document type. (optional)
   * @param eInvoice New document e_invoice. (optional)
   * @param transformKeepCopy Keep the old document. (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call transformIssuedDocumentCall(
      Integer companyId,
      Integer originalDocumentId,
      String newType,
      String type,
      Integer eInvoice,
      Integer transformKeepCopy,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/issued_documents/transform"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (originalDocumentId != null) {
      localVarQueryParams.addAll(
          localVarApiClient.parameterToPair("original_document_id", originalDocumentId));
    }

    if (newType != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("new_type", newType));
    }

    if (type != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
    }

    if (eInvoice != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("e_invoice", eInvoice));
    }

    if (transformKeepCopy != null) {
      localVarQueryParams.addAll(
          localVarApiClient.parameterToPair("transform_keep_copy", transformKeepCopy));
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call transformIssuedDocumentValidateBeforeCall(
      Integer companyId,
      Integer originalDocumentId,
      String newType,
      String type,
      Integer eInvoice,
      Integer transformKeepCopy,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling transformIssuedDocument(Async)");
    }

    // verify the required parameter 'originalDocumentId' is set
    if (originalDocumentId == null) {
      throw new ApiException(
          "Missing the required parameter 'originalDocumentId' when calling transformIssuedDocument(Async)");
    }

    // verify the required parameter 'newType' is set
    if (newType == null) {
      throw new ApiException(
          "Missing the required parameter 'newType' when calling transformIssuedDocument(Async)");
    }

    return transformIssuedDocumentCall(
        companyId, originalDocumentId, newType, type, eInvoice, transformKeepCopy, _callback);
  }

  /**
   * Transform Issued Document Transforms the document.
   *
   * @param companyId The ID of the company. (required)
   * @param originalDocumentId Original document id. (required)
   * @param newType New document type. (required)
   * @param type Current document type. (optional)
   * @param eInvoice New document e_invoice. (optional)
   * @param transformKeepCopy Keep the old document. (optional)
   * @return TransformIssuedDocumentResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public TransformIssuedDocumentResponse transformIssuedDocument(
      Integer companyId,
      Integer originalDocumentId,
      String newType,
      String type,
      Integer eInvoice,
      Integer transformKeepCopy)
      throws ApiException {
    ApiResponse<TransformIssuedDocumentResponse> localVarResp =
        transformIssuedDocumentWithHttpInfo(
            companyId, originalDocumentId, newType, type, eInvoice, transformKeepCopy);
    return localVarResp.getData();
  }

  /**
   * Transform Issued Document Transforms the document.
   *
   * @param companyId The ID of the company. (required)
   * @param originalDocumentId Original document id. (required)
   * @param newType New document type. (required)
   * @param type Current document type. (optional)
   * @param eInvoice New document e_invoice. (optional)
   * @param transformKeepCopy Keep the old document. (optional)
   * @return ApiResponse&lt;TransformIssuedDocumentResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<TransformIssuedDocumentResponse> transformIssuedDocumentWithHttpInfo(
      Integer companyId,
      Integer originalDocumentId,
      String newType,
      String type,
      Integer eInvoice,
      Integer transformKeepCopy)
      throws ApiException {
    okhttp3.Call localVarCall =
        transformIssuedDocumentValidateBeforeCall(
            companyId, originalDocumentId, newType, type, eInvoice, transformKeepCopy, null);
    Type localVarReturnType = new TypeToken<TransformIssuedDocumentResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Transform Issued Document (asynchronously) Transforms the document.
   *
   * @param companyId The ID of the company. (required)
   * @param originalDocumentId Original document id. (required)
   * @param newType New document type. (required)
   * @param type Current document type. (optional)
   * @param eInvoice New document e_invoice. (optional)
   * @param transformKeepCopy Keep the old document. (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call transformIssuedDocumentAsync(
      Integer companyId,
      Integer originalDocumentId,
      String newType,
      String type,
      Integer eInvoice,
      Integer transformKeepCopy,
      final ApiCallback<TransformIssuedDocumentResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        transformIssuedDocumentValidateBeforeCall(
            companyId, originalDocumentId, newType, type, eInvoice, transformKeepCopy, _callback);
    Type localVarReturnType = new TypeToken<TransformIssuedDocumentResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for uploadIssuedDocumentAttachment
   *
   * @param companyId The ID of the company. (required)
   * @param filename Attachment file name (optional)
   * @param attachment Attachment file [.png, .jpg, .gif, .pdf, .zip, .xls, .xlsx, .doc, .docx]
   *     (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Attachment Token. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call uploadIssuedDocumentAttachmentCall(
      Integer companyId, String filename, File attachment, final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/issued_documents/attachment"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (filename != null) {
      localVarFormParams.put("filename", filename);
    }

    if (attachment != null) {
      localVarFormParams.put("attachment", attachment);
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"multipart/form-data"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call uploadIssuedDocumentAttachmentValidateBeforeCall(
      Integer companyId, String filename, File attachment, final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling uploadIssuedDocumentAttachment(Async)");
    }

    return uploadIssuedDocumentAttachmentCall(companyId, filename, attachment, _callback);
  }

  /**
   * Upload Issued Document Attachment Uploads an attachment destined to an issued document. The
   * actual association between the document and the attachment must be implemented separately,
   * using the returned token.
   *
   * @param companyId The ID of the company. (required)
   * @param filename Attachment file name (optional)
   * @param attachment Attachment file [.png, .jpg, .gif, .pdf, .zip, .xls, .xlsx, .doc, .docx]
   *     (optional)
   * @return UploadIssuedDocumentAttachmentResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Attachment Token. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public UploadIssuedDocumentAttachmentResponse uploadIssuedDocumentAttachment(
      Integer companyId, String filename, File attachment) throws ApiException {
    ApiResponse<UploadIssuedDocumentAttachmentResponse> localVarResp =
        uploadIssuedDocumentAttachmentWithHttpInfo(companyId, filename, attachment);
    return localVarResp.getData();
  }

  /**
   * Upload Issued Document Attachment Uploads an attachment destined to an issued document. The
   * actual association between the document and the attachment must be implemented separately,
   * using the returned token.
   *
   * @param companyId The ID of the company. (required)
   * @param filename Attachment file name (optional)
   * @param attachment Attachment file [.png, .jpg, .gif, .pdf, .zip, .xls, .xlsx, .doc, .docx]
   *     (optional)
   * @return ApiResponse&lt;UploadIssuedDocumentAttachmentResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Attachment Token. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<UploadIssuedDocumentAttachmentResponse>
      uploadIssuedDocumentAttachmentWithHttpInfo(
          Integer companyId, String filename, File attachment) throws ApiException {
    okhttp3.Call localVarCall =
        uploadIssuedDocumentAttachmentValidateBeforeCall(companyId, filename, attachment, null);
    Type localVarReturnType = new TypeToken<UploadIssuedDocumentAttachmentResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Upload Issued Document Attachment (asynchronously) Uploads an attachment destined to an issued
   * document. The actual association between the document and the attachment must be implemented
   * separately, using the returned token.
   *
   * @param companyId The ID of the company. (required)
   * @param filename Attachment file name (optional)
   * @param attachment Attachment file [.png, .jpg, .gif, .pdf, .zip, .xls, .xlsx, .doc, .docx]
   *     (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Attachment Token. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call uploadIssuedDocumentAttachmentAsync(
      Integer companyId,
      String filename,
      File attachment,
      final ApiCallback<UploadIssuedDocumentAttachmentResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        uploadIssuedDocumentAttachmentValidateBeforeCall(
            companyId, filename, attachment, _callback);
    Type localVarReturnType = new TypeToken<UploadIssuedDocumentAttachmentResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
}
