/*
 * Decompiled with CFR 0.152.
 */
package it.bz.opendatahub.alpinebits.examples.inventory.middleware;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import it.bz.opendatahub.alpinebits.xml.schema.ota.ErrorType;
import it.bz.opendatahub.alpinebits.xml.schema.ota.ErrorsType;
import it.bz.opendatahub.alpinebits.xml.schema.ota.MessageAcknowledgementType;
import it.bz.opendatahub.alpinebits.xml.schema.ota.OTAHotelDescriptiveContentNotifRQ;
import it.bz.opendatahub.alpinebits.xml.schema.ota.OTAHotelDescriptiveContentNotifRS;
import it.bz.opendatahub.alpinebits.xml.schema.ota.SuccessType;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryPushService {
    private static final Logger LOG = LoggerFactory.getLogger(InventoryPushService.class);
    private final ObjectMapper om = new ObjectMapper();

    public InventoryPushService() {
        this.om.enable(SerializationFeature.INDENT_OUTPUT);
        this.om.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public OTAHotelDescriptiveContentNotifRS logInventoryBasic(OTAHotelDescriptiveContentNotifRQ otaHotelDescriptiveContentNotifRQ) {
        try {
            String json = this.om.writeValueAsString((Object)otaHotelDescriptiveContentNotifRQ);
            LOG.info("----GOT Inventory/Basic REQUEST-----");
            LOG.info("{}", (Object)json);
            LOG.info("----END OF Inventory/Basic REQUEST-----");
            return this.buildSuccess();
        }
        catch (Exception e) {
            return this.buildError(e);
        }
    }

    public OTAHotelDescriptiveContentNotifRS logInventoryHotelInfo(OTAHotelDescriptiveContentNotifRQ otaHotelDescriptiveContentNotifRQ) {
        try {
            String json = this.om.writeValueAsString((Object)otaHotelDescriptiveContentNotifRQ);
            LOG.info("----GOT Inventory/HotelInfo REQUEST-----");
            LOG.info("{}", (Object)json);
            LOG.info("----END OF Inventory/HotelInfo REQUEST-----");
            return this.buildSuccess();
        }
        catch (Exception e) {
            return this.buildError(e);
        }
    }

    private OTAHotelDescriptiveContentNotifRS buildSuccess() {
        MessageAcknowledgementType mat = new MessageAcknowledgementType();
        mat.setSuccess(new SuccessType());
        mat.setVersion(BigDecimal.ONE);
        return new OTAHotelDescriptiveContentNotifRS(mat);
    }

    private OTAHotelDescriptiveContentNotifRS buildError(Exception e) {
        ErrorType errorType = new ErrorType();
        errorType.setValue(e.getMessage());
        errorType.setCode("450");
        errorType.setType("13");
        ErrorsType errorsType = new ErrorsType();
        errorsType.getErrors().add(errorType);
        MessageAcknowledgementType mat = new MessageAcknowledgementType();
        mat.setErrors(errorsType);
        mat.setVersion(BigDecimal.ONE);
        return new OTAHotelDescriptiveContentNotifRS(mat);
    }
}

