/*
 * Decompiled with CFR 0.152.
 */
package it.bz.opendatahub.alpinebits.examples.inventory.middleware;

import it.bz.opendatahub.alpinebits.common.context.RequestContextKey;
import it.bz.opendatahub.alpinebits.common.exception.AlpineBitsException;
import it.bz.opendatahub.alpinebits.examples.inventory.middleware.InventoryPullService;
import it.bz.opendatahub.alpinebits.middleware.Context;
import it.bz.opendatahub.alpinebits.middleware.Key;
import it.bz.opendatahub.alpinebits.middleware.Middleware;
import it.bz.opendatahub.alpinebits.middleware.MiddlewareChain;
import it.bz.opendatahub.alpinebits.xml.schema.ota.OTAHotelDescriptiveInfoRQ;
import it.bz.opendatahub.alpinebits.xml.schema.ota.OTAHotelDescriptiveInfoRS;

public class InventoryPullMiddleware
implements Middleware {
    public static final Key<OTAHotelDescriptiveInfoRQ> OTA_INVENTORY_PULL_REQUEST = Key.key((String)"inventory pull request", OTAHotelDescriptiveInfoRQ.class);
    public static final Key<OTAHotelDescriptiveInfoRS> OTA_INVENTORY_PULL_RESPONSE = Key.key((String)"inventory pull response", OTAHotelDescriptiveInfoRS.class);

    public void handleContext(Context ctx, MiddlewareChain chain) {
        OTAHotelDescriptiveInfoRS response = this.invokeService(ctx);
        ctx.put(OTA_INVENTORY_PULL_RESPONSE, (Object)response);
    }

    private OTAHotelDescriptiveInfoRS invokeService(Context ctx) {
        String action = (String)ctx.getOrThrow(RequestContextKey.REQUEST_ACTION);
        OTAHotelDescriptiveInfoRQ otaHotelDescriptiveInfoRQ = (OTAHotelDescriptiveInfoRQ)ctx.getOrThrow(OTA_INVENTORY_PULL_REQUEST);
        InventoryPullService service = new InventoryPullService();
        if ("OTA_HotelDescriptiveInfo:Inventory".equals(action)) {
            return service.readInventoryBasic(otaHotelDescriptiveInfoRQ);
        }
        if ("OTA_HotelDescriptiveInfo:Info".equals(action)) {
            return service.readInventoryHotelInfo(otaHotelDescriptiveInfoRQ);
        }
        throw new AlpineBitsException("No implementation for action found", 500);
    }
}

