/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres.junit5;

import io.zonky.test.db.postgres.embedded.ConnectionInfo;
import io.zonky.test.db.postgres.embedded.DatabasePreparer;
import io.zonky.test.db.postgres.embedded.EmbeddedPostgres;
import io.zonky.test.db.postgres.embedded.PreparedDbProvider;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class PreparedDbExtension
implements BeforeAllCallback,
AfterAllCallback {
    private final DatabasePreparer preparer;
    private volatile DataSource dataSource;
    private volatile PreparedDbProvider provider;
    private volatile ConnectionInfo connectionInfo;
    private final List<Consumer<EmbeddedPostgres.Builder>> builderCustomizers = new CopyOnWriteArrayList<Consumer<EmbeddedPostgres.Builder>>();

    PreparedDbExtension(DatabasePreparer preparer) {
        if (preparer == null) {
            throw new IllegalStateException("null preparer");
        }
        this.preparer = preparer;
    }

    public PreparedDbExtension customize(Consumer<EmbeddedPostgres.Builder> customizer) {
        if (this.dataSource != null) {
            throw new AssertionError((Object)"already started");
        }
        this.builderCustomizers.add(customizer);
        return this;
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.provider = PreparedDbProvider.forPreparer(this.preparer, this.builderCustomizers);
        this.connectionInfo = this.provider.createNewDatabase();
        this.dataSource = this.provider.createDataSourceFromConnectionInfo(this.connectionInfo);
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.dataSource = null;
        this.connectionInfo = null;
        this.provider = null;
    }

    public DataSource getTestDatabase() {
        if (this.dataSource == null) {
            throw new AssertionError((Object)"not initialized");
        }
        return this.dataSource;
    }

    public ConnectionInfo getConnectionInfo() {
        if (this.connectionInfo == null) {
            throw new AssertionError((Object)"not initialized");
        }
        return this.connectionInfo;
    }

    public PreparedDbProvider getDbProvider() {
        if (this.provider == null) {
            throw new AssertionError((Object)"not initialized");
        }
        return this.provider;
    }
}

