/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.event;

import io.zonky.test.db.event.TestExecutionFinishedEvent;
import io.zonky.test.db.event.TestExecutionStartedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ClassUtils;

public class EventPublishingTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Logger logger = LoggerFactory.getLogger(EventPublishingTestExecutionListener.class);
    private static final boolean TEST_EXECUTION_METHODS_SUPPORTED = ClassUtils.getMethodIfAvailable(TestExecutionListener.class, (String)"beforeTestExecution", null) != null;

    public void beforeTestMethod(TestContext testContext) {
        if (!TEST_EXECUTION_METHODS_SUPPORTED) {
            this.beforeTestExecution(testContext);
        }
    }

    public void afterTestMethod(TestContext testContext) {
        if (!TEST_EXECUTION_METHODS_SUPPORTED) {
            this.afterTestExecution(testContext);
        }
    }

    public void beforeTestExecution(TestContext testContext) {
        ApplicationContext applicationContext = testContext.getApplicationContext();
        applicationContext.publishEvent((ApplicationEvent)new TestExecutionStartedEvent(applicationContext, testContext.getTestMethod()));
        logger.trace("Test execution started - '{}#{}'", (Object)testContext.getTestClass().getSimpleName(), (Object)testContext.getTestMethod().getName());
    }

    public void afterTestExecution(TestContext testContext) {
        ApplicationContext applicationContext = testContext.getApplicationContext();
        applicationContext.publishEvent((ApplicationEvent)new TestExecutionFinishedEvent(applicationContext, testContext.getTestMethod()));
        logger.trace("Test execution finished - '{}#{}'", (Object)testContext.getTestClass().getSimpleName(), (Object)testContext.getTestMethod().getName());
    }
}

