/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.mssql;

import com.cedarsoftware.util.DeepEquals;
import com.microsoft.sqlserver.jdbc.ISQLServerDataSource;
import com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import io.zonky.test.db.preparer.DatabasePreparer;
import io.zonky.test.db.provider.DatabaseRequest;
import io.zonky.test.db.provider.DatabaseTemplate;
import io.zonky.test.db.provider.EmbeddedDatabase;
import io.zonky.test.db.provider.ProviderException;
import io.zonky.test.db.provider.TemplatableDatabaseProvider;
import io.zonky.test.db.provider.mssql.MSSQLServerContainerCustomizer;
import io.zonky.test.db.provider.mssql.MsSQLEmbeddedDatabase;
import io.zonky.test.db.provider.support.BlockingDatabaseWrapper;
import io.zonky.test.db.provider.support.SimpleDatabaseTemplate;
import io.zonky.test.db.shaded.com.google.common.base.Throwables;
import io.zonky.test.db.shaded.com.google.common.cache.CacheBuilder;
import io.zonky.test.db.shaded.com.google.common.cache.CacheLoader;
import io.zonky.test.db.shaded.com.google.common.cache.LoadingCache;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableMap;
import io.zonky.test.db.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import io.zonky.test.db.util.PropertyUtils;
import io.zonky.test.db.util.RandomStringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.testcontainers.containers.MSSQLServerContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.utility.DockerImageName;

public class DockerMSSQLDatabaseProvider
implements TemplatableDatabaseProvider {
    private static final Logger logger = LoggerFactory.getLogger(DockerMSSQLDatabaseProvider.class);
    private static final LoadingCache<DatabaseConfig, DatabaseInstance> databases = CacheBuilder.newBuilder().build(new CacheLoader<DatabaseConfig, DatabaseInstance>(){

        @Override
        public DatabaseInstance load(DatabaseConfig config) {
            return new DatabaseInstance(config);
        }
    });
    private final DatabaseConfig databaseConfig;
    private final ClientConfig clientConfig;

    public DockerMSSQLDatabaseProvider(Environment environment, ObjectProvider<List<MSSQLServerContainerCustomizer>> containerCustomizers) {
        String dockerImage = environment.getProperty("zonky.test.database.mssql.docker.image", "mcr.microsoft.com/mssql/server:2017-latest");
        Map<String, String> connectProperties = PropertyUtils.extractAll(environment, "zonky.test.database.mssql.client.properties");
        List customizers = Optional.ofNullable(containerCustomizers.getIfAvailable()).orElse(Collections.emptyList());
        this.databaseConfig = new DatabaseConfig(dockerImage, customizers);
        this.clientConfig = new ClientConfig(connectProperties);
    }

    @Override
    public DatabaseTemplate createTemplate(DatabaseRequest request) throws ProviderException {
        try {
            DatabaseInstance instance = databases.get(this.databaseConfig);
            return instance.createTemplate(this.clientConfig, request);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf(e.getCause(), ProviderException.class);
            throw new ProviderException("Unexpected error when preparing a database cluster", e.getCause());
        }
        catch (SQLException e) {
            throw new ProviderException("Unexpected error when creating a database template", e);
        }
    }

    @Override
    public EmbeddedDatabase createDatabase(DatabaseRequest request) throws ProviderException {
        try {
            DatabaseInstance instance = databases.get(this.databaseConfig);
            return instance.createDatabase(this.clientConfig, request);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf(e.getCause(), ProviderException.class);
            throw new ProviderException("Unexpected error when preparing a database cluster", e.getCause());
        }
        catch (SQLException e) {
            throw new ProviderException("Unexpected error when creating a database", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerMSSQLDatabaseProvider that = (DockerMSSQLDatabaseProvider)o;
        return Objects.equals(this.databaseConfig, that.databaseConfig) && Objects.equals(this.clientConfig, that.clientConfig);
    }

    public int hashCode() {
        return Objects.hash(this.databaseConfig, this.clientConfig);
    }

    private static class ClientConfig {
        private final Map<String, String> connectProperties;

        private ClientConfig(Map<String, String> connectProperties) {
            this.connectProperties = ImmutableMap.copyOf(connectProperties);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientConfig that = (ClientConfig)o;
            return Objects.equals(this.connectProperties, that.connectProperties);
        }

        public int hashCode() {
            return Objects.hash(this.connectProperties);
        }
    }

    private static class DatabaseConfig {
        private final String dockerImage;
        private final List<MSSQLServerContainerCustomizer> customizers;

        private DatabaseConfig(String dockerImage, List<MSSQLServerContainerCustomizer> customizers) {
            this.dockerImage = dockerImage;
            this.customizers = customizers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DatabaseConfig that = (DatabaseConfig)o;
            return Objects.equals(this.dockerImage, that.dockerImage) && DeepEquals.deepEquals(this.customizers, that.customizers);
        }

        public int hashCode() {
            int result = Objects.hash(this.dockerImage);
            result = 31 * result + DeepEquals.deepHashCode(this.customizers);
            return result;
        }
    }

    protected static class DatabaseInstance {
        private final MSSQLServerContainer container;
        private final Semaphore semaphore;

        private DatabaseInstance(DatabaseConfig config) {
            this.container = this.createContainer(config.dockerImage);
            config.customizers.forEach(c -> c.customize(this.container));
            this.container.start();
            this.container.followOutput((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger(DockerMSSQLDatabaseProvider.class)));
            this.semaphore = new Semaphore(Short.MAX_VALUE);
        }

        private MSSQLServerContainer createContainer(String dockerImage) {
            if (ClassUtils.hasMethod(DockerImageName.class, (String)"asCompatibleSubstituteFor", (Class[])new Class[]{String.class})) {
                return new MSSQLServerContainer(DockerImageName.parse((String)dockerImage).asCompatibleSubstituteFor("mcr.microsoft.com/mssql/server")){

                    public String getUsername() {
                        return "sa";
                    }
                };
            }
            return new MSSQLServerContainer(dockerImage){

                public String getUsername() {
                    return "sa";
                }
            };
        }

        public EmbeddedDatabase createDatabase(ClientConfig config, DatabaseRequest request) throws SQLException {
            DatabaseTemplate template = request.getTemplate();
            DatabasePreparer preparer = request.getPreparer();
            String databaseName = RandomStringUtils.randomAlphabetic(12).toLowerCase(Locale.ENGLISH);
            if (template != null) {
                this.executeStatement(config, String.format("RESTORE DATABASE %s FROM DISK = N'/var/opt/mssql/template/%s.bak' WITH MOVE '%s' TO N'/var/opt/mssql/data/%s.mdf', MOVE '%s_log' TO N'/var/opt/mssql/data/%s_log.ldf'", databaseName, template.getTemplateName(), template.getTemplateName(), databaseName, template.getTemplateName(), databaseName));
            } else {
                this.executeStatement(config, String.format("CREATE DATABASE %s", databaseName));
            }
            try {
                EmbeddedDatabase database = this.getDatabase(config, databaseName);
                if (preparer != null) {
                    preparer.prepare(database);
                }
                return database;
            }
            catch (Exception e) {
                this.dropDatabase(config, databaseName);
                throw e;
            }
        }

        public DatabaseTemplate createTemplate(ClientConfig config, DatabaseRequest request) throws SQLException {
            try (EmbeddedDatabase database = this.createDatabase(config, request);){
                ISQLServerDataSource dataSource = database.unwrap(ISQLServerDataSource.class);
                String templateName = dataSource.getDatabaseName();
                this.executeStatement(config, String.format("BACKUP DATABASE %s TO DISK = N'/var/opt/mssql/template/%s.bak'", templateName, templateName));
                SimpleDatabaseTemplate simpleDatabaseTemplate = new SimpleDatabaseTemplate(templateName, () -> this.dropTemplate(templateName));
                return simpleDatabaseTemplate;
            }
        }

        private void dropDatabase(ClientConfig config, String dbName) {
            CompletableFuture.runAsync(() -> {
                try {
                    this.executeStatement(config, String.format("DROP DATABASE IF EXISTS %s", dbName));
                }
                catch (Exception e) {
                    if (logger.isTraceEnabled()) {
                        logger.warn("Unable to release '{}' database", (Object)dbName, (Object)e);
                    }
                    logger.warn("Unable to release '{}' database", (Object)dbName);
                }
            });
        }

        private void dropTemplate(String templateName) {
            CompletableFuture.runAsync(() -> {
                try {
                    this.container.execInContainer(new String[]{"rm", String.format("/var/opt/mssql/template/%s.bak", templateName)});
                }
                catch (Exception e) {
                    logger.error("Unable to release '{}' database template", (Object)templateName, (Object)e);
                }
            });
        }

        private void executeStatement(ClientConfig config, String ddlStatement) throws SQLException {
            EmbeddedDatabase dataSource = this.getDatabase(config, "master");
            try (Connection connection = dataSource.getConnection();
                 PreparedStatement stmt = connection.prepareStatement(ddlStatement);){
                stmt.execute();
            }
        }

        private EmbeddedDatabase getDatabase(ClientConfig config, String dbName) {
            SQLServerDataSource dataSource = new SQLServerDataSource();
            dataSource.setServerName(this.container.getContainerIpAddress());
            dataSource.setPortNumber(this.container.getMappedPort(MSSQLServerContainer.MS_SQL_SERVER_PORT.intValue()).intValue());
            dataSource.setDatabaseName(dbName);
            dataSource.setUser(this.container.getUsername());
            dataSource.setPassword(this.container.getPassword());
            BeanWrapperImpl dataSourceWrapper = new BeanWrapperImpl((Object)dataSource);
            for (Map.Entry entry : config.connectProperties.entrySet()) {
                dataSourceWrapper.setPropertyValue((String)entry.getKey(), entry.getValue());
            }
            return new BlockingDatabaseWrapper(new MsSQLEmbeddedDatabase(dataSource, () -> this.dropDatabase(config, dbName)), this.semaphore);
        }
    }
}

