/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.logging;

import io.zonky.test.db.provider.EmbeddedDatabase;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedDatabaseReporter {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedDatabaseReporter.class);

    public static void reportDataSource(String beanName, EmbeddedDatabase database, AnnotatedElement element) {
        logger.info("JDBC URL to connect to '{}': url='{}', scope='{}'", new Object[]{beanName, database.getJdbcUrl(), EmbeddedDatabaseReporter.getElementName(element)});
    }

    private static String getElementName(AnnotatedElement element) {
        if (element instanceof Class) {
            return ((Class)element).getSimpleName();
        }
        if (element instanceof Method) {
            Method method = (Method)element;
            return EmbeddedDatabaseReporter.getElementName(method.getDeclaringClass()) + "#" + method.getName();
        }
        return element.toString();
    }
}

