/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.config;

import io.zonky.test.db.config.ConditionalOnClass;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;

@Order(value=-2147483648)
class OnClassCondition
implements Condition {
    OnClassCondition() {
    }

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ClassLoader classLoader = context.getClassLoader();
        List<String> candidates = this.getCandidates(metadata, ConditionalOnClass.class);
        for (String className : candidates) {
            if (ClassUtils.isPresent((String)className, (ClassLoader)classLoader)) continue;
            return false;
        }
        return true;
    }

    private List<String> getCandidates(AnnotatedTypeMetadata metadata, Class<?> annotationType) {
        MultiValueMap attributes = metadata.getAllAnnotationAttributes(annotationType.getName(), true);
        if (attributes == null || attributes.get((Object)"name") == null) {
            throw new IllegalStateException("@ConditionalOnClass did not specify a class name");
        }
        return ((List)attributes.get((Object)"name")).stream().flatMap(o -> Arrays.stream((String[])o)).collect(Collectors.toList());
    }
}

