/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.util;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class PropertyUtils {
    private PropertyUtils() {
    }

    public static Map<String, String> extractAll(Environment environment, String prefix) {
        prefix = prefix + ".";
        HashMap<String, String> properties = new HashMap<String, String>();
        if (environment instanceof ConfigurableEnvironment) {
            for (PropertySource propertySource : ((ConfigurableEnvironment)environment).getPropertySources()) {
                if (!(propertySource instanceof EnumerablePropertySource)) continue;
                for (String key : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                    if (!key.startsWith(prefix)) continue;
                    properties.put(key.substring(prefix.length()), String.valueOf(propertySource.getProperty(key)));
                }
            }
        }
        return properties;
    }

    public static <E extends Enum<E>> E getEnumProperty(Environment environment, String key, Class<E> enumType) {
        return PropertyUtils.getEnumProperty(environment, key, enumType, null);
    }

    public static <E extends Enum<E>> E getEnumProperty(Environment environment, String key, Class<E> enumType, E defaultValue) {
        String enumName = (String)environment.getProperty(key, String.class);
        if (enumName == null) {
            return defaultValue;
        }
        String normalizedEnumName = enumName.trim().replaceAll("-", "_").toUpperCase(Locale.ENGLISH);
        for (Enum candidate : EnumSet.allOf(enumType)) {
            if (!candidate.name().equals(normalizedEnumName)) continue;
            return (E)candidate;
        }
        throw new IllegalArgumentException("No enum constant " + enumType.getCanonicalName() + "." + enumName);
    }
}

