/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.stackdriver.internal;

import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.Status;
import zipkin2.Callback;

final class CallbackToUnaryClientCallListener<RespT>
extends ClientCall.Listener<RespT> {
    private final Callback<RespT> callback;
    boolean valueSet;
    RespT value;

    CallbackToUnaryClientCallListener(Callback<RespT> callback) {
        this.callback = callback;
    }

    public void onHeaders(Metadata headers) {
    }

    public synchronized void onMessage(RespT value) {
        if (this.valueSet) {
            throw Status.INTERNAL.withDescription("More than one value received for unary call").asRuntimeException();
        }
        this.valueSet = true;
        this.value = value;
    }

    public synchronized void onClose(Status status, Metadata trailers) {
        if (status.isOk()) {
            if (!this.valueSet) {
                this.callback.onError((Throwable)Status.INTERNAL.withDescription("No value received for unary call").asRuntimeException(trailers));
            }
            this.callback.onSuccess(this.value);
        } else {
            this.callback.onError((Throwable)status.asRuntimeException(trailers));
        }
    }
}

