/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.stackdriver;

import com.google.devtools.cloudtrace.v1.Trace;
import com.google.devtools.cloudtrace.v1.TraceSpan;
import com.google.devtools.cloudtrace.v1.Traces;
import java.io.IOException;
import zipkin2.reporter.stackdriver.TraceCollator;

final class TracesParser
implements TraceCollator.Observer {
    final String projectId;
    final Trace.Builder currentTrace = Trace.newBuilder();
    final Traces.Builder tracesBuilder = Traces.newBuilder();

    static Traces parse(String projectId, byte[] traceIdPrefixedSpan) {
        char[] traceId = new char[32];
        for (int i = 0; i < 32; ++i) {
            traceId[i] = (char)traceIdPrefixedSpan[i];
        }
        Trace trace = Trace.newBuilder().setProjectId(projectId).setTraceId(new String(traceId)).addSpans(TracesParser.parseTraceIdPrefixedSpan(traceIdPrefixedSpan)).build();
        return Traces.newBuilder().addTraces(trace).build();
    }

    TracesParser(String projectId) {
        this.projectId = projectId;
    }

    @Override
    public void firstTrace(char[] traceId, byte[] traceIdPrefixedSpan) {
        this.initCurrentTrace(traceId, traceIdPrefixedSpan);
        this.tracesBuilder.clear();
    }

    void initCurrentTrace(char[] traceId, byte[] traceIdPrefixedSpan) {
        this.currentTrace.clearSpans().setProjectId(this.projectId).setTraceId(new String(traceId)).addSpans(TracesParser.parseTraceIdPrefixedSpan(traceIdPrefixedSpan));
    }

    @Override
    public void nextSpan(byte[] traceIdPrefixedSpan) {
        TraceSpan traceSpan = TracesParser.parseTraceIdPrefixedSpan(traceIdPrefixedSpan);
        this.currentTrace.addSpans(traceSpan);
    }

    @Override
    public void nextTrace(char[] traceId, byte[] traceIdPrefixedSpan) {
        this.tracesBuilder.addTraces(this.currentTrace);
        this.initCurrentTrace(traceId, traceIdPrefixedSpan);
    }

    Traces finish() {
        return this.tracesBuilder.addTraces(this.currentTrace).build();
    }

    static TraceSpan parseTraceIdPrefixedSpan(byte[] traceIdPrefixedSpan) {
        int off = 32;
        int len = traceIdPrefixedSpan.length - off;
        try {
            return (TraceSpan)TraceSpan.parser().parseFrom(traceIdPrefixedSpan, off, len);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

