/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.stackdriver;

import com.google.common.primitives.UnsignedBytes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class TraceCollator {
    final ArrayList<byte[]> sortedTraceIdPrefixedSpans = new ArrayList();
    final char[] currentTraceId = new char[32];
    final char[] lastTraceId = new char[32];
    static final Comparator<byte[]> TRACE_ID_COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] left, byte[] right) {
            for (int i = 0; i < 32; ++i) {
                int comparison = UnsignedBytes.compare((byte)left[i], (byte)right[i]);
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }
    };

    TraceCollator() {
    }

    void collate(List<byte[]> traceIdPrefixedSpans, Observer observer) {
        int length = traceIdPrefixedSpans.size();
        assert (length > 1);
        this.sortedTraceIdPrefixedSpans.clear();
        this.sortedTraceIdPrefixedSpans.addAll(traceIdPrefixedSpans);
        Collections.sort(this.sortedTraceIdPrefixedSpans, TRACE_ID_COMPARATOR);
        byte[] currentTraceIdPrefixedSpan = this.sortedTraceIdPrefixedSpans.get(0);
        this.parseCurrentTraceId(currentTraceIdPrefixedSpan);
        this.setLastTraceId();
        observer.firstTrace(this.currentTraceId, currentTraceIdPrefixedSpan);
        for (int i = 1; i < length; ++i) {
            currentTraceIdPrefixedSpan = this.sortedTraceIdPrefixedSpans.get(i);
            this.parseCurrentTraceId(currentTraceIdPrefixedSpan);
            if (Arrays.equals(this.currentTraceId, this.lastTraceId)) {
                observer.nextSpan(currentTraceIdPrefixedSpan);
                continue;
            }
            observer.nextTrace(this.currentTraceId, currentTraceIdPrefixedSpan);
            this.setLastTraceId();
        }
    }

    void parseCurrentTraceId(byte[] currentTraceIdPrefixedSpan) {
        for (int i = 0; i < 32; ++i) {
            this.currentTraceId[i] = (char)currentTraceIdPrefixedSpan[i];
        }
    }

    void setLastTraceId() {
        System.arraycopy(this.currentTraceId, 0, this.lastTraceId, 0, 32);
    }

    static interface Observer {
        public void firstTrace(char[] var1, byte[] var2);

        public void nextSpan(byte[] var1);

        public void nextTrace(char[] var1, byte[] var2);
    }
}

