/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.stackdriver;

import com.google.protobuf.CodedOutputStream;
import zipkin2.reporter.stackdriver.TraceCollator;

final class PatchTracesRequestSizer
implements TraceCollator.Observer {
    final int projectIdFieldSize;
    int traceListSize = 0;
    int traceSpanSize;
    int currentTraceSize;

    static int size(int projectIdFieldSize, int traceSpanSize) {
        int sizeOfTraceMessage = PatchTracesRequestSizer.traceSize(projectIdFieldSize, traceSpanSize);
        int sizeOfTraceField = 1 + CodedOutputStream.computeUInt32SizeNoTag((int)sizeOfTraceMessage) + sizeOfTraceMessage;
        return PatchTracesRequestSizer.sizeOfPatchTracesRequest(projectIdFieldSize, sizeOfTraceField);
    }

    PatchTracesRequestSizer(int projectIdFieldSize) {
        this.projectIdFieldSize = projectIdFieldSize;
    }

    @Override
    public void firstTrace(char[] traceId, byte[] traceIdPrefixedSpan) {
        this.traceSpanSize = traceIdPrefixedSpan.length - 32;
        this.currentTraceSize = PatchTracesRequestSizer.traceSize(this.projectIdFieldSize, this.traceSpanSize);
    }

    @Override
    public void nextSpan(byte[] traceIdPrefixedSpan) {
        this.traceSpanSize = traceIdPrefixedSpan.length - 32;
        this.currentTraceSize += 1 + CodedOutputStream.computeUInt32SizeNoTag((int)this.traceSpanSize) + this.traceSpanSize;
    }

    @Override
    public void nextTrace(char[] traceId, byte[] traceIdPrefixedSpan) {
        this.traceListSize += 1 + CodedOutputStream.computeUInt32SizeNoTag((int)this.currentTraceSize) + this.currentTraceSize;
        this.traceSpanSize = traceIdPrefixedSpan.length - 32;
        this.currentTraceSize = PatchTracesRequestSizer.traceSize(this.projectIdFieldSize, this.traceSpanSize);
    }

    int finish() {
        this.traceListSize += 1 + CodedOutputStream.computeUInt32SizeNoTag((int)this.currentTraceSize) + this.currentTraceSize;
        return PatchTracesRequestSizer.sizeOfPatchTracesRequest(this.projectIdFieldSize, this.traceListSize);
    }

    static int sizeOfPatchTracesRequest(int projectIdFieldSize, int traceListSize) {
        int result = projectIdFieldSize;
        return result += 1 + CodedOutputStream.computeUInt32SizeNoTag((int)traceListSize) + traceListSize;
    }

    static int traceSize(int projectIdFieldSize, int traceSpanSize) {
        int result = projectIdFieldSize;
        result += 34;
        return result += 1 + CodedOutputStream.computeUInt32SizeNoTag((int)traceSpanSize) + traceSpanSize;
    }
}

