/*
 * Decompiled with CFR 0.152.
 */
package brave.context.rxjava2.internal;

import brave.context.rxjava2.internal.Util;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class TraceContextSubscriber<T>
implements Subscriber<T> {
    final Subscriber<T> downstream;
    final CurrentTraceContext contextScoper;
    final TraceContext assembled;
    Subscription upstream;
    boolean done;

    TraceContextSubscriber(Subscriber<T> downstream, CurrentTraceContext contextScoper, TraceContext assembled) {
        this.downstream = downstream;
        this.contextScoper = contextScoper;
        this.assembled = assembled;
    }

    public final void onSubscribe(Subscription s) {
        if (!Util.validate(this.upstream, s)) {
            return;
        }
        this.upstream = s;
        this.downstream.onSubscribe(this.upstream);
    }

    public void onNext(T t) {
        CurrentTraceContext.Scope scope = this.contextScoper.maybeScope(this.assembled);
        try {
            this.downstream.onNext(t);
        }
        finally {
            scope.close();
        }
    }

    public void onError(Throwable t) {
        if (this.done) {
            RxJavaPlugins.onError((Throwable)t);
            return;
        }
        this.done = true;
        CurrentTraceContext.Scope scope = this.contextScoper.maybeScope(this.assembled);
        try {
            this.downstream.onError(t);
        }
        finally {
            scope.close();
        }
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        CurrentTraceContext.Scope scope = this.contextScoper.maybeScope(this.assembled);
        try {
            this.downstream.onComplete();
        }
        finally {
            scope.close();
        }
    }
}

