/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.bundlebee.operator.configuration;

import java.util.Map;
import java.util.function.Supplier;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.config.spi.ConfigSource;

@Vetoed
public class ThreadLocalConfigSource
implements ConfigSource {
    private final ThreadLocal<Map<String, String>> threadLocal = new ThreadLocal();

    public Map<String, String> getProperties() {
        Map<String, String> map = this.threadLocal.get();
        if (map == null) {
            this.threadLocal.remove();
            return Map.of();
        }
        return map;
    }

    public String getValue(String s) {
        return this.getProperties().get(s);
    }

    public String getName() {
        return "thread-local-config-source";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T forConfiguration(Map<String, String> config, Supplier<T> task) {
        this.threadLocal.set(config);
        try {
            T t = task.get();
            return t;
        }
        finally {
            this.threadLocal.remove();
        }
    }
}

