/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.exception.CommandException;
import io.webfolder.cdp.internal.gson.JsonElement;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class WSContext {
    private CountDownLatch latch = new CountDownLatch(1);
    private JsonElement data;
    private CommandException error;

    WSContext() {
    }

    void await(int timeout) {
        try {
            this.latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new CdpException(e);
        }
    }

    void setData(JsonElement data) {
        this.data = data;
        this.latch.countDown();
    }

    JsonElement getData() {
        return this.data;
    }

    void setError(CommandException error) {
        this.error = error;
        this.latch.countDown();
    }

    CommandException getError() {
        return this.error;
    }
}

