/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.event.Events;
import io.webfolder.cdp.exception.CommandException;
import io.webfolder.cdp.internal.gson.Gson;
import io.webfolder.cdp.internal.gson.JsonElement;
import io.webfolder.cdp.internal.gson.JsonObject;
import io.webfolder.cdp.internal.ws.WebSocket;
import io.webfolder.cdp.internal.ws.WebSocketAdapter;
import io.webfolder.cdp.listener.EventListener;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.session.WSContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

class WSAdapter
extends WebSocketAdapter {
    private final Map<String, Events> events = this.listEvents();
    private final Gson gson;
    private final Map<Integer, WSContext> contexts;
    private final List<EventListener> listeners;
    private final Executor executor;
    private final CdpLogger log;
    private Session session;

    WSAdapter(Gson gson, Map<Integer, WSContext> contexts, List<EventListener> listeners, Executor executor, CdpLogger log) {
        this.gson = gson;
        this.contexts = contexts;
        this.listeners = listeners;
        this.executor = executor;
        this.log = log;
    }

    @Override
    public void onTextMessage(WebSocket websocket, String data) throws Exception {
        this.onMessage(data, true);
    }

    void onMessage(String data, boolean async) throws Exception {
        Runnable runnable = () -> {
            this.log.debug(data, new Object[0]);
            JsonElement json = this.gson.fromJson(data, JsonElement.class);
            JsonObject object = json.getAsJsonObject();
            JsonElement idElement = object.get("id");
            if (idElement != null) {
                int valId;
                WSContext context;
                String id = idElement.getAsString();
                if (id != null && (context = this.contexts.remove(valId = Integer.parseInt(id))) != null) {
                    JsonObject error = object.getAsJsonObject("error");
                    if (error != null) {
                        int code = (int)error.getAsJsonPrimitive("code").getAsDouble();
                        String message = error.getAsJsonPrimitive("message").getAsString();
                        JsonElement messageData = error.get("data");
                        context.setError(new CommandException(code, message + (messageData != null && messageData.isJsonPrimitive() ? ". " + messageData.getAsString() : "")));
                    } else {
                        context.setData(json);
                    }
                }
            } else {
                JsonElement method = object.get("method");
                if (method != null && method.isJsonPrimitive()) {
                    String eventName = method.getAsString();
                    if ("Inspector.detached".equals(eventName) && this.session != null) {
                        if (this.session != null && this.session.isConnected()) {
                            Thread thread = new Thread(new TerminateSession(this.session, object));
                            thread.setName("cdp4j-terminate");
                            thread.setDaemon(true);
                            thread.start();
                            this.session = null;
                        }
                    } else {
                        Events event = this.events.get(eventName);
                        if (event != null) {
                            JsonElement params = object.get("params");
                            Object value = this.gson.fromJson(params, event.klass);
                            for (EventListener next : this.listeners) {
                                this.executor.execute(() -> next.onEvent(event, value));
                            }
                        }
                    }
                }
            }
        };
        if (async) {
            this.executor.execute(runnable);
        } else {
            runnable.run();
        }
    }

    Map<String, Events> listEvents() {
        HashMap<String, Events> map = new HashMap<String, Events>();
        for (Events next : Events.values()) {
            map.put(next.domain + "." + next.name, next);
        }
        return Collections.unmodifiableMap(map);
    }

    void setSession(Session session) {
        this.session = session;
    }

    private static class TerminateSession
    implements Runnable {
        private final Session session;
        private final JsonObject object;

        public TerminateSession(Session session, JsonObject object) {
            this.session = session;
            this.object = object;
        }

        @Override
        public void run() {
            if (this.session != null && this.session.isConnected()) {
                this.session.close();
                this.session.terminate(this.object.get("params").getAsJsonObject().get("reason").getAsString());
            }
        }
    }
}

