/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.event.Events;
import io.webfolder.cdp.event.target.DetachedFromTarget;
import io.webfolder.cdp.event.target.ReceivedMessageFromTarget;
import io.webfolder.cdp.event.target.TargetCreated;
import io.webfolder.cdp.event.target.TargetDestroyed;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.listener.EventListener;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.session.TabInfo;
import io.webfolder.cdp.session.WSAdapter;
import io.webfolder.cdp.type.target.TargetInfo;
import java.util.List;
import java.util.Map;

class TargetListener
implements EventListener {
    private Map<String, Session> sessions;
    private Map<String, WSAdapter> wsAdapters;
    private List<TabInfo> tabs;

    TargetListener(Map<String, Session> sessions, Map<String, WSAdapter> wsAdapters, List<TabInfo> tabs) {
        this.sessions = sessions;
        this.wsAdapters = wsAdapters;
        this.tabs = tabs;
    }

    @Override
    public void onEvent(Events event, Object value) {
        switch (event) {
            case TargetReceivedMessageFromTarget: {
                WSAdapter wsAdapter;
                ReceivedMessageFromTarget receivedMessage = (ReceivedMessageFromTarget)value;
                Session session = this.sessions.get(receivedMessage.getSessionId());
                if (session == null || (wsAdapter = this.wsAdapters.get(session.getId())) == null) break;
                try {
                    wsAdapter.onMessage(receivedMessage.getMessage(), false);
                    break;
                }
                catch (Exception e) {
                    throw new CdpException(e);
                }
            }
            case TargetTargetCreated: {
                TargetCreated targetCreated = (TargetCreated)value;
                TargetInfo info = targetCreated.getTargetInfo();
                String url = info.getUrl();
                String type = info.getType();
                if (!"page".equals(type) || !url.isEmpty() && !"about:blank".equals(url) && !"chrome://welcome/".equals(url) && !"chrome://newtab/".equals(url) && !url.startsWith("chrome://welcome-win10")) break;
                this.tabs.add(new TabInfo(info.getTargetId(), info.getBrowserContextId()));
                break;
            }
            case TargetTargetDestroyed: {
                TargetDestroyed destroyed = (TargetDestroyed)value;
                for (Session session : this.sessions.values()) {
                    if (!destroyed.getTargetId().equals(session.getTargetId()) || this.sessions.remove(session.getId()) == null) continue;
                    this.wsAdapters.remove(session.getId());
                    session.dispose();
                    session.terminate("Target.targetDestroyed");
                }
                for (TabInfo tabInfo : this.tabs) {
                    if (!destroyed.getTargetId().equals(tabInfo.getTargetId())) continue;
                    this.tabs.remove(tabInfo);
                }
                break;
            }
            case TargetDetachedFromTarget: {
                DetachedFromTarget detached = (DetachedFromTarget)value;
                Object var11_17 = null;
                Session session = this.sessions.remove(detached.getSessionId());
                if (session == null) break;
                this.wsAdapters.remove(session.getId());
                session.dispose();
                session.terminate("Target.detachedFromTarget");
                break;
            }
        }
    }
}

