/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.annotation.Domain;
import io.webfolder.cdp.annotation.Returns;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.internal.gson.Gson;
import io.webfolder.cdp.internal.gson.JsonArray;
import io.webfolder.cdp.internal.gson.JsonElement;
import io.webfolder.cdp.internal.gson.JsonObject;
import io.webfolder.cdp.internal.ws.WebSocket;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.session.WSContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

class SessionInvocationHandler
implements InvocationHandler {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Gson gson;
    private final WebSocket webSocket;
    private final Map<Integer, WSContext> contexts;
    private final List<String> enabledDomains = new CopyOnWriteArrayList<String>();
    private final CdpLogger log;
    private final Session session;
    private final boolean browserSession;
    private final String sessionId;
    private final String targetId;
    private final int timeout;

    SessionInvocationHandler(Gson gson, WebSocket webSocket, Map<Integer, WSContext> contexts, Session session, CdpLogger log, boolean browserSession, String sessionId, String targetId, int webSocketReadTimeout) {
        this.gson = gson;
        this.webSocket = webSocket;
        this.contexts = contexts;
        this.session = session;
        this.log = log;
        this.browserSession = browserSession;
        this.sessionId = sessionId;
        this.targetId = targetId;
        this.timeout = webSocketReadTimeout;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String returns;
        boolean disable;
        boolean enable;
        Class<?> klass = method.getDeclaringClass();
        String domain = klass.getAnnotation(Domain.class).value();
        String command = method.getName();
        boolean hasArgs = args != null && args.length > 0;
        boolean voidMethod = Void.TYPE.equals(method.getReturnType());
        boolean bl = enable = "enable".intern() == command && voidMethod;
        if (enable && this.enabledDomains.contains(domain)) {
            return null;
        }
        boolean bl2 = disable = "disable".intern() == command && voidMethod;
        if (disable) {
            this.enabledDomains.remove(domain);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(hasArgs ? args.length : 0);
        if (hasArgs) {
            int argIndex = 0;
            Parameter[] parameters = method.getParameters();
            for (Object argValue : args) {
                String argName = parameters[argIndex++].getName();
                params.put(argName, argValue);
            }
        }
        int id = this.counter.incrementAndGet();
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("id", id);
        map.put("method", String.format("%s.%s", domain, command));
        map.put("params", params);
        String json = this.gson.toJson(map);
        this.log.debug(json, new Object[0]);
        WSContext context = null;
        if (this.session.isConnected()) {
            context = new WSContext();
            this.contexts.put(id, context);
            if (this.browserSession) {
                this.webSocket.sendText(json);
            } else {
                this.session.getCommand().getTarget().sendMessageToTarget(json, this.sessionId, this.targetId);
            }
        } else {
            throw new CdpException("WebSocket connection is not alive. id: " + id);
        }
        context.await(this.timeout);
        if (context.getError() != null) {
            throw context.getError();
        }
        if (enable) {
            this.enabledDomains.add(domain);
        }
        Class<?> retType = method.getReturnType();
        if (voidMethod || retType.equals(Void.class)) {
            return null;
        }
        JsonElement data = context.getData();
        String string = returns = method.isAnnotationPresent(Returns.class) ? method.getAnnotation(Returns.class).value() : null;
        if (data == null) {
            return null;
        }
        if (!data.isJsonObject()) {
            throw new CdpException("invalid response");
        }
        JsonObject object = data.getAsJsonObject();
        JsonElement result = object.get("result");
        if (result == null || !result.isJsonObject()) {
            throw new CdpException("invalid result");
        }
        JsonObject resultObject = result.getAsJsonObject();
        Object ret = null;
        Type genericReturnType = method.getGenericReturnType();
        if (returns != null) {
            JsonElement jsonElement = resultObject.get(returns);
            if (jsonElement != null && jsonElement.isJsonPrimitive()) {
                if (String.class.equals(retType)) {
                    return resultObject.get(returns).getAsString();
                }
                if (Boolean.class.equals(retType)) {
                    return resultObject.get(returns).getAsBoolean() ? Boolean.TRUE : Boolean.FALSE;
                }
                if (Integer.class.equals(retType)) {
                    return resultObject.get(returns).getAsInt();
                }
                if (Double.class.equals(retType)) {
                    return resultObject.get(returns).getAsDouble();
                }
            }
            if (jsonElement != null && byte[].class.equals((Object)genericReturnType)) {
                String encoded = this.gson.fromJson(jsonElement, String.class);
                if (encoded == null || encoded.trim().isEmpty()) {
                    return null;
                }
                return Base64.getDecoder().decode(encoded);
            }
            if (List.class.equals(retType)) {
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                ret = this.gson.fromJson((JsonElement)jsonArray, genericReturnType);
            } else {
                ret = this.gson.fromJson(jsonElement, genericReturnType);
            }
        } else {
            ret = this.gson.fromJson((JsonElement)resultObject, genericReturnType);
        }
        return ret;
    }

    void dispose() {
        this.enabledDomains.clear();
        for (WSContext context : this.contexts.values()) {
            try {
                context.setData(null);
            }
            catch (Throwable throwable) {}
        }
    }

    WSContext getContext(int id) {
        return this.contexts.get(id);
    }
}

