/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.command.Target;
import io.webfolder.cdp.event.Events;
import io.webfolder.cdp.event.runtime.ExecutionContextCreated;
import io.webfolder.cdp.event.runtime.ExecutionContextDestroyed;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.internal.gson.Gson;
import io.webfolder.cdp.internal.gson.GsonBuilder;
import io.webfolder.cdp.internal.ws.WebSocket;
import io.webfolder.cdp.internal.ws.WebSocketException;
import io.webfolder.cdp.internal.ws.WebSocketFactory;
import io.webfolder.cdp.internal.ws.ZeroMasker;
import io.webfolder.cdp.listener.EventListener;
import io.webfolder.cdp.logger.CdpLoggerFactory;
import io.webfolder.cdp.logger.CdpLoggerType;
import io.webfolder.cdp.logger.LoggerFactory;
import io.webfolder.cdp.session.CdpThreadFactory;
import io.webfolder.cdp.session.Command;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.session.TabInfo;
import io.webfolder.cdp.session.TargetListener;
import io.webfolder.cdp.session.WSAdapter;
import io.webfolder.cdp.session.WSContext;
import io.webfolder.cdp.type.target.TargetInfo;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SessionFactory
implements AutoCloseable {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 9222;
    private final String host;
    private final int port;
    private final int connectionTimeout;
    private final WebSocketFactory factory;
    private final Gson gson;
    private final LoggerFactory loggerFactory;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    private static final Integer DEFAULT_SCREEN_WIDTH = 1366;
    private static final Integer DEFAULT_SCREEN_HEIGHT = 768;
    private static final int DEFAULT_WS_READ_TIMEOUT = 10000;
    private final Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    private final Map<String, WSAdapter> wsAdapters = new ConcurrentHashMap<String, WSAdapter>();
    private final List<String> contexts = new CopyOnWriteArrayList<String>();
    private final List<TabInfo> tabs = new CopyOnWriteArrayList<TabInfo>();
    private final ExecutorService threadPool;
    private WebSocket webSocket;
    private volatile Session browserSession;
    private volatile boolean closed;
    private volatile Boolean headless;
    private volatile int webSocketReadTimeout = 10000;
    private volatile int majorVersion;

    public SessionFactory() {
        this(DEFAULT_HOST, 9222, 60000, CdpLoggerType.Slf4j, Executors.newCachedThreadPool(new CdpThreadFactory()));
    }

    public SessionFactory(CdpLoggerType loggerType) {
        this(DEFAULT_HOST, 9222, 60000, loggerType, Executors.newCachedThreadPool(new CdpThreadFactory()));
    }

    public SessionFactory(int port) {
        this(DEFAULT_HOST, port, 60000, CdpLoggerType.Slf4j, Executors.newCachedThreadPool(new CdpThreadFactory()));
    }

    public SessionFactory(int port, CdpLoggerType loggerType) {
        this(DEFAULT_HOST, port, 60000, loggerType, Executors.newCachedThreadPool(new CdpThreadFactory()));
    }

    public SessionFactory(String host, int port) {
        this(host, port, 60000, CdpLoggerType.Slf4j, Executors.newCachedThreadPool(new CdpThreadFactory()));
    }

    public SessionFactory(String host, int port, CdpLoggerType loggerType, ExecutorService threadPool) {
        this(host, port, 60000, loggerType, threadPool);
    }

    public SessionFactory(String host, int port, int connectionTimeout, CdpLoggerType loggerType, ExecutorService threadPool) {
        this.host = host;
        this.port = port;
        this.connectionTimeout = connectionTimeout;
        this.factory = new WebSocketFactory();
        this.loggerFactory = this.createLoggerFactory(loggerType);
        this.threadPool = threadPool;
        this.gson = new GsonBuilder().disableHtmlEscaping().create();
        this.factory.setConnectionTimeout(this.connectionTimeout);
        if (ThreadPoolExecutor.class.isAssignableFrom(threadPool.getClass())) {
            ((ThreadPoolExecutor)threadPool).setKeepAliveTime(5L, TimeUnit.SECONDS);
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public Session create() {
        return this.create(null);
    }

    public Session create(String browserContextId) {
        boolean initialized = this.browserSession != null;
        Session browserSession = this.getBrowserSession();
        Target target = browserSession.getCommand().getTarget();
        TabInfo tab = null;
        if (!initialized) {
            for (int i = 0; i < 500 && this.tabs.isEmpty(); ++i) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new CdpException(e);
                }
            }
            if (!this.tabs.isEmpty()) {
                tab = this.tabs.remove(0);
            }
        }
        if (tab == null) {
            String targetId = target.createTarget("about:blank", DEFAULT_SCREEN_WIDTH, DEFAULT_SCREEN_HEIGHT, browserContextId, false);
            boolean found = false;
            for (int i = 0; i < 500 && !found; ++i) {
                for (TabInfo info : this.tabs) {
                    if (!info.getTargetId().equals(targetId)) continue;
                    found = true;
                    this.tabs.remove(info);
                    break;
                }
                if (found) continue;
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new CdpException(e);
                }
            }
            tab = new TabInfo(targetId, browserContextId);
        }
        return this.connect(tab.getTargetId(), tab.getBrowserContextId());
    }

    public Session connect(String targetId) {
        return this.connect(targetId, null);
    }

    Session connect(String targetId, String browserContextId) {
        Session bs = this.getBrowserSession();
        if (browserContextId == null) {
            TargetInfo found = null;
            List<TargetInfo> targets = bs.getCommand().getTarget().getTargets();
            for (TargetInfo next : targets) {
                if (!next.getTargetId().equals(targetId)) continue;
                found = next;
            }
            if (found == null) {
                throw new CdpException("Target not found: " + targetId);
            }
            browserContextId = found.getBrowserContextId();
        }
        Target target = bs.getCommand().getTarget();
        String sessionId = target.attachToTarget(targetId);
        ConcurrentHashMap<Integer, WSContext> contexts = new ConcurrentHashMap<Integer, WSContext>();
        CopyOnWriteArrayList<EventListener> listeners = new CopyOnWriteArrayList<EventListener>();
        Session session = new Session(this.gson, sessionId, targetId, browserContextId, this.webSocket, contexts, this, listeners, this.loggerFactory, false, this.browserSession, this.getMajorVersion());
        WSAdapter wsAdapter = new WSAdapter(this.gson, contexts, listeners, this.threadPool, this.loggerFactory.getLogger("cdp4j.ws.response"));
        wsAdapter.setSession(session);
        this.wsAdapters.put(sessionId, wsAdapter);
        this.sessions.put(sessionId, session);
        session.getCommand().getRuntime().enable();
        session.addEventListener((event, value) -> {
            ExecutionContextDestroyed ecd;
            if (Events.RuntimeExecutionContextCreated.equals((Object)event)) {
                ExecutionContextCreated ecc = (ExecutionContextCreated)value;
                if (targetId.equals(ecc.getContext().getAuxData().get("frameId"))) {
                    session.setExecutionContextId(ecc.getContext().getId());
                }
            } else if (Events.RuntimeExecutionContextDestroyed.equals((Object)event) && (ecd = (ExecutionContextDestroyed)value).getExecutionContextId() != null && ecd.getExecutionContextId().equals(session.getExecutionContextId())) {
                session.setExecutionContextId(null);
            }
        });
        Command command = session.getCommand();
        command.getInspector().enable();
        command.getPage().enable();
        command.getPage().setLifecycleEventsEnabled(true);
        return session;
    }

    private synchronized Session getBrowserSession() {
        if (this.browserSession == null) {
            Map<String, Object> version = this.getVersion();
            String webSocketDebuggerUrl = (String)version.get("webSocketDebuggerUrl");
            this.webSocket = null;
            try {
                this.webSocket = this.factory.createSocket(webSocketDebuggerUrl);
                this.webSocket.setPayloadMask(new ZeroMasker());
            }
            catch (IOException e) {
                throw new CdpException(e);
            }
            ConcurrentHashMap<Integer, WSContext> contexts = new ConcurrentHashMap<Integer, WSContext>();
            CopyOnWriteArrayList<EventListener> listeners = new CopyOnWriteArrayList<EventListener>();
            WSAdapter adapter = new WSAdapter(this.gson, contexts, listeners, this.threadPool, this.loggerFactory.getLogger("cdp4j.ws.response"));
            this.webSocket.addListener(adapter);
            try {
                this.webSocket.connect();
            }
            catch (WebSocketException e) {
                throw new CdpException(e);
            }
            this.webSocket.setAutoFlush(true);
            this.browserSession = new Session(this.gson, webSocketDebuggerUrl, webSocketDebuggerUrl, null, this.webSocket, contexts, this, listeners, this.loggerFactory, true, null, 0);
            adapter.setSession(this.browserSession);
            this.browserSession.addEventListener(new TargetListener(this.sessions, this.wsAdapters, this.tabs));
            Target target = this.browserSession.getCommand().getTarget();
            target.setDiscoverTargets(Boolean.TRUE);
            this.browserSession.onTerminate(event -> this.close());
        }
        return this.browserSession;
    }

    void close(Session session) {
        if (this.browserSession.isConnected()) {
            int version = this.getMajorVersion();
            if (version >= 68) {
                session.getCommand().getPage().close();
            } else {
                this.browserSession.getCommand().getTarget().closeTarget(session.getTargetId());
            }
        }
        session.dispose();
        this.wsAdapters.remove(session.getId());
        this.sessions.remove(session.getId());
    }

    private int getMajorVersion() {
        String[] version;
        String[] product;
        if (this.majorVersion == 0 && (product = this.browserSession.getCommand().getBrowser().getVersion().getProduct().split("/")).length == 2 && (version = product[1].split("\\.")).length > 2) {
            this.majorVersion = Integer.parseInt(version[0]);
        }
        return this.majorVersion;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.browserSession != null) {
            this.browserSession.dispose();
        }
        this.sessions.clear();
        this.wsAdapters.clear();
        this.contexts.clear();
        this.tabs.clear();
        this.threadPool.shutdownNow();
        this.browserSession = null;
    }

    public void activate(String sessionId) {
        Session session = null;
        for (Session next : this.sessions.values()) {
            if (!next.getId().equals(sessionId)) continue;
            session = next;
            break;
        }
        if (session != null) {
            this.browserSession.getCommand().getTarget().activateTarget(session.getTargetId());
        }
    }

    public boolean isHeadless() {
        if (this.headless == null) {
            this.headless = this.getBrowserSession().getCommand().getBrowser().getVersion().getProduct().toLowerCase(Locale.ENGLISH).contains("headless");
        }
        return this.headless;
    }

    private Map<String, Object> getVersion() {
        String sessions = String.format("http://%s:%d/json/version", this.host, this.port);
        URL url = null;
        Reader reader = null;
        try {
            Map map;
            url = new URL(sessions);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(this.connectionTimeout);
            reader = new InputStreamReader(conn.getInputStream());
            Map map2 = map = this.gson.fromJson(reader, Map.class);
            return map2;
        }
        catch (ConnectException e) {
            throw new CdpException(String.format("Unable to connect [%s:%d]", this.host, this.port));
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean ping() {
        String sessions = String.format("http://%s:%d/json/version", this.host, this.port);
        try {
            URL url = new URL(sessions);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            int timeout = 500;
            conn.setConnectTimeout(500);
            conn.setReadTimeout(500);
            try (InputStreamReader reader = new InputStreamReader(conn.getInputStream());){
                while (((Reader)reader).read() != -1) {
                }
            }
            return conn.getResponseCode() == 200;
        }
        catch (ConnectException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String createBrowserContext() {
        String browserContextId = this.getBrowserSession().getCommand().getTarget().createBrowserContext();
        this.contexts.add(browserContextId);
        return browserContextId;
    }

    public void disposeBrowserContext(String browserContextId) {
        if (this.contexts.contains(browserContextId)) {
            this.getBrowserSession().getCommand().getTarget().disposeBrowserContext(browserContextId);
            this.contexts.remove(browserContextId);
        }
    }

    ExecutorService getThreadPool() {
        return this.threadPool;
    }

    protected LoggerFactory createLoggerFactory(CdpLoggerType loggerType) {
        ServiceLoader<LoggerFactory> loader = ServiceLoader.load(LoggerFactory.class);
        Iterator<LoggerFactory> iter = loader.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return new CdpLoggerFactory(loggerType);
    }

    public int getWebSocketReadTimeout() {
        return this.webSocketReadTimeout;
    }

    public void setWebSocketReadTimeout(int webSocketReadTimeout) {
        this.webSocketReadTimeout = webSocketReadTimeout;
    }

    public String toString() {
        return "SessionFactory [host=" + this.host + ", port=" + this.port + ", sessions=" + this.sessions + "]";
    }
}

