/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.JsFunction;
import io.webfolder.cdp.annotation.Experimental;
import io.webfolder.cdp.annotation.Optional;
import io.webfolder.cdp.command.CSS;
import io.webfolder.cdp.command.Emulation;
import io.webfolder.cdp.command.Page;
import io.webfolder.cdp.event.Events;
import io.webfolder.cdp.event.log.EntryAdded;
import io.webfolder.cdp.event.network.ResponseReceived;
import io.webfolder.cdp.event.page.LifecycleEvent;
import io.webfolder.cdp.event.runtime.ConsoleAPICalled;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.exception.DestinationUnreachableException;
import io.webfolder.cdp.exception.LoadTimeoutException;
import io.webfolder.cdp.internal.gson.Gson;
import io.webfolder.cdp.internal.ws.WebSocket;
import io.webfolder.cdp.listener.EventListener;
import io.webfolder.cdp.listener.TerminateEvent;
import io.webfolder.cdp.listener.TerminateListener;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.logger.LoggerFactory;
import io.webfolder.cdp.session.Command;
import io.webfolder.cdp.session.Dom;
import io.webfolder.cdp.session.JavaScript;
import io.webfolder.cdp.session.Keyboard;
import io.webfolder.cdp.session.Mouse;
import io.webfolder.cdp.session.Navigator;
import io.webfolder.cdp.session.Selector;
import io.webfolder.cdp.session.SessionFactory;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.session.WSContext;
import io.webfolder.cdp.session.WaitUntil;
import io.webfolder.cdp.type.constant.ImageFormat;
import io.webfolder.cdp.type.css.SourceRange;
import io.webfolder.cdp.type.dom.Rect;
import io.webfolder.cdp.type.log.LogEntry;
import io.webfolder.cdp.type.network.ResourceType;
import io.webfolder.cdp.type.network.Response;
import io.webfolder.cdp.type.page.GetLayoutMetricsResult;
import io.webfolder.cdp.type.page.NavigateResult;
import io.webfolder.cdp.type.page.Viewport;
import io.webfolder.cdp.type.runtime.RemoteObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;

public class Session
implements AutoCloseable,
Selector,
Keyboard,
Mouse,
Navigator,
JavaScript,
Dom {
    private final Map<Class<?>, Object> proxies = new ConcurrentHashMap();
    private AtomicBoolean connected = new AtomicBoolean(true);
    private final List<EventListener> listeners;
    private final SessionInvocationHandler invocationHandler;
    private final SessionFactory sesessionFactory;
    private final String sessionId;
    private final WebSocket webSocket;
    private final CdpLogger log;
    private final CdpLogger logFlow;
    private final Gson gson;
    private final String targetId;
    private final boolean browserSession;
    private volatile TerminateListener terminateListener;
    private String frameId;
    private Command command;
    private final ReentrantLock lock = new ReentrantLock(true);
    private String browserContextId;
    private volatile Integer executionContextId;
    private final int majorVersion;
    private final Map<Class<?>, Object> jsFunctions;
    private static final ThreadLocal<Boolean> ENABLE_ENTRY_EXIT_LOG = ThreadLocal.withInitial(() -> Boolean.TRUE);

    Session(Gson gson, String sessionId, String targetId, String browserContextId, WebSocket webSocket, Map<Integer, WSContext> contextList, SessionFactory sessionFactory, List<EventListener> eventListeners, LoggerFactory loggerFactory, boolean browserSession, Session session, int majorVersion) {
        this.sessionId = sessionId;
        this.browserContextId = browserContextId;
        this.invocationHandler = new SessionInvocationHandler(gson, webSocket, contextList, session == null ? this : session, loggerFactory.getLogger("cdp4j.ws.request"), browserSession, sessionId, targetId, sessionFactory.getWebSocketReadTimeout());
        this.targetId = targetId;
        this.sesessionFactory = sessionFactory;
        this.listeners = eventListeners;
        this.webSocket = webSocket;
        this.log = loggerFactory.getLogger("cdp4j.session");
        this.logFlow = loggerFactory.getLogger("cdp4j.flow");
        this.gson = gson;
        this.browserSession = browserSession;
        this.majorVersion = majorVersion;
        this.jsFunctions = new ConcurrentHashMap();
        this.command = new Command(this);
    }

    public String getId() {
        return this.sessionId;
    }

    @Override
    public void close() {
        this.logEntry("close");
        if (this.isConnected()) {
            try {
                this.sesessionFactory.close(this);
            }
            finally {
                this.terminate("closed");
                this.connected.set(false);
            }
        } else {
            this.dispose();
        }
    }

    public boolean isConnected() {
        return this.connected.get() && this.webSocket.isOpen();
    }

    public void activate() {
        this.logEntry("activate");
        this.sesessionFactory.activate(this.sessionId);
    }

    public void addEventListener(EventListener eventListener) {
        this.listeners.add(eventListener);
    }

    public void removeEventEventListener(EventListener eventListener) {
        if (eventListener != null) {
            this.listeners.remove(eventListener);
        }
    }

    public Session waitDocumentReady() {
        return this.waitDocumentReady(10000);
    }

    public Session waitDocumentReady(int timeout) {
        if (!this.isConnected()) {
            return this;
        }
        long start = System.currentTimeMillis();
        this.logEntry("waitDocumentReady", String.format("[timeout=%d]", timeout));
        if (this.isDomReady()) {
            return this.getThis();
        }
        CountDownLatch latch = new CountDownLatch(2);
        AtomicBoolean loaded = new AtomicBoolean(false);
        AtomicBoolean ready = new AtomicBoolean(false);
        if (this.isConnected()) {
            EventListener loadListener = (e, d) -> {
                if (Events.PageLifecycleEvent.equals((Object)e) && "load".equalsIgnoreCase(((LifecycleEvent)d).getName())) {
                    latch.countDown();
                    loaded.set(true);
                    if (this.isDomReady()) {
                        ready.set(true);
                    }
                }
            };
            this.addEventListener(loadListener);
            this.sesessionFactory.getThreadPool().execute(() -> {
                try {
                    this.waitUntil((Session s) -> !this.isConnected() || s.isDomReady() || ready.get(), timeout, false);
                }
                finally {
                    latch.countDown();
                    if (!loaded.get()) {
                        latch.countDown();
                    }
                    if (!ready.get() && this.isConnected() && this.isDomReady()) {
                        ready.set(true);
                    }
                }
            });
            try {
                latch.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e2) {
                throw new LoadTimeoutException(e2);
            }
            finally {
                this.removeEventEventListener(loadListener);
            }
            long elapsed = System.currentTimeMillis() - start;
            if (elapsed > (long)timeout && this.isConnected() && !this.isDomReady()) {
                throw new LoadTimeoutException("Page not loaded within " + timeout + " ms");
            }
        }
        return this;
    }

    private boolean waitUntil(Predicate<Session> predicate, int timeout, boolean log) {
        return this.waitUntil(predicate, timeout, 100, log);
    }

    public boolean waitUntil(Predicate<Session> predicate) {
        return this.waitUntil(predicate, 10000, 100);
    }

    public boolean waitUntil(Predicate<Session> predicate, int timeout) {
        return this.waitUntil(predicate, timeout, 100, true);
    }

    public boolean waitUntil(Predicate<Session> predicate, int timeout, int period) {
        return this.waitUntil(predicate, timeout, period, true);
    }

    public boolean waitUntil(Predicate<Session> predicate, int timeout, int period, boolean log) {
        int count = (int)Math.floor(timeout / period);
        for (int i = 0; i < count; ++i) {
            boolean wakeup = predicate.test(this.getThis());
            if (wakeup) {
                return true;
            }
            if (!this.isConnected()) {
                return false;
            }
            this.wait(period, log);
        }
        return false;
    }

    public Session navigate(String url) {
        this.logEntry("navigate", url);
        NavigateResult navigate = this.command.getPage().navigate(url);
        if (navigate == null) {
            throw new DestinationUnreachableException(url);
        }
        this.frameId = navigate.getFrameId();
        return this;
    }

    public Session navigateAndWait(String url, WaitUntil condition) {
        return this.navigateAndWait(url, condition, 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session navigateAndWait(String url, WaitUntil condition, int timeout) {
        long start = System.currentTimeMillis();
        WaitUntil waitUntil = WaitUntil.DomReady.equals((Object)condition) ? WaitUntil.Load : condition;
        this.logEntry("navigateAndWait", String.format("[url=%s, waitUntil=%s, timeout=%d]", url, condition.name(), timeout));
        NavigateResult navigate = this.command.getPage().navigate(url);
        if (navigate == null) {
            throw new DestinationUnreachableException(url);
        }
        this.frameId = navigate.getFrameId();
        CountDownLatch latch = new CountDownLatch(1);
        EventListener loadListener = (e, d) -> {
            LifecycleEvent le;
            if (Events.PageLifecycleEvent.equals((Object)e) && waitUntil.value.equals((le = (LifecycleEvent)d).getName())) {
                latch.countDown();
            }
        };
        this.addEventListener(loadListener);
        try {
            latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e2) {
            throw new LoadTimeoutException(e2);
        }
        finally {
            this.removeEventEventListener(loadListener);
        }
        long elapsedTime = System.currentTimeMillis() - start;
        if (elapsedTime > (long)timeout) {
            throw new LoadTimeoutException("Page not loaded within " + timeout + " ms");
        }
        if (WaitUntil.DomReady.equals((Object)condition) && !this.isDomReady()) {
            try {
                this.disableFlowLog();
                boolean ready = this.waitUntil((Session p) -> this.isDomReady(), timeout - (int)elapsedTime, 10);
                if (!ready) {
                    throw new LoadTimeoutException("Page not loaded within " + timeout + " ms");
                }
            }
            finally {
                this.enableFlowLog();
            }
        }
        return this;
    }

    public Session enableConsoleLog() {
        this.getCommand().getRuntime().enable();
        this.addEventListener((e, d) -> {
            if (Events.RuntimeConsoleAPICalled.equals((Object)e)) {
                ConsoleAPICalled ca = (ConsoleAPICalled)d;
                for (RemoteObject next : ca.getArgs()) {
                    Object value = next.getValue();
                    String type = ca.getType().toString().toUpperCase(Locale.ENGLISH);
                    switch (ca.getType()) {
                        case Log: 
                        case Info: {
                            this.log.info("[console] [{}] {}", type, String.valueOf(value));
                            break;
                        }
                        case Error: {
                            this.log.info("[console] [{}] {}", type, String.valueOf(value));
                            break;
                        }
                        case Warning: {
                            this.log.info("[console] [{}] {}", type, String.valueOf(value));
                            break;
                        }
                    }
                }
            }
        });
        return this.getThis();
    }

    public Session enableDetailLog() {
        this.getCommand().getLog().enable();
        this.addEventListener((e, d) -> {
            if (Events.LogEntryAdded.equals((Object)e)) {
                EntryAdded entryAdded = (EntryAdded)d;
                LogEntry entry = entryAdded.getEntry();
                String level = entry.getLevel().toString().toUpperCase(Locale.ENGLISH);
                switch (entry.getLevel()) {
                    case Verbose: {
                        this.log.info("[{}] [{}] {}", new Object[]{entry.getSource(), level, entry.getText()});
                        break;
                    }
                    case Info: {
                        this.log.info("[{}] [{}] {}", new Object[]{entry.getSource(), level, entry.getText()});
                        break;
                    }
                    case Warning: {
                        this.log.info("[{}] [{}] {}", new Object[]{entry.getSource(), level, entry.getText()});
                        break;
                    }
                    case Error: {
                        this.log.info("[{}] [{}] {}", new Object[]{entry.getSource(), level, entry.getText()});
                    }
                }
            }
        });
        return this.getThis();
    }

    public Session enableNetworkLog() {
        this.getCommand().getNetwork().enable();
        this.addEventListener((e, d) -> {
            if (Events.NetworkResponseReceived.equals((Object)e)) {
                ResponseReceived rr = (ResponseReceived)d;
                Response response = rr.getResponse();
                String url = response.getUrl();
                int status = response.getStatus();
                String mimeType = response.getMimeType();
                if (ResourceType.Document.equals((Object)rr.getType()) || ResourceType.XHR.equals((Object)rr.getType())) {
                    this.log.info("[{}] [{}] [{}] [{}] [{}]", rr.getType().toString().toUpperCase(Locale.ENGLISH), rr.getResponse().getProtocol().toUpperCase(Locale.ENGLISH), status, mimeType, url);
                }
            }
        });
        return this.getThis();
    }

    @Override
    public Session getThis() {
        return this;
    }

    public String getFrameId() {
        return this.frameId;
    }

    public byte[] captureScreenshot() {
        return this.captureScreenshot(false, ImageFormat.Png, null, null, true);
    }

    public byte[] captureScreenshot(boolean hideScrollbar) {
        return this.captureScreenshot(hideScrollbar, ImageFormat.Png, null, null, true);
    }

    public byte[] captureScreenshot(boolean hideScrollbar, @Optional ImageFormat format, @Optional Integer quality, @Optional Viewport clip, @Experimental @Optional Boolean fromSurface) {
        SourceRange location = new SourceRange();
        location.setEndColumn(0);
        location.setEndLine(0);
        location.setStartColumn(0);
        location.setStartLine(0);
        String styleSheetId = null;
        if (hideScrollbar) {
            this.getThis().getCommand().getDOM().enable();
            CSS css = this.getThis().getCommand().getCSS();
            css.enable();
            styleSheetId = css.createStyleSheet(this.frameId);
            css.addRule(styleSheetId, "::-webkit-scrollbar { display: none !important; }", location);
        }
        Page page = this.getThis().getCommand().getPage();
        GetLayoutMetricsResult metrics = page.getLayoutMetrics();
        Rect cs = metrics.getContentSize();
        Emulation emulation = this.getThis().getCommand().getEmulation();
        emulation.setDeviceMetricsOverride(cs.getWidth().intValue(), cs.getHeight().intValue(), 1.0, false);
        byte[] data = page.captureScreenshot(format, quality, clip, fromSurface);
        emulation.clearDeviceMetricsOverride();
        emulation.resetPageScaleFactor();
        if (hideScrollbar) {
            CSS css = this.getThis().getCommand().getCSS();
            css.setStyleSheetText(styleSheetId, "");
        }
        return data;
    }

    public Session wait(int timeout) {
        return this.wait(timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Session wait(int timeout, boolean log) {
        if (!this.lock.tryLock()) throw new CdpException("Unable to acquire lock");
        Condition condition = this.lock.newCondition();
        try {
            if (log) {
                this.logEntry("wait", timeout + "ms");
            }
            condition.await(timeout, TimeUnit.MILLISECONDS);
            return this.getThis();
        }
        catch (InterruptedException e) {
            if (!this.webSocket.isOpen() || !this.connected.get()) return this.getThis();
            throw new CdpException(e);
        }
        finally {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
    }

    public void onTerminate(TerminateListener terminateListener) {
        this.terminateListener = terminateListener;
    }

    public Command getCommand() {
        return this.command;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Session other = (Session)obj;
        return !(this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId));
    }

    void dispose() {
        this.proxies.clear();
        this.listeners.clear();
        this.jsFunctions.clear();
        this.invocationHandler.dispose();
        if (this.browserSession && this.webSocket.isOpen()) {
            try {
                this.webSocket.disconnect(1000, null, 1000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    Gson getGson() {
        return this.gson;
    }

    void terminate(String message) {
        if (this.terminateListener != null) {
            this.terminateListener.onTerminate(new TerminateEvent(message));
            this.terminateListener = null;
        }
    }

    void info(String message, Object ... args) {
        this.log.info(message, args);
    }

    void error(String message, Object ... args) {
        this.log.error(message, args);
    }

    void logEntry(String method) {
        this.logEntry(method, null);
    }

    void logEntry(String method, String args) {
        if (!ENABLE_ENTRY_EXIT_LOG.get().booleanValue()) {
            return;
        }
        boolean hasArgs = args != null;
        this.logFlow.info("{}({}{}{})", method, hasArgs ? "\"" : "", hasArgs ? args : "", hasArgs ? "\"" : "");
    }

    void logExit(String method, Object retValue) {
        this.logExit(method, null, retValue);
    }

    void logExit(String method, String args, Object retValue) {
        if (!ENABLE_ENTRY_EXIT_LOG.get().booleanValue()) {
            return;
        }
        boolean hasArgs = args != null;
        this.logFlow.info("{}({}{}{}): {}", method, hasArgs ? "\"" : "", hasArgs ? args : "", hasArgs ? "\"" : "", retValue);
    }

    <T> T getProxy(Class<T> klass) {
        Object proxy = this.proxies.get(klass);
        if (proxy != null) {
            return (T)proxy;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class[] interfaces = new Class[]{klass};
        proxy = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)this.invocationHandler);
        Object existing = this.proxies.putIfAbsent(klass, proxy);
        if (existing != null) {
            return (T)existing;
        }
        return (T)proxy;
    }

    void disableFlowLog() {
        ENABLE_ENTRY_EXIT_LOG.set(Boolean.FALSE);
    }

    void enableFlowLog() {
        ENABLE_ENTRY_EXIT_LOG.set(Boolean.TRUE);
    }

    WSContext getContext(int id) {
        return this.invocationHandler.getContext(id);
    }

    public <T> T registerJsFunction(Class<T> klass) {
        if (!klass.isInterface()) {
            throw new CdpException("Class must be interface: " + klass.getName());
        }
        if (Arrays.asList(klass.getMethods()).stream().filter(p -> p.isAnnotationPresent(JsFunction.class)).count() == 0L) {
            throw new CdpException("Interface must be contain at least one @JsFunction");
        }
        if (this.jsFunctions.containsKey(klass)) {
            throw new CdpException("Duplicate Registration is not allowed: " + klass);
        }
        if (this.jsFunctions.keySet().stream().filter(p -> p.getSimpleName().equals(klass.getSimpleName())).count() > 0L) {
            throw new CdpException("Duplicate class name is not allowed: " + klass.getSimpleName());
        }
        Method[] methods = klass.getMethods();
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("document.%s = document.%s || {};", klass.getSimpleName(), klass.getSimpleName()));
        for (Method next : methods) {
            JsFunction function = next.getAnnotation(JsFunction.class);
            if (function == null) continue;
            StringBuilder jsMethod = new StringBuilder();
            jsMethod.append("document.");
            jsMethod.append(klass.getSimpleName());
            jsMethod.append(".");
            jsMethod.append(next.getName());
            jsMethod.append(" = function(");
            int count = next.getParameterCount();
            StringJoiner joiner = new StringJoiner(", ");
            for (int i = 0; i < count; ++i) {
                Parameter parameter = next.getParameters()[i];
                joiner.add(parameter.getName());
            }
            jsMethod.append(joiner.toString());
            jsMethod.append(") { ");
            jsMethod.append(function.value());
            jsMethod.append(" };");
            builder.append(jsMethod.toString());
        }
        Page page = this.getCommand().getPage();
        page.enable();
        page.addScriptToEvaluateOnNewDocument(builder.toString());
        Object instance = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{klass}, (proxy, method, args) -> {
            String className = method.getDeclaringClass().getSimpleName();
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            if ((Void.TYPE.equals(returnType) || Void.class.equals(returnType)) && (args == null || args.length == 0)) {
                this.callFunction("document." + className + "." + methodName);
                return null;
            }
            Object result = this.callFunction("document." + className + "." + methodName, returnType, args);
            return result;
        });
        this.jsFunctions.put(klass, instance);
        return (T)instance;
    }

    public <T> T getJsFunction(Class<T> klass) {
        return (T)this.jsFunctions.get(klass);
    }

    boolean isPrimitive(Class<?> klass) {
        if (String.class.equals(klass)) {
            return true;
        }
        if (Boolean.TYPE.equals(klass) || Boolean.class.equals(klass)) {
            return true;
        }
        if (Void.TYPE.equals(klass) || Void.class.equals(klass)) {
            return true;
        }
        if (Integer.TYPE.equals(klass) || Integer.class.equals(klass)) {
            return true;
        }
        if (Double.TYPE.equals(klass) || Double.class.equals(klass)) {
            return true;
        }
        if (Long.TYPE.equals(klass) || Long.class.equals(klass)) {
            return true;
        }
        if (Float.TYPE.equals(klass) || Float.class.equals(klass)) {
            return true;
        }
        if (Character.TYPE.equals(klass) || Character.class.equals(klass)) {
            return true;
        }
        if (Byte.TYPE.equals(klass) || Byte.class.equals(klass)) {
            return true;
        }
        return Short.TYPE.equals(klass) || Short.class.equals(klass);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getBrowserContextId() {
        return this.browserContextId;
    }

    public Integer getExecutionContextId() {
        return this.executionContextId;
    }

    void setExecutionContextId(Integer executionContextId) {
        this.executionContextId = executionContextId;
    }

    public String toString() {
        return "Session [sessionId=" + this.sessionId + "]";
    }
}

