/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.command.DOM;
import io.webfolder.cdp.command.Runtime;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.exception.ElementNotFoundException;
import io.webfolder.cdp.session.Constant;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.type.dom.Node;
import io.webfolder.cdp.type.runtime.CallArgument;
import io.webfolder.cdp.type.runtime.CallFunctionOnResult;
import io.webfolder.cdp.type.runtime.EvaluateResult;
import io.webfolder.cdp.type.runtime.ExceptionDetails;
import io.webfolder.cdp.type.runtime.GetPropertiesResult;
import io.webfolder.cdp.type.runtime.PropertyDescriptor;
import io.webfolder.cdp.type.runtime.RemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public interface Selector {
    default public boolean matches(String selector) {
        return this.matches(selector, Constant.EMPTY_ARGS);
    }

    default public boolean matches(String selector, Object ... args) {
        return this.matches(null, selector, args);
    }

    default public boolean matches(Integer contextId, String selector, Object ... args) {
        Integer nodeId = null;
        try {
            nodeId = this.getThis().getNodeId(contextId, selector, args);
        }
        catch (CdpException e) {
            boolean notFound;
            boolean bl = notFound = e.getMessage() != null && e.getMessage().toLowerCase(Locale.ENGLISH).contains("could not find node with given id");
            if (notFound) {
                return false;
            }
            throw e;
        }
        if (nodeId == null || Constant.EMPTY_NODE_ID.equals(nodeId)) {
            return false;
        }
        boolean retValue = nodeId > 0;
        this.getThis().logExit("matches", String.format(selector, args), retValue);
        return retValue;
    }

    default public Object getProperty(String selector, String propertyName) {
        return this.getProperty(selector, propertyName, Constant.EMPTY_ARGS);
    }

    default public Object getProperty(String selector, String propertyName, Object ... args) {
        String objectId = this.getObjectId(selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        Object value = this.getPropertyByObjectId(objectId, propertyName);
        this.releaseObject(objectId);
        if (!Constant.DOM_PROPERTIES.contains(propertyName)) {
            this.getThis().logExit("getProperty", String.format(selector, args) + "\", \"" + propertyName, String.valueOf(value).replace("\n", "").replace("\r", ""));
        }
        return value;
    }

    default public void setProperty(String selector, String propetyName, Object value) {
        this.setProperty(selector, propetyName, value, Constant.EMPTY_ARGS);
    }

    default public void setProperty(String selector, String propertyName, Object value, Object ... args) {
        String objectId;
        if (!Constant.DOM_PROPERTIES.contains(propertyName)) {
            this.getThis().logEntry("setProperty", String.format(selector, new Object[0]) + "\", \"" + propertyName + "\", \"" + value);
        }
        if ((objectId = this.getObjectId(selector, args)) == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        ArrayList<CallArgument> arguments = new ArrayList<CallArgument>(2);
        CallArgument prp = new CallArgument();
        prp.setValue(propertyName);
        CallArgument val = new CallArgument();
        val.setValue(value);
        arguments.add(prp);
        arguments.add(val);
        CallFunctionOnResult callFunctionOn = this.getThis().getCommand().getRuntime().callFunctionOn("function(property, value) { function index(obj, property, value) { if (typeof property == 'string') return index(obj, property.split('.'), value); else if (property.length == 1 && value !== undefined) return obj[property[0]] = value; else if (property.length == 0) return obj; else return index(obj[property[0]], property.slice(1), value); }return index(this, property, value); }", objectId, arguments, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, null);
        String error = null;
        if (callFunctionOn != null) {
            RemoteObject exception;
            RemoteObject result = callFunctionOn.getResult();
            if (result != null) {
                this.getThis().releaseObject(result.getObjectId());
            }
            if (callFunctionOn.getExceptionDetails() != null && (exception = callFunctionOn.getExceptionDetails().getException()) != null) {
                error = exception.getDescription();
            }
        }
        this.getThis().releaseObject(objectId);
        if (error != null) {
            throw new CdpException(error);
        }
    }

    default public PropertyDescriptor getPropertyDescriptor(String objectId, String name) {
        Runtime runtime = this.getThis().getCommand().getRuntime();
        GetPropertiesResult properties = runtime.getProperties(objectId);
        if (properties == null) {
            return null;
        }
        if (properties.getResult() == null || properties.getResult().isEmpty()) {
            return null;
        }
        for (PropertyDescriptor next : properties.getResult()) {
            if (!name.equals(next.getName())) continue;
            return next;
        }
        return null;
    }

    default public Object getPropertyByObjectId(String objectId, String name) {
        if (name == null || name.trim().isEmpty()) {
            return null;
        }
        if (objectId == null || name == null) {
            return null;
        }
        ArrayList<CallArgument> arguments = new ArrayList<CallArgument>(1);
        CallArgument argProperty = new CallArgument();
        argProperty.setValue(name);
        arguments.add(argProperty);
        CallFunctionOnResult callFunctionOn = this.getThis().getCommand().getRuntime().callFunctionOn("function(property) { return property.split('.').reduce((o, i) => o[i], this); }", objectId, arguments, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, null);
        Object value = null;
        String error = null;
        if (callFunctionOn != null) {
            RemoteObject exception;
            RemoteObject result = callFunctionOn.getResult();
            if (result != null) {
                value = callFunctionOn.getResult().getValue();
                if (result != null) {
                    this.getThis().releaseObject(result.getObjectId());
                }
            }
            if (callFunctionOn.getExceptionDetails() != null && (exception = callFunctionOn.getExceptionDetails().getException()) != null) {
                error = exception.getDescription();
            }
        }
        if (error != null) {
            throw new CdpException(error);
        }
        return value;
    }

    default public List<String> getObjectIds(String selector, Object ... args) {
        ArrayList<String> objectIds;
        block7: {
            DOM dom;
            block6: {
                Boolean includeCmdApi;
                dom = this.getThis().getCommand().getDOM();
                boolean xpath = selector.charAt(0) == '/';
                objectIds = new ArrayList<String>();
                if (!xpath) break block6;
                Runtime runtime = this.getThis().getCommand().getRuntime();
                String func = "$x(\"%s\")";
                String expression = String.format("$x(\"%s\")", String.format(selector.replace("\"", "\\\""), args));
                EvaluateResult result = runtime.evaluate(expression, null, includeCmdApi = Boolean.TRUE, null, this.getThis().getExecutionContextId(), null, null, null, null, null, null);
                if (result == null) {
                    return null;
                }
                GetPropertiesResult properties = runtime.getProperties(result.getResult().getObjectId(), true, false, false);
                if (properties == null) break block7;
                for (PropertyDescriptor next : properties.getResult()) {
                    if (!next.isEnumerable().booleanValue()) continue;
                    int index = Integer.parseInt(next.getName());
                    RemoteObject remoteObject = next.getValue();
                    objectIds.add(index, remoteObject.getObjectId());
                }
                break block7;
            }
            Integer rootNodeId = dom.getDocument().getNodeId();
            if (rootNodeId == null) {
                return null;
            }
            List<Integer> nodeIds = dom.querySelectorAll(rootNodeId, String.format(selector, args));
            if (nodeIds == null || nodeIds.isEmpty()) {
                return Collections.emptyList();
            }
            for (Integer next : nodeIds) {
                RemoteObject remoteObject = dom.resolveNode(next, null, null);
                if (remoteObject == null) {
                    return null;
                }
                String objectId = remoteObject.getObjectId();
                if (objectId == null) continue;
                objectIds.add(objectId);
            }
        }
        return objectIds;
    }

    default public List<String> getObjectIds(String selector) {
        return this.getObjectIds(selector, Constant.EMPTY_ARGS);
    }

    default public String getObjectId(Integer contextId, String selector, Object ... args) {
        return this.getObjectIdWithContext(contextId, selector, args);
    }

    default public String getObjectId(String selector, Object ... args) {
        return this.getObjectIdWithContext(null, selector, args);
    }

    default public String getObjectIdWithContext(Integer contextId, String selector, Object ... args) {
        boolean xpath;
        DOM dom = this.getThis().getCommand().getDOM();
        boolean bl = xpath = selector.charAt(0) == '/';
        if (xpath) {
            RemoteObject docObjectId = null;
            if (contextId == null) {
                Node document = dom.getDocument();
                docObjectId = dom.resolveNode(document.getNodeId(), null, null);
            }
            ArrayList<CallArgument> arguments = new ArrayList<CallArgument>(2);
            CallArgument argDoc = new CallArgument();
            argDoc.setObjectId(docObjectId.getObjectId());
            arguments.add(argDoc);
            CallArgument argExpression = new CallArgument();
            argExpression.setValue(String.format(selector, args));
            arguments.add(argExpression);
            Runtime runtime = this.getThis().getCommand().getRuntime();
            String func = "function(doc, expression) { return doc.evaluate(expression, doc, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue; }";
            CallFunctionOnResult result = runtime.callFunctionOn(func, docObjectId != null ? docObjectId.getObjectId() : null, arguments, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, contextId, null);
            if (docObjectId != null) {
                this.releaseObject(docObjectId.getObjectId());
            }
            if (result == null) {
                return null;
            }
            ExceptionDetails ex = result.getExceptionDetails();
            if (ex != null && ex.getException() != null) {
                if (result.getResult() != null && result.getResult().getObjectId() != null) {
                    this.releaseObject(result.getResult().getObjectId());
                }
                if (ex.getException().getObjectId() != null) {
                    this.releaseObject(ex.getException().getObjectId());
                }
                throw new CdpException(ex.getException().getDescription());
            }
            RemoteObject remoteObject = result.getResult();
            if (remoteObject == null) {
                return null;
            }
            if (result.getResult() == null) {
                return null;
            }
            String objectId = result.getResult().getObjectId();
            return ex == null ? objectId : null;
        }
        Integer rootNodeId = dom.getDocument().getNodeId();
        if (rootNodeId == null) {
            return null;
        }
        Integer nodeId = dom.querySelector(rootNodeId, String.format(selector, args));
        if (nodeId == null || nodeId == 0) {
            return null;
        }
        RemoteObject remoteObject = dom.resolveNode(nodeId, null, null);
        if (remoteObject == null) {
            return null;
        }
        String objectId = remoteObject.getObjectId();
        if (objectId == null) {
            return null;
        }
        return objectId;
    }

    default public String getObjectId(String selector) {
        return this.getObjectId(selector, Constant.EMPTY_ARGS);
    }

    default public Integer getNodeId(Integer context, String selector, Object ... args) {
        boolean xpath;
        if (selector == null || selector.trim().isEmpty()) {
            return Constant.EMPTY_NODE_ID;
        }
        Integer nodeId = Constant.EMPTY_NODE_ID;
        DOM dom = this.getThis().getCommand().getDOM();
        boolean bl = xpath = selector.charAt(0) == '/';
        if (xpath) {
            String objectId = this.getThis().getObjectId(context, String.format(selector, args), new Object[0]);
            if (objectId != null) {
                nodeId = dom.requestNode(objectId);
                this.getThis().releaseObject(objectId);
            }
        } else {
            Integer documentNodeId;
            Node document = dom.getDocument();
            if (document != null && (documentNodeId = document.getNodeId()) != null) {
                try {
                    nodeId = dom.querySelector(documentNodeId, String.format(selector, args));
                }
                catch (CdpException e) {
                    throw new CdpException(String.format("Method invoke error: querySelector(%s). %s", String.format(selector, args), e.getMessage()));
                }
            }
        }
        return nodeId;
    }

    default public Integer getNodeId(String selector) {
        return this.getNodeId(null, selector, Constant.EMPTY_ARGS);
    }

    default public Session releaseObject(String objectId) {
        if (objectId != null) {
            this.getThis().getCommand().getRuntime().releaseObject(objectId);
        }
        return this.getThis();
    }

    public Session getThis();
}

