/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.command.Input;
import io.webfolder.cdp.session.Constant;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.type.constant.MouseButtonType;
import io.webfolder.cdp.type.constant.MouseEventType;
import io.webfolder.cdp.type.util.Point;

public interface Mouse {
    default public Session click(String selector) {
        return this.click(selector, Constant.EMPTY_ARGS);
    }

    default public Session click(String selector, Object ... args) {
        this.getThis().logEntry("click", String.format(selector, args));
        this.getThis().scrollIntoViewIfNeeded(selector, args);
        Point point = this.getThis().getClickablePoint(selector, args);
        int clickCount = 1;
        Input input = this.getThis().getCommand().getInput();
        input.dispatchMouseEvent(MouseEventType.MousePressed, point.x, point.y, null, null, MouseButtonType.Left, clickCount, null, null);
        input.dispatchMouseEvent(MouseEventType.MouseReleased, point.x, point.y, null, null, MouseButtonType.Left, clickCount, null, null);
        return this.getThis();
    }

    default public Session move(double x, double y) {
        Input input = this.getThis().getCommand().getInput();
        input.dispatchMouseEvent(MouseEventType.MouseMoved, x, y);
        return this.getThis();
    }

    public Session getThis();
}

