/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.command.Input;
import io.webfolder.cdp.session.Constant;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.type.constant.KeyEventType;

public interface Keyboard
extends Constant {
    default public Session sendKeys(String text) {
        this.getThis().logEntry("sendKeys", text);
        if (text == null) {
            return this.getThis();
        }
        Input input = this.getThis().getCommand().getInput();
        for (int i = 0; i < text.length(); ++i) {
            String c = text.substring(i, i + 1);
            input.dispatchKeyEvent(KeyEventType.KeyDown, null, null, c, null, null, null, null, null, null, null, null, null, null);
            input.dispatchKeyEvent(KeyEventType.KeyUp, null, null, c, null, null, null, null, null, null, null, null, null, null);
        }
        return this.getThis();
    }

    default public Session sendTab() {
        this.getThis().logEntry("sendTab");
        Input input = this.getThis().getCommand().getInput();
        input.dispatchKeyEvent(KeyEventType.KeyDown, null, null, null, null, null, null, "Tab", 9, 9, null, null, null, null);
        input.dispatchKeyEvent(KeyEventType.KeyUp, null, null, null, null, null, null, "Tab", 9, 9, null, null, null, null);
        return this.getThis();
    }

    default public Session sendEnter() {
        this.getThis().logEntry("sendEnter");
        Input input = this.getThis().getCommand().getInput();
        input.dispatchKeyEvent(KeyEventType.KeyDown, null, null, "\r", null, null, null, "Enter", 13, 13, null, null, null, null);
        input.dispatchKeyEvent(KeyEventType.KeyUp, null, null, null, null, null, null, "Enter", 13, 13, null, null, null, null);
        return this.getThis();
    }

    default public Session sendBackspace() {
        this.getThis().logEntry("sendBackspace");
        return this.sendKeyCode(46);
    }

    default public Session sendLeftArrow() {
        this.getThis().logEntry("sendLeftArrow");
        return this.sendKeyCode(37);
    }

    default public Session sendUpArrow() {
        this.getThis().logEntry("sendUpArrow");
        return this.sendKeyCode(38);
    }

    default public Session sendRightArrow() {
        this.getThis().logEntry("sendRightArrow");
        return this.sendKeyCode(39);
    }

    default public Session sendDownArrow() {
        this.getThis().logEntry("sendDownArrow");
        return this.sendKeyCode(40);
    }

    default public Session sendEsc() {
        this.getThis().logEntry("sendEsc");
        return this.sendKeyCode(27);
    }

    default public Session sendKeyCode(int keyCode) {
        if (!Constant.SPECIAL_KEYS.contains(keyCode)) {
            this.getThis().logEntry("sendKeyCode", String.valueOf(keyCode));
        }
        Input input = this.getThis().getCommand().getInput();
        input.dispatchKeyEvent(KeyEventType.KeyDown, null, null, null, null, null, null, null, keyCode, keyCode, null, null, null, null);
        input.dispatchKeyEvent(KeyEventType.KeyUp, null, null, null, null, null, null, null, keyCode, keyCode, null, null, null, null);
        return this.getThis();
    }

    public Session getThis();
}

