/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.command.DOM;
import io.webfolder.cdp.exception.ElementNotFoundException;
import io.webfolder.cdp.internal.gson.Gson;
import io.webfolder.cdp.session.Constant;
import io.webfolder.cdp.session.Option;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.type.dom.BoxModel;
import io.webfolder.cdp.type.runtime.CallFunctionOnResult;
import io.webfolder.cdp.type.runtime.ExceptionDetails;
import io.webfolder.cdp.type.runtime.PropertyDescriptor;
import io.webfolder.cdp.type.runtime.RemoteObject;
import io.webfolder.cdp.type.util.Point;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface Dom {
    default public String getText(String selector) {
        return this.getText(selector, Constant.EMPTY_ARGS);
    }

    default public String getText(String selector, Object ... args) {
        return (String)this.getThis().getProperty(selector, "textContent", args);
    }

    default public Session selectInputText(String selector) {
        return this.selectInputText(selector, Constant.EMPTY_ARGS);
    }

    default public Session selectInputText(String selector, Object ... args) {
        this.getThis().logEntry("selectInputText", String.format(selector, args));
        String objectId = this.getThis().getObjectId(selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        CallFunctionOnResult functionResult = this.getThis().getCommand().getRuntime().callFunctionOn("function() { this.select(); }", objectId, null, null, null, null, null, null, null, null);
        if (functionResult != null) {
            RemoteObject exception;
            ExceptionDetails exceptionDetails;
            RemoteObject result = functionResult.getResult();
            if (result != null) {
                this.getThis().releaseObject(result.getObjectId());
            }
            if ((exceptionDetails = functionResult.getExceptionDetails()) != null && (exception = exceptionDetails.getException()) != null) {
                this.getThis().error(exception.getDescription(), new Object[0]);
            }
        }
        this.getThis().releaseObject(objectId);
        return this.getThis();
    }

    default public Session focus(String selector) {
        return this.focus(null, selector);
    }

    default public Session focus(Integer contextId, String selector) {
        return this.focus(contextId, selector, Constant.EMPTY_ARGS);
    }

    default public Session focus(Integer contextId, String selector, Object ... args) {
        this.getThis().logEntry("focus", String.format(selector, args));
        Integer nodeId = this.getThis().getNodeId(contextId, selector, contextId, args);
        if (nodeId == null || Constant.EMPTY_NODE_ID.equals(nodeId)) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        DOM dom = this.getThis().getCommand().getDOM();
        dom.focus(nodeId, null, null);
        return this.getThis();
    }

    default public int getSelectedIndex(String selector) {
        return this.getSelectedIndex(selector, Constant.EMPTY_ARGS);
    }

    default public int getSelectedIndex(String selector, Object ... args) {
        String objectId = this.getThis().getObjectId(selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        Double selectedIndex = (Double)this.getThis().getPropertyByObjectId(objectId, "selectedIndex");
        this.getThis().releaseObject(objectId);
        if (selectedIndex == null) {
            selectedIndex = -1.0;
        }
        this.getThis().logExit("getSelectedIndex", String.format(selector, args), selectedIndex.intValue());
        return selectedIndex.intValue();
    }

    default public Session setSelectedIndex(String selector, int index) {
        return this.setSelectedIndex(selector, index, Constant.EMPTY_ARGS);
    }

    default public Session setSelectedIndex(String selector, int index, Object ... args) {
        String objectId;
        if (index < -1) {
            return this.getThis();
        }
        if (index != -1) {
            this.getThis().logEntry("setSelectedIndex", String.format(selector, args) + "\", \"" + index);
        }
        if ((objectId = this.getThis().getObjectId(selector, args)) == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        CallFunctionOnResult result = this.getThis().getCommand().getRuntime().callFunctionOn(String.format("function() { this.selectedIndex = %d }", index), objectId, null, null, null, null, null, null, null, null);
        if (result != null && result.getResult() != null) {
            this.getThis().releaseObject(result.getResult().getObjectId());
        }
        this.getThis().releaseObject(objectId);
        return this.getThis();
    }

    default public List<Option> getOptions(String selector) {
        return this.getOptions(selector, Constant.EMPTY_ARGS);
    }

    default public List<Option> getOptions(String selector, Object ... args) {
        String objectId = this.getThis().getObjectId(selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        PropertyDescriptor pd = this.getThis().getPropertyDescriptor(objectId, "options");
        if (pd != null && pd.getValue() != null) {
            Double length = (Double)this.getThis().getPropertyByObjectId(pd.getValue().getObjectId(), "length");
            List list = Collections.emptyList();
            if (length != null) {
                if (length.intValue() <= 0) {
                    this.getThis().releaseObject(objectId);
                } else {
                    CallFunctionOnResult result = this.getThis().getCommand().getRuntime().callFunctionOn("function() { let options = []; for (let i = 0; i < this.length; i++) { options.push({ index : this[i].index, selected: this[i].selected, value: this[i].value, text: this[i].textContent, group: this[i].parentElement.tagName=== 'OPTGROUP' ? this[i].parentElement.getAttribute('label') : null }); } return JSON.stringify(options); }", pd.getValue().getObjectId(), null, null, null, null, null, null, null, null);
                    if (result != null && result.getResult() != null) {
                        String json = (String)result.getResult().getValue();
                        this.getThis().releaseObject(result.getResult().getObjectId());
                        Gson gson = this.getThis().getGson();
                        list = (List)gson.fromJson(json, Option.TYPE_TOKEN.getType());
                    }
                }
            }
            this.getThis().releaseObject(pd.getValue().getObjectId());
            this.getThis().releaseObject(objectId);
            return list;
        }
        this.getThis().releaseObject(objectId);
        return Collections.emptyList();
    }

    default public Session clearOptions(String selector) {
        return this.clearOptions(selector, -1, Constant.EMPTY_ARGS);
    }

    default public Session clearOptions(String selector, Object ... args) {
        this.getThis().logEntry("clearOptions", String.format(selector, args));
        return this.setSelectedIndex(selector, -1, args);
    }

    default public Session setSelectedOptions(String selector, List<Integer> indexes) {
        return this.setSelectedOptions(selector, indexes, Constant.EMPTY_ARGS);
    }

    default public Session setSelectedOptions(String selector, List<Integer> indexes, Object ... args) {
        if (indexes == null) {
            return this.getThis();
        }
        String objectId = this.getThis().getObjectId(selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        this.getThis().logEntry("setSelectOptions", String.format(selector, args) + "\", \"" + Arrays.toString((Object[])indexes.toArray(new Integer[0])));
        PropertyDescriptor pd = this.getThis().getPropertyDescriptor(objectId, "options");
        if (pd != null && pd.getValue() != null) {
            Double length = (Double)this.getThis().getPropertyByObjectId(pd.getValue().getObjectId(), "length");
            if (length != null) {
                if (length.intValue() <= 0) {
                    this.getThis().releaseObject(objectId);
                } else {
                    for (Integer index : indexes) {
                        if (index > length.intValue() || index < 0) {
                            this.getThis().error("invalid index value [{}]", (int)index);
                            continue;
                        }
                        CallFunctionOnResult result = this.getThis().getCommand().getRuntime().callFunctionOn(String.format("function() { this[%d].selected = true }", index), pd.getValue().getObjectId(), null, null, null, null, null, null, null, null);
                        if (result == null || result.getResult() == null) continue;
                        this.getThis().releaseObject(result.getResult().getObjectId());
                    }
                }
            }
            this.getThis().releaseObject(pd.getValue().getObjectId());
            this.getThis().releaseObject(objectId);
            return this.getThis();
        }
        this.getThis().releaseObject(objectId);
        return this.getThis();
    }

    default public Session setFiles(String selector, Path ... files) {
        if (files == null || files.length == 0) {
            return this.getThis();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Path file : files) {
            list.add(file.toString());
        }
        return this.setFiles(selector, list.toArray(new String[0]));
    }

    default public Session setFiles(String selector, String ... files) {
        if (files == null || files.length == 0) {
            return this.getThis();
        }
        Integer nodeId = this.getThis().getNodeId(selector);
        if (nodeId == null || Constant.EMPTY_NODE_ID.equals(nodeId)) {
            throw new ElementNotFoundException(String.format(selector, new Object[0]));
        }
        this.getThis().logEntry("setFiles", String.format(selector, new Object[0]) + "\", \"" + Arrays.toString(files));
        DOM dom = this.getThis().getCommand().getDOM();
        dom.setFileInputFiles(Arrays.asList(files), nodeId, null, null);
        return this.getThis();
    }

    default public boolean isDisabled(String selector) {
        return this.isDisabled(selector, Constant.EMPTY_ARGS);
    }

    default public boolean isDisabled(String selector, Object ... args) {
        Boolean property = Boolean.TRUE.equals(this.getThis().getProperty(selector, "disabled", args));
        this.getThis().logExit("isDisabled", String.format(selector, args), (boolean)property);
        return property;
    }

    default public boolean isChecked(String selector) {
        return this.isChecked(selector, Constant.EMPTY_ARGS);
    }

    default public boolean isChecked(String selector, Object ... args) {
        Boolean property = Boolean.TRUE.equals(this.getThis().getProperty(selector, "checked", args));
        this.getThis().logExit("isChecked", String.format(selector, args), (boolean)property);
        return property;
    }

    default public Session setChecked(String selector, boolean checked) {
        return this.setChecked(selector, checked, Constant.EMPTY_ARGS);
    }

    default public Session setChecked(String selector, boolean checked, Object ... args) {
        this.getThis().logEntry("setChecked", String.format(selector, new Object[0]) + "\", \"" + checked);
        this.getThis().setProperty(selector, "checked", checked, args);
        return this.getThis();
    }

    default public Session setDisabled(String selector, boolean disabled) {
        return this.setDisabled(selector, disabled, Constant.EMPTY_ARGS);
    }

    default public Session setDisabled(String selector, boolean disabled, Object ... args) {
        this.getThis().logEntry("setDisabled", String.format(selector, new Object[0]) + "\", \"" + disabled);
        this.getThis().setProperty(selector, "disabled", disabled, args);
        return this.getThis();
    }

    default public Session setValue(String selector, Object value) {
        return this.setValue(selector, value, Constant.EMPTY_ARGS);
    }

    default public Session setValue(String selector, Object value, Object ... args) {
        return this.setAttribute(selector, "value", value, args);
    }

    default public String getValue(String selector) {
        return this.getValue(selector, Constant.EMPTY_ARGS);
    }

    default public String getValue(String selector, Object ... args) {
        String objectId = this.getThis().getObjectId(selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        String value = (String)this.getThis().getPropertyByObjectId(objectId, "value");
        this.getThis().releaseObject(objectId);
        if (value == null) {
            return null;
        }
        this.getThis().logExit("getValue", String.format(selector, args), value);
        return value;
    }

    default public Map<String, String> getAttributes(String selector) {
        return this.getAttributes(selector, Constant.EMPTY_ARGS);
    }

    default public Map<String, String> getAttributes(String selector, Object ... args) {
        return this.getAttributes(null, selector, args);
    }

    default public Map<String, String> getAttributes(Integer contextId, String selector, Object ... args) {
        Integer nodeId = this.getThis().getNodeId(contextId, selector, args);
        if (nodeId != null && nodeId > 0) {
            DOM dom = this.getThis().getCommand().getDOM();
            List<String> attributes = dom.getAttributes(nodeId);
            if (attributes.isEmpty()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(attributes.size() / 2);
            for (int i = 0; i < attributes.size(); i += 2) {
                String attrName = attributes.get(i);
                String attrValue = attributes.get(i + 1);
                map.put(attrName, attrValue);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    default public String getAttribute(String selector, String name) {
        return this.getAttribute(selector, name, Constant.EMPTY_ARGS);
    }

    default public String getAttribute(String selector, String name, Object ... args) {
        return this.getAttribute(null, selector, name, args);
    }

    default public String getAttribute(Integer contextId, String selector, String name, Object ... args) {
        if (name == null || name.trim().isEmpty()) {
            return null;
        }
        String value = this.getAttributes(contextId, String.format(selector, args), new Object[0]).get(name);
        this.getThis().logExit("getAttribute", String.format(selector, args) + "\", \"" + name, value);
        return value;
    }

    default public Session setAttribute(String selector, String name, Object value, Object ... args) {
        return this.setAttribute(null, selector, name, value, args);
    }

    default public Session setAttribute(Integer contextId, String selector, String name, Object value, Object ... args) {
        Integer nodeId = this.getThis().getNodeId(contextId, selector, args);
        if (nodeId == null || Constant.EMPTY_NODE_ID.equals(nodeId)) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        this.getThis().logEntry("setAttribute", String.format(selector, new Object[0]) + "\", \"" + name + "\", \"" + value);
        this.getThis().getCommand().getDOM().setAttributeValue(nodeId, name, value == null ? null : String.valueOf(value));
        return this.getThis();
    }

    default public Session setAttribute(String selector, String name, Object value) {
        return this.setAttribute(selector, name, value, Constant.EMPTY_ARGS);
    }

    default public BoxModel getBoxModel(String selector, Object ... args) {
        return this.getBoxModel(null, selector, args);
    }

    default public BoxModel getBoxModel(Integer contextId, String selector, Object ... args) {
        Integer nodeId = this.getThis().getNodeId(contextId, selector, args);
        if (nodeId == null || Constant.EMPTY_NODE_ID.equals(nodeId)) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        return this.getThis().getCommand().getDOM().getBoxModel(nodeId, null, null);
    }

    default public String getOuterHtml(String selector) {
        return this.getOuterHtml(selector, Constant.EMPTY_ARGS);
    }

    default public String getOuterHtml(String selector, Object ... args) {
        Integer nodeId = this.getThis().getNodeId(null, selector, args);
        return this.getThis().getCommand().getDOM().getOuterHTML(nodeId, null, null);
    }

    default public void scrollIntoViewIfNeeded(String selector) {
        this.scrollIntoViewIfNeeded(selector, Constant.EMPTY_ARGS);
    }

    default public void scrollIntoViewIfNeeded(String selector, Object ... args) {
        String objectId = this.getThis().getObjectId(selector, args);
        String fn = "function() {    var scrollIfNeeded = async function(element) {        const visibleRatio = await new Promise(resolve => {            const observer = new IntersectionObserver(entries => {                resolve(entries[0].intersectionRatio);                observer.disconnect();            });            observer.observe(element);        });        if (visibleRatio !== 1.0) element.scrollIntoView({            block: 'center',            inline: 'center',            behavior: 'instant'        });        return false;    };    return scrollIfNeeded(this);}";
        CallFunctionOnResult obj = this.getThis().getCommand().getRuntime().callFunctionOn(fn, objectId, null, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, null, null);
        if (obj != null && obj.getResult() != null) {
            this.getThis().releaseObject(obj.getResult().getObjectId());
        }
        if (objectId != null) {
            this.getThis().releaseObject(objectId);
        }
    }

    default public Point getClickablePoint(String selector) {
        return this.getClickablePoint(selector, Constant.EMPTY_ARGS);
    }

    default public Point getClickablePoint(String selector, Object ... args) {
        boolean supportsQuad;
        DOM dom = this.getThis().getCommand().getDOM();
        Integer nodeId = this.getThis().getNodeId(String.format(selector, args));
        if (nodeId == null || Constant.EMPTY_NODE_ID.equals(nodeId)) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        boolean bl = supportsQuad = this.getThis().getMajorVersion() >= 69;
        if (!supportsQuad) {
            BoxModel boxModel = dom.getBoxModel(nodeId, null, null);
            if (boxModel == null) {
                return null;
            }
            List<Double> content = boxModel.getContent();
            if (content == null || content.isEmpty() || content.size() < 2) {
                return null;
            }
            double left = Math.floor(content.get(0));
            double top = Math.floor(content.get(1));
            return new Point(left, top);
        }
        Function<List, Double> computeQuadArea = quad -> {
            Double area = 0.0;
            for (int i = 0; i < quad.size(); ++i) {
                Point p1 = (Point)quad.get(i);
                Point p2 = (Point)quad.get((i + 1) % quad.size());
                area = area + (p1.x * p2.y - p2.x * p1.y) / 2.0;
            }
            return area;
        };
        List<List<Double>> quads = dom.getContentQuads(nodeId, null, null);
        List clickableQuads = quads.stream().map(quad -> {
            ArrayList<Point> list = new ArrayList<Point>();
            list.add(new Point((Double)quad.get(0), (Double)quad.get(1)));
            list.add(new Point((Double)quad.get(2), (Double)quad.get(3)));
            list.add(new Point((Double)quad.get(4), (Double)quad.get(5)));
            list.add(new Point((Double)quad.get(6), (Double)quad.get(7)));
            return list;
        }).filter(t -> (Double)computeQuadArea.apply((List)t) > 1.0).collect(Collectors.toList());
        List quad2 = (List)clickableQuads.get(0);
        Double x = 0.0;
        Double y = 0.0;
        for (Point next : quad2) {
            x = x + next.x;
            y = y + next.y;
        }
        x = x / 4.0;
        y = y / 4.0;
        return new Point(x, y);
    }

    public Session getThis();
}

