/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.logger;

import io.webfolder.cdp.logger.CdpConsoleLogger;
import io.webfolder.cdp.logger.CdpLog4jLogger;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.logger.CdpLoggerType;
import io.webfolder.cdp.logger.CdpSlf4jLogger;
import io.webfolder.cdp.logger.LoggerFactory;

public class CdpLoggerFactory
implements LoggerFactory {
    private final CdpLoggerType loggerType;
    private static CdpLogger NULL_LOGGER = new CdpLogger(){

        @Override
        public void info(String message, Object ... args) {
        }

        @Override
        public void debug(String message, Object ... args) {
        }

        @Override
        public void error(String message, Object ... args) {
        }

        @Override
        public void warn(String message, Object ... args) {
        }

        @Override
        public void error(String message, Throwable t) {
        }
    };

    public CdpLoggerFactory() {
        this(CdpLoggerFactory.getDefaultLoggerType());
    }

    public CdpLoggerFactory(CdpLoggerType loggerType) {
        this.loggerType = loggerType;
    }

    @Override
    public CdpLogger getLogger(String name) {
        try {
            switch (this.loggerType) {
                case Slf4j: {
                    return new CdpSlf4jLogger(name);
                }
                case Console: {
                    return new CdpConsoleLogger();
                }
                case Log4j: {
                    return new CdpLog4jLogger(name);
                }
            }
            return NULL_LOGGER;
        }
        catch (Throwable e) {
            return NULL_LOGGER;
        }
    }

    public static CdpLoggerType getDefaultLoggerType() {
        CdpLoggerType cdpLoggerType = CdpLoggerType.Console;
        try {
            CdpLoggerFactory.class.getClassLoader().loadClass("org.slf4j.Logger");
            cdpLoggerType = CdpLoggerType.Slf4j;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return cdpLoggerType;
    }
}

