/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.logger;

import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.logger.FormattingTuple;
import io.webfolder.cdp.logger.MessageFormatter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class CdpLog4jLogger
implements CdpLogger {
    private final Logger logger;

    public CdpLog4jLogger(String name) {
        this.logger = Logger.getLogger((String)name);
    }

    @Override
    public void info(String message, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            this.logger.info((Object)tuple.getMessage());
        }
    }

    @Override
    public void debug(String message, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            this.logger.debug((Object)tuple.getMessage());
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            this.logger.log((Priority)Level.WARN, (Object)tuple.getMessage());
        }
    }

    @Override
    public void error(String message, Object ... args) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            this.logger.error((Object)tuple.getMessage());
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            this.logger.error((Object)message, t);
        }
    }
}

