/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.logger;

import io.webfolder.cdp.logger.CdpLogLevel;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.logger.FormattingTuple;
import io.webfolder.cdp.logger.MessageFormatter;

public class CdpConsoleLogger
implements CdpLogger {
    private final CdpLogLevel level;

    public CdpConsoleLogger() {
        this(CdpLogLevel.Info);
    }

    public CdpConsoleLogger(CdpLogLevel level) {
        this.level = level;
    }

    @Override
    public void info(String message, Object ... args) {
        if (CdpLogLevel.Info.equals((Object)this.level) || CdpLogLevel.Debug.equals((Object)this.level)) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            System.out.println("[INFO] " + tuple.getMessage());
        }
    }

    @Override
    public void debug(String message, Object ... args) {
        if (CdpLogLevel.Debug.equals((Object)this.level)) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            System.out.println("[DEBUG] " + tuple.getMessage());
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        if (CdpLogLevel.Info.equals((Object)this.level) || CdpLogLevel.Warn.equals((Object)this.level) || CdpLogLevel.Debug.equals((Object)this.level)) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            System.out.println("[WARN] " + tuple.getMessage());
        }
    }

    @Override
    public void error(String message, Object ... args) {
        if (CdpLogLevel.Info.equals((Object)this.level) || CdpLogLevel.Warn.equals((Object)this.level) || CdpLogLevel.Error.equals((Object)this.level) || CdpLogLevel.Debug.equals((Object)this.level)) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            System.out.println("[ERROR] " + tuple.getMessage());
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (CdpLogLevel.Info.equals((Object)this.level) || CdpLogLevel.Warn.equals((Object)this.level) || CdpLogLevel.Error.equals((Object)this.level) || CdpLogLevel.Debug.equals((Object)this.level)) {
            System.err.println("[ERROR] " + message);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }
}

