/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp;

import io.webfolder.cdp.CdpProcess;
import io.webfolder.cdp.ProcessManager;
import io.webfolder.cdp.exception.CdpException;
import java.util.TreeMap;
import org.jvnet.winp.WinProcess;

public class WindowsProcessManager
extends ProcessManager {
    private int pid;
    private String cdp4jId;

    @Override
    void setProcess(CdpProcess process) {
        WinProcess winProcess = new WinProcess(process.getProcess());
        this.pid = winProcess.getPid();
        this.cdp4jId = this.getCdp4jId(winProcess, 20);
        if (this.cdp4jId == null || this.cdp4jId.trim().isEmpty()) {
            throw new CdpException("cdp4jId not found");
        }
    }

    private String getCdp4jId(WinProcess process, int retryCount) {
        String id = this.getCdp4jId(process);
        if (id != null) {
            return id;
        }
        for (int i = 0; i < retryCount; ++i) {
            id = this.getCdp4jId(process);
            if (id != null) {
                return id;
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                throw new CdpException(e);
            }
        }
        return id;
    }

    private String getCdp4jId(WinProcess process) {
        String cdp4jId = null;
        try {
            TreeMap variables = process.getEnvironmentVariables();
            cdp4jId = (String)variables.get("CDP4J_ID");
        }
        catch (Throwable variables) {
            // empty catch block
        }
        if (cdp4jId != null && !cdp4jId.trim().isEmpty()) {
            return cdp4jId;
        }
        try {
            String cmd = process.getCommandLine();
            int start = cmd.indexOf("--cdp4jId=");
            if (start > 0) {
                int end = cmd.indexOf(" ", start + 1);
                if (end == -1) {
                    end = cmd.length();
                }
                cdp4jId = cmd.substring(start + "--cdp4jId=".length(), end);
            }
        }
        catch (Throwable t) {
            return null;
        }
        return cdp4jId;
    }

    @Override
    public boolean kill() {
        if (this.pid == 0 || this.cdp4jId == null || this.cdp4jId.trim().isEmpty()) {
            return false;
        }
        try {
            WinProcess process = new WinProcess(this.pid);
            if (process.isRunning()) {
                String cdp4jId = this.getCdp4jId(process, 20);
                if (cdp4jId == null || cdp4jId.trim().isEmpty()) {
                    throw new CdpException("cdp4jId not found");
                }
                if (this.pid == process.getPid() && this.cdp4jId.equals(cdp4jId)) {
                    process.killRecursively();
                    return true;
                }
                return false;
            }
        }
        finally {
            return false;
        }
        {
        }
    }
}

