/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp;

import io.webfolder.cdp.AbstractLauncher;
import io.webfolder.cdp.AdaptiveProcessManager;
import io.webfolder.cdp.CdpProcess;
import io.webfolder.cdp.ProcessManager;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.logger.CdpLoggerType;
import io.webfolder.cdp.session.SessionFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.concurrent.ThreadLocalRandom;

public class Launcher
extends AbstractLauncher {
    private static final String OS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    private static final boolean WINDOWS = OS.startsWith("windows");
    private static final boolean OSX = OS.startsWith("mac");
    private ProcessManager processManager = new AdaptiveProcessManager();

    public Launcher(CdpLoggerType loggerType) {
        this(new SessionFactory(loggerType));
    }

    public Launcher() {
        this(new SessionFactory());
    }

    public Launcher(int port) {
        this(new SessionFactory(port));
    }

    public Launcher(SessionFactory factory) {
        super(factory);
    }

    private String getCustomChromeBinary() {
        File chromeExecutable;
        String chromeBinary = System.getProperty("chrome_binary");
        if (chromeBinary != null && (chromeExecutable = new File(chromeBinary)).exists() && chromeExecutable.canExecute()) {
            return chromeExecutable.getAbsolutePath();
        }
        return null;
    }

    @Override
    public String findChrome() {
        String chromeExecutablePath = null;
        chromeExecutablePath = this.getCustomChromeBinary();
        if (chromeExecutablePath == null && WINDOWS) {
            chromeExecutablePath = this.findChromeWinPath();
        }
        if (chromeExecutablePath == null && OSX) {
            chromeExecutablePath = this.findChromeOsxPath();
        }
        if (chromeExecutablePath == null && !WINDOWS) {
            chromeExecutablePath = "google-chrome";
        }
        return chromeExecutablePath;
    }

    public String findChromeWinPath() {
        try {
            for (String path : this.getChromeWinPaths()) {
                String location;
                File chrome;
                Process process = Runtime.getRuntime().exec(new String[]{"cmd", "/c", "echo", path});
                int exitCode = process.waitFor();
                if (exitCode != 0 || !(chrome = new File(location = this.toString(process.getInputStream()).trim().replace("\"", ""))).exists() || !chrome.canExecute()) continue;
                return chrome.toString();
            }
            throw new CdpException("Unable to find chrome.exe");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected List<String> getChromeWinPaths() {
        return Arrays.asList("%localappdata%\\Google\\Chrome SxS\\Application\\chrome.exe", "%programfiles%\\Google\\Chrome\\Application\\chrome.exe", "%programfiles(x86)%\\Google\\Chrome\\Application\\chrome.exe");
    }

    public String findChromeOsxPath() {
        for (String path : this.getChromeOsxPaths()) {
            File chrome = new File(path);
            if (!chrome.exists() || !chrome.canExecute()) continue;
            return chrome.toString();
        }
        return null;
    }

    protected List<String> getChromeOsxPaths() {
        return Arrays.asList("/Applications/Google Chrome Canary.app/Contents/MacOS/Google Chrome Canary", "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome");
    }

    public SessionFactory launch(Path chromeExecutablePath, List<String> arguments) {
        return this.launch(chromeExecutablePath.toString(), arguments);
    }

    public SessionFactory launch(Path chromeExecutablePath) {
        return this.launch(chromeExecutablePath, Collections.emptyList());
    }

    @Override
    protected void internalLaunch(List<String> list, List<String> arguments) {
        boolean foundUserDataDir = arguments.stream().anyMatch(arg -> arg.startsWith("--user-data-dir="));
        if (!foundUserDataDir) {
            Path remoteProfileData = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve("remote-profile");
            list.add(String.format("--user-data-dir=%s", remoteProfileData.toString()));
        }
        if (!"localhost".equals(this.factory.getHost())) {
            list.add(String.format("--remote-debugging-address=%s", this.factory.getHost()));
        }
        try {
            String cdp4jId = Long.toHexString(ThreadLocalRandom.current().nextLong());
            list.add("--cdp4jId=" + cdp4jId);
            ProcessBuilder builder = new ProcessBuilder(list);
            builder.environment().put("CDP4J_ID", cdp4jId);
            Process process = builder.start();
            process.getOutputStream().close();
            process.getInputStream().close();
            process.getErrorStream().close();
            if (!process.isAlive()) {
                throw new CdpException("No process: the chrome process is not alive.");
            }
            this.processManager.setProcess(new CdpProcess(process, cdp4jId));
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
    }

    protected String toString(InputStream is) {
        try (Scanner scanner = new Scanner(is);){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    public void setProcessManager(ProcessManager processManager) {
        this.processManager = processManager;
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }

    @Override
    public void kill() {
        this.getProcessManager().kill();
    }
}

