/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp;

import io.webfolder.cdp.CdpProcess;
import io.webfolder.cdp.ProcessManager;
import java.time.Instant;
import java.util.Optional;

public class DefaultProcessManager
extends ProcessManager {
    protected long pid;
    protected Instant startTime;
    protected String command;

    @Override
    void setProcess(CdpProcess process) {
        ProcessHandle handle = process.getProcess().toHandle();
        ProcessHandle.Info info = handle.info();
        this.startTime = info.startInstant().get();
        this.command = info.command().get();
        this.pid = handle.pid();
    }

    @Override
    public boolean kill() {
        Optional<ProcessHandle> process = ProcessHandle.of(this.pid);
        if (process.isPresent()) {
            ProcessHandle handle = process.get();
            ProcessHandle.Info info = handle.info();
            if (handle.isAlive() && info.startInstant().isPresent() && info.startInstant().get().equals(this.startTime) && info.command().isPresent() && info.command().get().equals(this.command)) {
                handle.descendants().forEach(ph -> {
                    try {
                        if (ph.isAlive()) {
                            ph.destroyForcibly();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                return handle.destroyForcibly();
            }
        }
        return false;
    }
}

