/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp;

import io.webfolder.cdp.ChromiumVersion;
import io.webfolder.cdp.Downloader;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.logger.CdpLoggerFactory;
import io.webfolder.cdp.logger.LoggerFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;

public class ChromiumDownloader
implements Downloader {
    private static final String OS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    private static final boolean WINDOWS = ";".equals(File.pathSeparator);
    private static final boolean MAC = OS.contains("mac");
    private static final boolean LINUX = OS.contains("linux");
    private static final String DOWNLOAD_HOST = "https://storage.googleapis.com/chromium-browser-snapshots";
    private static final int TIMEOUT = 10000;
    private static final PosixFilePermission[] DECODE_MAP = new PosixFilePermission[]{PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ};
    private final CdpLogger logger;

    public ChromiumDownloader() {
        this(new CdpLoggerFactory());
    }

    public ChromiumDownloader(LoggerFactory loggerFactory) {
        this.logger = loggerFactory.getLogger("cdp4j.downloader");
    }

    @Override
    public Path download() {
        return this.download(ChromiumDownloader.getLatestVersion());
    }

    public static ChromiumVersion getLatestVersion() {
        String url = DOWNLOAD_HOST;
        if (WINDOWS) {
            url = url + "/Win_x64/LAST_CHANGE";
        } else if (LINUX) {
            url = url + "/Linux_x64/LAST_CHANGE";
        } else if (MAC) {
            url = url + "/Mac/LAST_CHANGE";
        } else {
            throw new CdpException("Unsupported OS found - " + OS);
        }
        try {
            URL u = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            if (conn.getResponseCode() != 200) {
                throw new CdpException(conn.getResponseCode() + " - " + conn.getResponseMessage());
            }
            String result = null;
            try (Scanner s = new Scanner(conn.getInputStream());){
                s.useDelimiter("\\A");
                result = s.hasNext() ? s.next() : "";
            }
            return new ChromiumVersion(Integer.parseInt(result));
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
    }

    public static Path getChromiumPath(ChromiumVersion version) {
        Path destinationRoot = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".cdp4j").resolve("chromium-" + String.valueOf(version.getRevision()));
        return destinationRoot;
    }

    public static Path getExecutable(ChromiumVersion version) {
        Path destinationRoot = ChromiumDownloader.getChromiumPath(version);
        Path executable = destinationRoot.resolve("chrome.exe");
        if (LINUX) {
            executable = destinationRoot.resolve("chrome");
        } else if (MAC) {
            executable = destinationRoot.resolve("Chromium.app/Contents/MacOS/Chromium");
        }
        return executable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path download(ChromiumVersion version) {
        String url;
        Path destinationRoot = ChromiumDownloader.getChromiumPath(version);
        Path executable = ChromiumDownloader.getExecutable(version);
        if (WINDOWS) {
            url = String.format("%s/Win_x64/%d/chrome-win.zip", DOWNLOAD_HOST, version.getRevision());
        } else if (LINUX) {
            url = String.format("%s/Linux_x64/%d/chrome-linux.zip", DOWNLOAD_HOST, version.getRevision());
        } else if (MAC) {
            url = String.format("%s/Mac/%d/chrome-mac.zip", DOWNLOAD_HOST, version.getRevision());
        } else {
            throw new CdpException("Unsupported OS found - " + OS);
        }
        try {
            URL u = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            conn.setRequestMethod("HEAD");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            if (conn.getResponseCode() != 200) {
                throw new CdpException(conn.getResponseCode() + " - " + conn.getResponseMessage());
            }
            long contentLength = conn.getHeaderFieldLong("x-goog-stored-content-length", 0L);
            String fileName = url.substring(url.lastIndexOf("/") + 1, url.lastIndexOf(".")) + "-r" + version.getRevision() + ".zip";
            Path archive = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve(fileName);
            if (Files.exists(archive, new LinkOption[0]) && contentLength != Files.size(archive)) {
                Files.delete(archive);
            }
            if (!Files.exists(archive, new LinkOption[0])) {
                this.logger.info("Downloading Chromium [revision=" + version.getRevision() + "] 0%", new Object[0]);
                u = new URL(url);
                if (conn.getResponseCode() != 200) {
                    throw new CdpException(conn.getResponseCode() + " - " + conn.getResponseMessage());
                }
                conn = (HttpURLConnection)u.openConnection();
                conn.setConnectTimeout(10000);
                conn.setReadTimeout(10000);
                Thread thread = null;
                AtomicBoolean halt = new AtomicBoolean(false);
                Runnable progress = () -> {
                    try {
                        long fileSize = Files.size(archive);
                        this.logger.info("Downloading Chromium [revision={}] {}%", version.getRevision(), Math.round(fileSize * 100L / contentLength));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                };
                try (InputStream is = conn.getInputStream();){
                    this.logger.info("Download location: " + archive.toString(), new Object[0]);
                    thread = new Thread(() -> {
                        while (true) {
                            try {
                                while (!halt.get()) {
                                    progress.run();
                                    Thread.sleep(1000L);
                                }
                            }
                            catch (Throwable throwable) {
                                continue;
                            }
                            break;
                        }
                    });
                    thread.setName("cdp4j");
                    thread.setDaemon(true);
                    thread.start();
                    Files.copy(conn.getInputStream(), archive, new CopyOption[0]);
                }
                finally {
                    if (thread != null) {
                        progress.run();
                        halt.set(true);
                    }
                }
            }
            this.logger.info("Extracting to: " + destinationRoot.toString(), new Object[0]);
            if (Files.exists(archive, new LinkOption[0])) {
                Files.createDirectories(destinationRoot, new FileAttribute[0]);
                ChromiumDownloader.unpack(archive.toFile(), destinationRoot.toFile());
            }
            if (!Files.exists(executable, new LinkOption[0]) || !Files.isExecutable(executable)) {
                throw new CdpException("Chromium executable not found: " + executable.toString());
            }
            if (!WINDOWS) {
                Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(executable, new LinkOption[0]);
                if (!permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
                    permissions.add(PosixFilePermission.OWNER_EXECUTE);
                    Files.setPosixFilePermissions(executable, permissions);
                }
                if (!permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
                    permissions.add(PosixFilePermission.GROUP_EXECUTE);
                    Files.setPosixFilePermissions(executable, permissions);
                }
            }
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
        return executable;
    }

    public static List<ChromiumVersion> getInstalledVersions() {
        Path chromiumRootPath = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".cdp4j");
        if (!Files.exists(chromiumRootPath, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try {
            List<ChromiumVersion> list = Files.list(chromiumRootPath).filter(p -> Files.isDirectory(p, new LinkOption[0])).filter(p -> p.getFileName().toString().startsWith("chromium-")).map(p -> new ChromiumVersion(Integer.parseInt(p.getFileName().toString().split("-")[1]))).collect(Collectors.toList());
            list.sort((o1, o2) -> Integer.compare(o2.getRevision(), o1.getRevision()));
            return list;
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
    }

    public static ChromiumVersion getLatestInstalledVersion() {
        List<ChromiumVersion> versions = ChromiumDownloader.getInstalledVersions();
        return !versions.isEmpty() ? versions.get(0) : null;
    }

    private static void unpack(File archive, File destionation) throws IOException {
        try (ZipFile zip = new ZipFile(archive);){
            LinkedHashMap<File, String> symLinks = new LinkedHashMap<File, String>();
            Enumeration iterator = zip.getEntries();
            String parentDirectory = ((ZipArchiveEntry)iterator.nextElement()).getName();
            while (iterator.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)iterator.nextElement();
                String name = entry.getName().substring(parentDirectory.length());
                File outputFile = new File(destionation, name);
                if (name.startsWith("interactive_ui_tests")) continue;
                if (entry.isUnixSymlink()) {
                    symLinks.put(outputFile, zip.getUnixSymlink(entry));
                } else if (!entry.isDirectory()) {
                    if (!outputFile.getParentFile().isDirectory()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    try (FileOutputStream outStream = new FileOutputStream(outputFile);){
                        IOUtils.copy((InputStream)zip.getInputStream(entry), (OutputStream)outStream);
                    }
                }
                if (entry.isUnixSymlink() || !outputFile.exists()) continue;
                try {
                    Files.setPosixFilePermissions(outputFile.toPath(), ChromiumDownloader.modeToPosixPermissions(entry.getUnixMode()));
                }
                catch (Exception outStream) {}
            }
            for (Map.Entry entry : symLinks.entrySet()) {
                try {
                    Path source = Paths.get(((File)entry.getKey()).getAbsolutePath(), new String[0]);
                    Path target = source.getParent().resolve((String)entry.getValue());
                    if (source.toFile().exists()) continue;
                    Files.createSymbolicLink(source, target, new FileAttribute[0]);
                }
                catch (Exception exception) {}
            }
        }
    }

    private static Set<PosixFilePermission> modeToPosixPermissions(int mode) {
        int mask = 1;
        EnumSet<PosixFilePermission> perms = EnumSet.noneOf(PosixFilePermission.class);
        for (PosixFilePermission flag : DECODE_MAP) {
            if ((mask & mode) != 0) {
                perms.add(flag);
            }
            mask <<= 1;
        }
        return perms;
    }
}

