/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp;

import io.webfolder.cdp.CdpProcess;
import io.webfolder.cdp.DefaultProcessManager;
import io.webfolder.cdp.LinuxProcessManager;
import io.webfolder.cdp.MacOsProcessManager;
import io.webfolder.cdp.ProcessManager;
import io.webfolder.cdp.WindowsProcessManager;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.logger.CdpLoggerFactory;
import java.io.File;
import java.util.Locale;

public class AdaptiveProcessManager
extends ProcessManager {
    private ProcessManager processManager;
    private static final String OS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    private static final boolean WINDOWS = ";".equals(File.pathSeparator);
    private static final boolean LINUX = "linux".contains(OS);
    private static final boolean MAC = OS.contains("mac");
    private static final boolean JAVA_8 = System.getProperty("java.version").startsWith("1.8.");
    private CdpLogger logger = new CdpLoggerFactory().getLogger("cdp4j.process-manager");

    public AdaptiveProcessManager() {
        if (!JAVA_8) {
            this.processManager = new DefaultProcessManager();
        } else if (WINDOWS) {
            try {
                this.processManager = new WindowsProcessManager();
            }
            catch (Throwable t) {
                this.logger.error(t.getMessage(), new Object[0]);
            }
        } else if (LINUX) {
            this.processManager = new LinuxProcessManager();
        } else if (MAC) {
            this.processManager = new MacOsProcessManager();
        } else {
            throw new CdpException(OS + " is not supported by AdaptiveProcessManager");
        }
    }

    @Override
    void setProcess(CdpProcess process) {
        this.processManager.setProcess(process);
    }

    @Override
    public boolean kill() {
        return this.processManager.kill();
    }
}

