/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp;

import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.session.SessionFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class AbstractLauncher {
    protected final SessionFactory factory;
    private volatile boolean launched;

    public AbstractLauncher(SessionFactory factory) {
        this.factory = factory;
    }

    protected List<String> getCommonParameters(String chromeExecutablePath, List<String> arguments) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(chromeExecutablePath);
        if (this.factory.getPort() > 0) {
            list.add(String.format("--remote-debugging-port=%d", this.factory.getPort()));
        }
        list.add("--disable-translate");
        list.add("--disable-extensions");
        list.add("--disable-background-networking");
        list.add("--safebrowsing-disable-auto-update");
        list.add("--disable-sync");
        list.add("--metrics-recording-only");
        list.add("--disable-default-apps");
        list.add("--mute-audio");
        list.add("--no-first-run");
        list.add("--no-default-browser-check");
        list.add("--disable-plugin-power-saver");
        list.add("--disable-popup-blocking");
        if (!arguments.isEmpty()) {
            list.addAll(arguments);
        }
        return list;
    }

    public abstract String findChrome();

    public boolean launched() {
        return this.launched;
    }

    public final SessionFactory launch() {
        return this.launch(this.findChrome(), Collections.emptyList());
    }

    public final SessionFactory launch(List<String> arguments) {
        return this.launch(this.findChrome(), arguments);
    }

    public final SessionFactory launch(String chromeExecutablePath, List<String> arguments) {
        if (chromeExecutablePath == null || chromeExecutablePath.trim().isEmpty()) {
            throw new CdpException("chrome not found");
        }
        if (!this.launched) {
            List<String> list = this.getCommonParameters(chromeExecutablePath, arguments);
            this.internalLaunch(list, arguments);
            this.launched = true;
        }
        boolean connected = this.factory.ping();
        for (int retryCount = 0; !(connected = this.factory.ping()) && retryCount < 50; ++retryCount) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!connected) {
            throw new CdpException("Unable to connect to the browser");
        }
        return this.factory;
    }

    protected abstract void internalLaunch(List<String> var1, List<String> var2);

    public abstract void kill();
}

