/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.dam.ngdm;

import com.adobe.cq.wcm.spi.AssetDelivery;
import com.day.cq.dam.api.Asset;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;

@Component(service={AssetDelivery.class})
public final class MockAssetDelivery
implements AssetDelivery {
    private static final String ASSET_DELIVERY_URL_PREFIX = "/adobe/dynamicmedia/deliver";
    static final String PARAM_PATH = "path";
    static final String PARAM_SEO_NAME = "seoname";
    static final String PARAM_FORMAT = "format";
    private static final Set<String> DISALLOWED_URL_PARAMS = Set.of("path", "seoname", "format");

    @Nullable
    public String getDeliveryURL(@NotNull Resource resource, @Nullable Map<String, Object> parameterMap) {
        if (parameterMap == null) {
            throw new IllegalArgumentException("No parameter map given.");
        }
        String path = MockAssetDelivery.getMandatoryStringParam(parameterMap, PARAM_PATH);
        String seoname = MockAssetDelivery.getMandatoryStringParam(parameterMap, PARAM_SEO_NAME);
        String format = MockAssetDelivery.getMandatoryStringParam(parameterMap, PARAM_FORMAT);
        String urlParams = parameterMap.entrySet().stream().filter(entry -> !DISALLOWED_URL_PARAMS.contains(entry.getKey()) && entry.getValue() != null).sorted(Map.Entry.comparingByKey()).map(entry -> URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode(entry.getValue().toString(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
        String assetId = MockAssetDelivery.getAssetId(path);
        StringBuilder sb = new StringBuilder();
        sb.append(ASSET_DELIVERY_URL_PREFIX).append("/").append(assetId).append("/").append(URLEncoder.encode(seoname, StandardCharsets.UTF_8)).append(".").append(URLEncoder.encode(format, StandardCharsets.UTF_8));
        if (!urlParams.isEmpty()) {
            sb.append("?").append(urlParams);
        }
        return sb.toString();
    }

    @NotNull
    private static String getMandatoryStringParam(@NotNull Map<String, Object> parameterMap, @NotNull String paramName) {
        Object value = parameterMap.get(paramName);
        if (value == null) {
            throw new IllegalArgumentException("Missing parameter: " + paramName);
        }
        return value.toString();
    }

    public static String getAssetId(@NotNull Asset asset) {
        return MockAssetDelivery.getAssetId(asset.getPath());
    }

    public static String getAssetId(@NotNull String path) {
        return DigestUtils.md5Hex((String)path);
    }
}

